#include	<stdio.h>
#include	<ctype.h>
#include	<wchar.h>
#include	<windows.h>

#include	"BSCommon.h"
#include	"Bookmark.h"
#include	"encutil.h"
#include	"encutil2.h"
#include	"url.h"
#include	"bslib.h"
#include	"BSStringHolder.h"
#include	"NTfunction.h"

#include	"Bookmark.h"
#include	"MozillaBookmark.h"
#include	"OperaBookmark.h"
#include	"IeUtil.h"

#include	"CoreUtil.h"
#include	"TreeWriter.h"
#include	"messages.h"

/**
 * RXgN^
 *
 */
TreeWriter::TreeWriter()
{
	mbPath = NULL;
	wcPath = NULL;

	try{
		mbPath = new char[BUFLEN];
		if (mbPath == NULL){
			return;
		}
		wcPath = new wchar_t[BUFLEN];
		if (wcPath == NULL){
			delete []mbPath;
			return;
		}
		memset(mbPath,0x00,sizeof(char) * BUFLEN);
		memset(wcPath,0x00,sizeof(wchar_t) * BUFLEN);

	} catch (...) {
		if (wcPath == NULL) {
			delete[]wcPath;
		}

		if (mbPath != NULL){
			delete []mbPath;
		}
		return;
	}
	//wcscpy(wcPath,L"\\\\?\\d:\\test\\fav");

	// s̏
	level = 0;	// ݂̊Kwx
	mbLevel = 0;	// }`oCg̊Kwx
	wcLevel = 0;	// Ch̊Kwx

	ignore = false;
	ignoreLevel = -1;

	// c[ւ̏ݏ
	noIElink = false;			// IẼN𖳎邩H
	browserType = 0;			// uEU̎
	browserNo = 0;				// uEU̔ԍ
	updateMode = false;			// XV㏑H
	noIEname = false;			// IEp̖OϊsȂ
	treatAsVistaLink = false;	// VistãNƂĈB
	mbFolderNameMax = BUFLEN;	// tH_ǉƂ̍ő咷(}`oCg)
							// \.url\0̕cČB
	wcFolderNameMax = BUFLEN;	// tH_ǉƂ̍ő咷(wchar_t)
	mbBookmarkNameMax = BUFLEN - 1;	// ubN}[NǉƂ̍ő咷(}`oCg)
	wcBookmarkNameMax = BUFLEN - 1;	// ubN}[NǉƂ̍ő咷(wchar_t)
	mbFavoriteFolderLen = 0;	// IÊCɓtH_̒(}`oCg)
	wcFavoriteFolderLen = 0;	// IÊCɓtH_̒(wchar_t)

	attributeTarget = -1;
	noNameFlag = false;
	folderType = Bookmark::normalFolder;
	mainBrowser = false;	// ҏWΏۃuEUł͂ȂB
	needSleep = true;
}

/**
 * fXgN^
 *
 */
TreeWriter::~TreeWriter()
{
	if (wcPath != NULL){
		delete []wcPath;
	}
	if (mbPath != NULL){
		delete []mbPath;
	}
}

/**
 * KwxZbgB
 *
 */
void TreeWriter::reset()
{
	level = 0;	// ݂̊Kwx
	mbLevel = 0;	// }`oCg̊Kwx
	wcLevel = 0;	// Ch̊Kwx

	ignore = false;
	ignoreLevel = -1;

	mbPath[0] = '\0';
	wcPath[0] = L'\0';
}

/**
 * ubN}[Nc[IuWFNgݒ肷B
 *
 * @param bmTree ubN}[Nc[IuWFNg
 */
void TreeWriter::setBookmarkTree(BookmarkTree *bmTree)
{
	m_bmTree = bmTree;

}

/**
 * pXɑ΂ăx[XpX̒ݒ肷B
 * (IÊCɓ𓯊ۂɁAIÊCɓtH_̒̕B)
 *
 * @param mbLength }`oCg̒
 * @param wcLength Ch̒
 */
void TreeWriter::setBasePathLength(const int mbLength,const int wcLength)
{
	mbFavoriteFolderLen = mbLength;	// IÊCɓtH_̒(}`oCg)
	wcFavoriteFolderLen = wcLength;	// IÊCɓtH_̒(wchar_t)
}

/**
 * XV`FbNL[ƂȂ鎞擾B
 *
 * @param bookmark XV`FbNL[擾ubN}[N
 * @return XV`FbNL[ƂȂ鎞
 */
INT_TIME_T TreeWriter::updateKeyTime(Bookmark *bookmark)
{
	INT_TIME_T keyTime = 0;

	switch (browserType){
		case BOOKMARK_TYPE_IE:	// IE
		case BOOKMARK_TYPE_EDGE:
			keyTime = bookmark->getAdddate();
			break;
		case BOOKMARK_TYPE_MOZILLA:	// Mozilla
			keyTime = bookmark->getAdddate();
			if (keyTime < (INT_TIME_T)bookmark->getLastvisit()){
				keyTime = (INT_TIME_T)bookmark->getLastvisit();
			}
			if (keyTime < (INT_TIME_T)bookmark->getModified()){
				keyTime = (INT_TIME_T)bookmark->getModified();
			}
			break;
		case BOOKMARK_TYPE_OPERA:	// Opera
			keyTime = bookmark->getAdddate();
			if (keyTime < (INT_TIME_T)bookmark->getLastvisit()){
				keyTime = bookmark->getLastvisit();
			}
			break;
		case BOOKMARK_TYPE_FIREFOX:	// Firefox 3
			keyTime = bookmark->getAdddate();
			if (keyTime < (INT_TIME_T)bookmark->getLastvisit()){
				keyTime = (INT_TIME_T)bookmark->getLastvisit();
			}
			if (keyTime < (INT_TIME_T)bookmark->getModified()){
				keyTime = (INT_TIME_T)bookmark->getModified();
			}
			break;
		case BOOKMARK_TYPE_SAFARI:	// Safari
			keyTime = 0;
			break;
		case BOOKMARK_TYPE_CHROME:	// Chrome
			keyTime = bookmark->getAdddate();
			if (keyTime < (INT_TIME_T)bookmark->getModified()){
				keyTime = (INT_TIME_T)bookmark->getModified();
			}
			break;
		case BOOKMARK_TYPE_XBEL:	// XBEL
			// {͎񂪑݂邪AႪȂ̂ŎbIɎԂȂ
			keyTime = 0;
			break;
#ifdef WITH_OP15
		case BOOKMARK_TYPE_OPERA15:	// Opera 15 Speed Dial
			keyTime = 0;
			break;
#endif	// WITH_OP15
		case BOOKMARK_TYPE_OPERA25:	// Opera 25
			keyTime = bookmark->getAdddate();
			if (keyTime < (INT_TIME_T)bookmark->getModified()){
				keyTime = (INT_TIME_T)bookmark->getModified();
			}
			break;
		case BOOKMARK_TYPE_VIVALDI:	// Vivaldi
			keyTime = bookmark->getAdddate();
			if (keyTime < (INT_TIME_T)bookmark->getModified()) {
				keyTime = (INT_TIME_T)bookmark->getModified();
			}
			break;
		case BOOKMARK_TYPE_EDGE2:	// Edge(Chromium)
			keyTime = bookmark->getAdddate();
			if (keyTime < (INT_TIME_T)bookmark->getModified()) {
				keyTime = (INT_TIME_T)bookmark->getModified();
			}
			break;
	}
	return keyTime;

}

/**
 * ubN}[NXVꂽǂmFB
 *
 * @param prevBookmark ܂ł̃ubN}[N
 * @param newBookmark ꂩi[ubN}[N
 * @return false:XVĂȂ true:XVꂽ
 */
bool TreeWriter::checkUpdate(Bookmark *prevBookmark,Bookmark *newBookmark)
{
	// XV[hIt̏ꍇ͏ɍXVꂽubN}[NƂĈB
	if (updateMode == false){
		return true;
	}

	// ҏWΏۂ̃uEŨubN}[N͏ɍXVꂽubN}[NƂĈB
	if (mainBrowser) {
		return true;
	}

	// Safari/Opera 15͎񂪂Ȃ̂ōXVƂB
	if ((browserType == BOOKMARK_TYPE_SAFARI)
#ifdef WITH_OP15
		|| (browserType == BOOKMARK_TYPE_OPERA15)
#endif	// WITH_OP15
	) {
		return true;
	}

	INT_TIME_T prevKey = 0;	// i[ς݃ubN}[ÑL[ƂȂ鎞
	INT_TIME_T newKey = 0;	// VubN}[ÑL[ƂȂ鎞

	prevKey = updateKeyTime(prevBookmark);
	newKey = updateKeyTime(newBookmark);

	if (prevKey < newKey){
		return true;
	}else{
		return false;
	}
}

/**
 * ܂ł̃ubN}[N̍쐬VubN}[NɔfB
 *
 * @param prevBookmark ܂ł̃ubN}[N
 * @param newBookmark ꂩi[ubN}[N
 */
void TreeWriter::setAddDate(Bookmark *prevBookmark,Bookmark *newBookmark)
{
	// ܂ł̃ubN}[Nɍ쐬Ȃꍇ͉ȂB
	if (prevBookmark->getAdddate() == 0){
		return;
	}

	if (newBookmark->getAdddate() != 0){
		// ̃ubN}[Nɍ쐬ꍇ
		// ܂ł̃ubN}[N̂قŒǉĂVubN}[NɔfȂB
		if ((INT_TIME_T)newBookmark->getAdddate() < (INT_TIME_T)prevBookmark->getAdddate()){
			return;
		}
	}
	// i[ubN}[N̎܂܂ł̃ubN}[NɔfB
	prevBookmark->setAdddate(newBookmark->getAdddate());
}

/**
 * 𔽉f悤[U[IubN}[NH
 *
 * @param attributeTarget [U[IubN}[N̒ʂԍ
 * @return true:݂̃ubN}[N[U[Î̂ł
 *         false:݂̃ubN}[N̓[U[Î̂łȂ
 */
bool TreeWriter::isPreferedBookmark(int attributeTarget)
{
	int type = 0;
	int subNo = 0;

	if (attributeTarget == 0) {
		return false;
	}

	// 
	type = totalNoToType(attributeTarget);
	// Tuԍ
	subNo = totalNoToSubNo(attributeTarget);

	if ((type == browserType) && (subNo == browserNo)) {
		return true;
	} else {
		return false;
	}
}

/**
 * [U[w葮(EV[gJbg)ݒ肷B
 * ΏۂɎw肵uEÛ̂ÂƂɐݒsB
 *
 * @param to ݒ̃ubN}[N
 * @param from ݒ茳̃ubN}[N
 */
void TreeWriter::setUserAttribute(Bookmark *to,Bookmark *from)
{
	// 
	if (isPreferedBookmark(attributeTarget) || (to->getDescription() == NULL)){
		if (from->getDescription() != NULL){
			to->setDescription(from->getDescription());
		}
	}

	// V[gJbg/jbNl[
	if (isPreferedBookmark(attributeTarget) || (to->getShortcut() == NULL)){
		if (from->getShortcut() != NULL){
			to->setShortcut(from->getShortcut());
		}
	}

}

/**
 * uEUŗLݒ肷B
 *
 * @param to ݒ̃ubN}[N
 * @param from ݒ茳̃ubN}[N
 */
void TreeWriter::copyBrowserAttribute(Bookmark *to,Bookmark *from)
{
	IeBookmark *ieFrom,*ieTo;
	MozillaBookmark *mozFrom,*mozTo;
	OperaBookmark *opeFrom,*opeTo;
	FxBookmark *fxFrom,*fxTo;
	SafariBookmark *sfFrom,*sfTo;
	ChromeBookmark *chFrom,*chTo;
	Op25Bookmark *op25From, *op25To;
	ViBookmark *viFrom, *viTo;
	Edge2Bookmark *edge2From, *edge2To;

	switch (browserType){
		case BOOKMARK_TYPE_IE:	// IE
			ieTo = to->getIeBookmark();
			ieFrom = from->getIeBookmark();
			
			*ieTo = *ieFrom;
			to->setAttributeFlag(BOOKMARK_IE,true);
			break;
		case BOOKMARK_TYPE_MOZILLA:	// Mozilla
			mozTo = to->getMozillaBookmark(browserNo);
			mozFrom = from->getMozillaBookmark(browserNo);
			*mozTo = *mozFrom;

			// ЕMozillaɂlɐݒ肷B
			mozTo = to->getMozillaBookmark(1 - browserNo);
			*mozTo = *mozFrom;

			to->setAttributeFlag(BOOKMARK_MOZILLA_1 + browserNo,true);
			break;
		case BOOKMARK_TYPE_OPERA:	// Opera
			opeTo = to->getOperaBookmark(browserNo);
			opeFrom = from->getOperaBookmark(browserNo);
			*opeTo = *opeFrom;

			// ЕOperaɂlɐݒ肷B
			opeTo = to->getOperaBookmark(1 - browserNo);
			*opeTo = *opeFrom;

			to->setAttributeFlag(BOOKMARK_OPERA_1 + browserNo,true);
			break;
		case BOOKMARK_TYPE_FIREFOX:	// Firefox 3
			fxTo = to->getFxBookmark(browserNo);
			fxFrom = from->getFxBookmark(browserNo);
			*fxTo = *fxFrom;

			// ЕFirefoxɂlɐݒ肷B
			fxTo = to->getFxBookmark(1 - browserNo);
			fxTo->copyWithoutId(fxFrom);

			to->setAttributeFlag(BOOKMARK_FIREFOX_1 + browserNo,true);
			break;
		case BOOKMARK_TYPE_SAFARI:	// Safari
			sfTo = to->getSafariBookmark(browserNo);
			sfFrom = from->getSafariBookmark(browserNo);
			*sfTo = *sfFrom;

			// ЕSafariɂlɐݒ肷B
			sfTo = to->getSafariBookmark(1 - browserNo);
			*sfTo = *sfFrom;

			to->setAttributeFlag(BOOKMARK_SAFARI_1 + browserNo,true);
			break;
		case BOOKMARK_TYPE_CHROME:	// Chrome
			chTo = to->getChromeBookmark(browserNo);
			chFrom = from->getChromeBookmark(browserNo);
			*chTo = *chFrom;

			// ЕChromeɂlɐݒ肷B
			chTo = to->getChromeBookmark(1 - browserNo);
			chTo->copyWithoutId(chFrom);

			to->setAttributeFlag(BOOKMARK_CHROME_1 + browserNo,true);
			break;
		case BOOKMARK_TYPE_XBEL:	// XBEL
			to->setAttributeFlag(BOOKMARK_XBEL_1 + browserNo,true);
			break;
#ifdef WITH_OP15
		case BOOKMARK_TYPE_OPERA15:	// Opera 15
			to->setAttributeFlag(BOOKMARK_OPERA15_1 + browserNo,true);
			break;
#endif	// WITH_OP15
		case BOOKMARK_TYPE_OPERA25:	// Opera 25
			op25To = to->getOp25Bookmark(browserNo);
			op25From = from->getOp25Bookmark(browserNo);
			*op25To = *op25From;

			// ЕOperaɂlɐݒ肷B
			op25To = to->getOp25Bookmark(1 - browserNo);
			op25To->copyWithoutId(op25From);

			to->setAttributeFlag(BOOKMARK_OPERA25_1 + browserNo, true);
			break;
		case BOOKMARK_TYPE_VIVALDI:	// Vivaldi
			viTo = to->getViBookmark(browserNo);
			viFrom = from->getViBookmark(browserNo);
			*viTo = *viFrom;

			// ЕVivaldiɂlɐݒ肷B
			viTo = to->getViBookmark(1 - browserNo);
			viTo->copyWithoutId(viFrom);

			to->setAttributeFlag(BOOKMARK_VIVALDI_1 + browserNo, true);
			break;
		case BOOKMARK_TYPE_EDGE2:	// Edge(Chromium)
			edge2To = to->getEdge2Bookmark(browserNo);
			edge2From = from->getEdge2Bookmark(browserNo);
			*edge2To = *edge2From;

			// ЕChromeɂlɐݒ肷B
			edge2To = to->getEdge2Bookmark(1 - browserNo);
			edge2To->copyWithoutId(edge2From);

			to->setAttributeFlag(BOOKMARK_CHROME_1 + browserNo, true);
			break;
	}
}

/**
 * uEUŗLݒ肷B(ubN}[Ng̎ʏ)
 *
 * @param to ݒ̃ubN}[N
 * @param from ݒ茳̃ubN}[N
 */
void TreeWriter::copyWithoutId(Bookmark *to, Bookmark *from)
{
	IeBookmark *ieFrom, *ieTo;
	MozillaBookmark *mozFrom, *mozTo;
	OperaBookmark *opeFrom, *opeTo;
	FxBookmark *fxFrom, *fxTo;
	SafariBookmark *sfFrom, *sfTo;
	ChromeBookmark *chFrom, *chTo;
	Op25Bookmark *op25From, *op25To;
	ViBookmark *viFrom, *viTo;
	Edge2Bookmark *edge2From, *edge2To;

	switch (browserType){
		case BOOKMARK_TYPE_IE:	// IE
			ieTo = to->getIeBookmark();
			ieFrom = from->getIeBookmark();

			*ieTo = *ieFrom;
			to->setAttributeFlag(BOOKMARK_IE, true);
			break;
		case BOOKMARK_TYPE_MOZILLA:	// Mozilla
			mozTo = to->getMozillaBookmark(browserNo);
			mozFrom = from->getMozillaBookmark(browserNo);
			*mozTo = *mozFrom;

			// ЕMozillaɂlɐݒ肷B
			mozTo = to->getMozillaBookmark(1 - browserNo);
			*mozTo = *mozFrom;

			to->setAttributeFlag(BOOKMARK_MOZILLA_1 + browserNo, true);
			break;
		case BOOKMARK_TYPE_OPERA:	// Opera
			opeTo = to->getOperaBookmark(browserNo);
			opeFrom = from->getOperaBookmark(browserNo);
			*opeTo = *opeFrom;

			// ЕOperaɂlɐݒ肷B
			opeTo = to->getOperaBookmark(1 - browserNo);
			*opeTo = *opeFrom;

			to->setAttributeFlag(BOOKMARK_OPERA_1 + browserNo, true);
			break;
		case BOOKMARK_TYPE_FIREFOX:	// Firefox 3
			fxTo = to->getFxBookmark(browserNo);
			fxFrom = from->getFxBookmark(browserNo);
			*fxTo = *fxFrom;

			// ЕFirefoxɂ͎ʏȊOݒ肷B
			fxTo = to->getFxBookmark(1 - browserNo);
			fxTo->copyWithoutId(fxFrom);

			to->setAttributeFlag(BOOKMARK_FIREFOX_1 + browserNo, true);
			break;
		case BOOKMARK_TYPE_SAFARI:	// Safari
			sfTo = to->getSafariBookmark(browserNo);
			sfFrom = from->getSafariBookmark(browserNo);
			*sfTo = *sfFrom;

			// ЕSafariɂlɐݒ肷B
			sfTo = to->getSafariBookmark(1 - browserNo);
			*sfTo = *sfFrom;

			to->setAttributeFlag(BOOKMARK_SAFARI_1 + browserNo, true);
			break;
		case BOOKMARK_TYPE_CHROME:	// Chrome
			chTo = to->getChromeBookmark(browserNo);
			chFrom = from->getChromeBookmark(browserNo);
			*chTo = *chFrom;

			// ЕChromeɂ͎ʏȊOݒ肷B
			chTo = to->getChromeBookmark(1 - browserNo);
			chTo->copyWithoutId(chFrom);

			to->setAttributeFlag(BOOKMARK_CHROME_1 + browserNo, true);
			break;
		case BOOKMARK_TYPE_XBEL:	// XBEL
			to->setAttributeFlag(BOOKMARK_XBEL_1 + browserNo, true);
			break;
#ifdef WITH_OP15
		case BOOKMARK_TYPE_OPERA15:	// Opera 15
			to->setAttributeFlag(BOOKMARK_OPERA15_1 + browserNo, true);
			break;
#endif	// WITH_OP15
		case BOOKMARK_TYPE_OPERA25:	// Opera 25
			op25To = to->getOp25Bookmark(browserNo);
			op25From = from->getOp25Bookmark(browserNo);
			*op25To = *op25From;

			// ЕOpera 25̃ubN}[Nɂ͎ʏȊOݒ肷B
			op25To = to->getOp25Bookmark(1 - browserNo);
			op25To->copyWithoutId(op25From);

			to->setAttributeFlag(BOOKMARK_OPERA25_1 + browserNo, true);
			break;
		case BOOKMARK_TYPE_VIVALDI:	// Vivaldi
			viTo = to->getViBookmark(browserNo);
			viFrom = from->getViBookmark(browserNo);
			*viTo = *viFrom;

			// ЕOpera 25̃ubN}[Nɂ͎ʏȊOݒ肷B
			viTo = to->getViBookmark(1 - browserNo);
			viTo->copyWithoutId(viFrom);

			to->setAttributeFlag(BOOKMARK_VIVALDI_1 + browserNo, true);
			break;
		case BOOKMARK_TYPE_EDGE2:	// Edge(Chromium)
			edge2To = to->getEdge2Bookmark(browserNo);
			edge2From = from->getEdge2Bookmark(browserNo);
			*edge2To = *edge2From;

			// ЕChromeɂ͎ʏȊOݒ肷B
			edge2To = to->getEdge2Bookmark(1 - browserNo);
			edge2To->copyWithoutId(edge2From);

			to->setAttributeFlag(BOOKMARK_EDGE2_1 + browserNo, true);
			break;
	}
}

/**
 * g̃uEUŗL݂̂ݒ肷B
 *
 * @param to ݒ̃ubN}[N
 * @param from ݒ茳̃ubN}[N
 */
void TreeWriter::copyBrowserAttributeSelf(Bookmark *to,Bookmark *from)
{
	IeBookmark *ieFrom,*ieTo;
	MozillaBookmark *mozFrom,*mozTo;
	OperaBookmark *opeFrom,*opeTo;
	FxBookmark *fxFrom,*fxTo;
	SafariBookmark *sfFrom,*sfTo;
	ChromeBookmark *chFrom,*chTo;
#ifdef WITH_OP15
	Op15Bookmark *op15From,*op15To;
#endif	// WITH_OP15
	Op25Bookmark *op25From, *op25To;
	ViBookmark *viFrom, *viTo;
	Edge2Bookmark *edge2From, *edge2To;

	switch (browserType){
		case BOOKMARK_TYPE_IE:	// IE
			ieTo = to->getIeBookmark();
			ieFrom = from->getIeBookmark();
			
			*ieTo = *ieFrom;
			to->setAttributeFlag(BOOKMARK_IE, true);
			break;
		case BOOKMARK_TYPE_MOZILLA:	// Mozilla
			mozTo = to->getMozillaBookmark(browserNo);
			mozFrom = from->getMozillaBookmark(browserNo);
			*mozTo = *mozFrom;

			break;
		case BOOKMARK_TYPE_OPERA:	// Opera
			opeTo = to->getOperaBookmark(browserNo);
			opeFrom = from->getOperaBookmark(browserNo);
			*opeTo = *opeFrom;

			break;
		case BOOKMARK_TYPE_FIREFOX:	// Firefox 3
			fxTo = to->getFxBookmark(browserNo);
			fxFrom = from->getFxBookmark(browserNo);
			*fxTo = *fxFrom;

			break;
		case BOOKMARK_TYPE_SAFARI:	// Safari
			sfTo = to->getSafariBookmark(browserNo);
			sfFrom = from->getSafariBookmark(browserNo);
			*sfTo = *sfFrom;

			break;
		case BOOKMARK_TYPE_CHROME:	// Chrome
			chTo = to->getChromeBookmark(browserNo);
			chFrom = from->getChromeBookmark(browserNo);
			*chTo = *chFrom;

			break;
#ifdef WITH_OP15
		case BOOKMARK_TYPE_OPERA15:	// Opera 15
			op15To = to->getOp15Bookmark(browserNo);
			op15From = from->getOp15Bookmark(browserNo);
			*op15To = *op15From;

			break;
#endif	// WITH_OP15
		case BOOKMARK_TYPE_OPERA25:	// Opera 25
			op25To = to->getOp25Bookmark(browserNo);
			op25From = from->getOp25Bookmark(browserNo);
			*op25To = *op25From;

			break;
		case BOOKMARK_TYPE_VIVALDI:	// Vivaldi
			viTo = to->getViBookmark(browserNo);
			viFrom = from->getViBookmark(browserNo);
			*viTo = *viFrom;

			break;
		case BOOKMARK_TYPE_EDGE2:	// Edge(Chromium)
			edge2To = to->getEdge2Bookmark(browserNo);
			edge2From = from->getEdge2Bookmark(browserNo);
			*edge2To = *edge2From;

			break;
	}
}

/**
* ubN}[Nʏݒ肷B
*
* @param to ݒ̃ubN}[N
* @param from ݒ茳̃ubN}[N
*/
void TreeWriter::copyBookmarkIdentifier(Bookmark *to, Bookmark *from)
{
	FxBookmark *fxFrom, *fxTo;
	ChromeBookmark *chFrom, *chTo;
	Op25Bookmark *op25From, *op25To;
	Edge2Bookmark *edge2From, *edge2To;

	switch (browserType){
#if 0
		case BOOKMARK_TYPE_FIREFOX:	// Firefox 3
			fxTo = to->getFxBookmark(browserNo);
			fxFrom = from->getFxBookmark(browserNo);
			fxTo->copyBookmarkIdentifier(fxFrom);

			break;
#endif
		case BOOKMARK_TYPE_CHROME:	// Chrome
			chTo = to->getChromeBookmark(browserNo);
			chFrom = from->getChromeBookmark(browserNo);
			chTo->copyBookmarkIdentifier(chFrom);

			break;
		case BOOKMARK_TYPE_OPERA25:	// Opera 25
			op25To = to->getOp25Bookmark(browserNo);
			op25From = from->getOp25Bookmark(browserNo);
			op25To->copyBookmarkIdentifier(op25From);

			break;
		case BOOKMARK_TYPE_EDGE2:	// Edge(Chromium)
			edge2To = to->getEdge2Bookmark(browserNo);
			edge2From = from->getEdge2Bookmark(browserNo);
			edge2To->copyBookmarkIdentifier(edge2From);

			break;
	}
}

/**
 * OperãubN}[NŗL̏̂Â̂ϊB
 *
 * @param target ΏۂƂȂubN}[N
 */
void TreeWriter::convertOperaAttribute(Bookmark *target)
{
	MozillaBookmark *mozTo;
	OperaBookmark *opeFrom,*opeTo;
	FxBookmark *fxTo;

	opeFrom = target->getOperaBookmark(browserNo);
	opeTo = target->getOperaBookmark(1 - browserNo);
	*opeTo = *opeFrom;

	// -> Mozilla
	for (int i = 0;i < 2;i++) {
		mozTo = target->getMozillaBookmark(i);
		mozTo->setWebPanel(opeFrom->getInPanel());
	}

	// -> Firefox 3
	for (int i = 0;i < 2;i++) {
		fxTo = target->getFxBookmark(i);
		fxTo->setWebPanel(opeFrom->getInPanel());
	}
}

/**
 * uEUŗL̏̂Â̂ϊB
 *
 * @param target ΏۂƂȂubN}[N
 */
void TreeWriter::convertBrowserAttribute(Bookmark *target)
{
	switch (browserType){
		case BOOKMARK_TYPE_IE:	// IE
			break;
		case BOOKMARK_TYPE_MOZILLA:	// Mozilla
			target->setAttributeFlag(BOOKMARK_MOZILLA_1 + browserNo,true);
			break;
		case BOOKMARK_TYPE_OPERA:	// Opera
			convertOperaAttribute(target);
			target->setAttributeFlag(BOOKMARK_OPERA_1 + browserNo,true);
			break;
		case BOOKMARK_TYPE_FIREFOX:	// Firefox 3
			target->setAttributeFlag(BOOKMARK_FIREFOX_1 + browserNo,true);
			break;
	}
}


/**
 * Ɋi[ubN}[N̒ǉs
 *
 * @param bookmark i[ubN}[N
 * @return 0:i[ 1:i[s
 */
int TreeWriter::addBookmark(Bookmark *bookmark)
{
	Bookmark *bm;

	try{
		bm = new Bookmark(*bookmark);
		if (bm == NULL){
			return 1;
		}
	}catch(...){
		return 1;
	}
	int result = m_bmTree->storeItem(wcPath,bm);	// QƃJEg1
	if (result){
		// i[Ɏs炻ŔB
		return 1;
	}
	fprintf(stdout,"[addBookmark]OK..%s\n",bookmark->getName());

	// ̃Rs[
	copyBrowserAttribute(bm,bookmark);

	return result;
}

/**
 * Ɋi[ubN}[N̍XVs
 *
 * @param stored łɓɊi[ꂽubN}[N
 * @param bookmark XVẽubN}[N
 */
void TreeWriter::updateBookmark(Bookmark *stored,Bookmark *bookmark)
{
	bool isIEFavbar = false;

	// IÊCɓo[ǂ̏c߁A
	// ǂ炩IÊCɓo[ǂ̏cB
	if (stored->isIEToolbar()) {
		isIEFavbar = true;
	}
	if (bookmark->isIEToolbar()) {
		isIEFavbar = true;
	}
	if (browserType == BOOKMARK_TYPE_OPERA25) {
		// Opera 25̓tH_͕KcB
		copyWithoutId(stored, bookmark);
	}

	// łɊi[Ăꍇ
	// XV`FbNB
	if (checkUpdate(stored,bookmark)){
		// XVĂ
		setAddDate(stored,bookmark);	// ǉ̔f
		// ̃ubN}[Nւ̏̃Rs[
		// A(ݒς)AAV[gJbg̓Rs[ȂB
		stored->copyWithoutUserAttribute(*bookmark);

		// XVsƂ͎g̑̃Rs[sB
		copyWithoutId(stored, bookmark);

	}else{
		// XVĂȂꍇ
		if (bookmark->getItemType() == Bookmark::bookmark){
			if (stored->getURL() != NULL && bookmark->getURL() != NULL){
				if (!strcmp(stored->getURL(),bookmark->getURL())) {
					// IE/SeaMonkey,Mozilla,Netscape 7̃ACR
					// URL̂Ƃݒ肷B
					if (stored->getIcon() == NULL){
						if (bookmark->getIcon() != NULL){
							stored->setIcon(bookmark->getIcon());
						}
					}
					int totalNo = toTotal(browserType, browserNo);

					if (!stored->getAttributeFlag(totalNo)) {
						// ̃Rs[URL
						// XVɂđݒ肳ĂȂꍇ̂ݍsB
						copyBrowserAttributeSelf(stored,bookmark);
					}
				}
			}
		} else {
			// ̃tH_̏ꍇ͎g̑cB
			copyBrowserAttributeSelf(stored,bookmark);
		}

	}
	copyBookmarkIdentifier(stored, bookmark);

	// tH_̏ꍇ͉ʂ̃tH_ւ̈ړ
	if (bookmark->getItemType() == Bookmark::folder){
		m_bmTree->downFolder();
	}
	// ƃV[gJbgɊւ鏈
	setUserAttribute(stored,bookmark);

	if (isIEFavbar) {
		// IÊCɓo[ǂ̏cB
		stored->setIEToolbar(true);
	}
}

/**
 * ubN}[Ni[B<br>
 * łɊi[ς݂̃ubN}[Nꍇ͏Rs[XVB
 *
 * @param stored i[ς݂̃ubN}[N
 * @param bookmark i[ubN}[N
 * @return 0:i[ 1:i[s
 */
int TreeWriter::storeDuplicate(Bookmark *stored, Bookmark *bookmark)
{
	int result = 0;

	if (!leaveDuplicateName) {
		// URLقȂ閼OdubN}[NcȂꍇ
		// ubN}[NuB
		updateBookmark(stored,bookmark);
		return 0;
	}

	if (bookmark->getName() == NULL) {
		updateBookmark(stored,bookmark);
		return 0;
	}
	if (bookmark->getIeName() == NULL) {
		updateBookmark(stored,bookmark);
		return 0;
	}
	if (bookmark->getIeNameW() == NULL) {
		updateBookmark(stored,bookmark);
		return 0;
	}
	// _xxt邱ƂōőpX𒴂ꍇ͍XVB
	size_t wcLen = wcslen(wcPath);
	if ((wcLen + 3) > wcFolderNameMax) {
		updateBookmark(stored,bookmark);
		return 0;
	}

	if (strcmp(stored->getURL(), bookmark->getURL())) {
		// ňقȂURL̏ꍇAϖĎcB
		char buf[256];
		char buf2[256];
		char buf3[256];
		wchar_t bufW[256];
		wchar_t bufW2[256];
		int suffix = 0;
		memset(buf,0,256);
		memset(buf2,0,256);
		memset(bufW,0,256 * sizeof(wchar_t));
		do {
			suffix++;
			sprintf(buf3,"_%02d",suffix);
			wcscpy(bufW2,mbtowcInternal(buf3));

			strncpy(buf,bookmark->getName(),252);
			strcat(buf,buf3);
			strncpy(buf2,bookmark->getIeName(),252);
			strcat(buf2,buf3);
			wcsncpy(bufW,bookmark->getIeNameW(),252);
			wcscat(bufW,bufW2);

			stored = m_bmTree->getBookmark(bufW,false);
			if (stored != NULL) {
				if ((stored->getURL() != NULL) && (bookmark->getURL() != NULL)) {
					if (!strcmp(stored->getURL(), bookmark->getURL())) {
						bookmark->setName(buf);
						bookmark->setIeName(buf2);
						bookmark->setIeNameW(bufW);
						mbstrncatFit((unsigned char *)mbPath,(unsigned char *)buf3,mbFolderNameMax);
						wcsncatFit(wcPath,bufW2,wcFolderNameMax);
						break;
					}
				}
			}
		} while (stored != NULL);
		if (stored == NULL) {
			// OςubN}[N
			// URL̃ubN}[N݂Ȃꍇ
			// ǉs
			bookmark->setName(buf);
			bookmark->setIeName(buf2);
			bookmark->setIeNameW(bufW);
			mbstrncatFit((unsigned char *)mbPath,(unsigned char *)buf3,mbFolderNameMax);
			wcsncatFit(wcPath,bufW2,wcFolderNameMax);
			result = addBookmark(bookmark);
		} else {
			// OςubN}[N
			// URL̃ubN}[N݂ꍇ
			// XVs
			updateBookmark(stored,bookmark);
		}
	} else {
		// URL̏ꍇ͍XVsB
		updateBookmark(stored,bookmark);
	}
	return result;
}

/**
 * ubN}[Ni[B<br>
 * łɊi[ς݂̃ubN}[Nꍇ͏Rs[XVB
 *
 * @param wcPath ̃tpX
 * @param bookmark i[ubN}[N
 * @return 0:i[ 1:i[s
 */
int TreeWriter::store(wchar_t *wcPath,Bookmark *bookmark)
{
	Bookmark *stored = NULL;	// łɊi[ꂽubN}[NtH_
	
	// łɊi[ꂽubN}[N݂邩ǂH
	if (bookmark->getItemType() == Bookmark::folder){
		switch (bookmark->getFolderType()) {
			case Bookmark::menuBar:	// ubN}[Nj[tH_
			case Bookmark::toolBar:	// c[o[tH_
			case Bookmark::unFiled:	// unfiledtH_
			case Bookmark::mobile:	// oC̃ubN}[NtH_
				stored = m_bmTree->getFolderByAttribute(bookmark->getFolderType());
				break;
			case Bookmark::normalFolder:
				stored = m_bmTree->getBookmark(bookmark->getIeNameW(),true);
				break;

		}
	}else{
		stored = m_bmTree->getBookmark(bookmark->getIeNameW(),false);
	}
	
	int result = 0;
	if ((stored == NULL) || ((bookmarkFromCount == 1) && (bookmark->getItemType() == Bookmark::bookmark)) ){
		// ܂i[ĂȂꍇ́A
		// ϊ̃ubN}[N1ŃubN}[N̏ꍇ(̓ubN}[N)
		// ǉsB
		result = addBookmark(bookmark);
	}else{
		// URLႤƂ͎cĂȂB
		if (bookmark->getItemType() == Bookmark::folder) {
			// łɊi[Ăꍇ
			// XVs
			updateBookmark(stored,bookmark);
		} else {
			if ((stored->getURL() != NULL) && (bookmark->getURL() != NULL)) {
				result = storeDuplicate(stored,bookmark);
			} else {
				// łɊi[Ăꍇ
				// XVs
				updateBookmark(stored,bookmark);
			}
		}
	}
	return result;
}

/**
 * NtH_̐ݒ
 *
 * @param bookmark ubN}[NIuWFNg
 * @param mode true:NtH_ł false:NtH_ł͂Ȃ
 */
void TreeWriter::setLinkFolder(Bookmark *bookmark,bool mode)
{
	switch (browserType){
		case BOOKMARK_TYPE_IE:	// IE͉Ȃ
		case BOOKMARK_TYPE_EDGE:	// Edge͉Ȃ
			break;
		case BOOKMARK_TYPE_MOZILLA:	// Mozilla
			bookmark->getMozillaBookmark(browserNo)->setLinkbarFolder(
				mode ? 1 : 0);
			break;
		case BOOKMARK_TYPE_OPERA:	// Opera
			break;
	}

}

// ---------------------------------------------------
// pXɊւ鏈
// pX̒ɋNIÊCɓ̕
// ̃ubN}[N̕킹B
// ---------------------------------------------------

/**
 * tH_pXɉB
 *
 * @param bookmark ubN}[NIuWFNg
 */
void TreeWriter::addFolderName(Bookmark *bookmark)
{
	bool addInternalName = true;

	if (level == 0) {
		switch(bookmark->getFolderType()) {
			case Bookmark::menuBar:
				// ubN}[Nj[g̎̂ݓpX̑h
				// tH_0ɂB
				addInternalName = false;
				break;
		}
	}

	// őfBNgɎ܂悤ɕϊB
	size_t lenBefore = strlen(mbPath);
	mbstrncatFit((unsigned char *)mbPath,(unsigned char *)"\n",mbFolderNameMax - 1);
	if (bookmark->getIeName() != NULL){
		if (addInternalName) {
			mbstrncatFit((unsigned char *)mbPath,(unsigned char *)bookmark->getIeName(),mbFolderNameMax);
		}
	}
	size_t lenAfter = strlen(mbPath);
	// pX̊Kw̌vZ
	if (lenBefore < lenAfter){
		mbLevel++;

		if (addInternalName) {
			// ŃtH_ł؂B
			size_t addLength = lenAfter - lenBefore - 1;
			char *mp = bookmark->getIeName();
			if (mp != NULL){
				mp[addLength] = '\0';
			}
		}
	}


	// őfBNgɎ܂悤ɕϊB
	lenBefore = wcslen(wcPath);
	wcsncatFit(wcPath,L"\n",wcFolderNameMax - 1);
	if (bookmark->getIeNameW() != NULL){
		if (addInternalName) {
			wcsncatFit(wcPath,bookmark->getIeNameW(),wcFolderNameMax);
		}
	}
	lenAfter = wcslen(wcPath);
	// pX̊Kw̌vZ
	if (lenBefore < lenAfter){
		wcLevel++;

		if (addInternalName) {
			// ŃtH_ł؂B
			size_t addLength = lenAfter - lenBefore - 1;
			wchar_t *wp = bookmark->getIeNameW();
			if (wp != NULL){
				wp[addLength] = L'\0';
			}
		}
	}

	// IẼNtH_(IẼNɌŗLȂ̂łŔ)
	if (noNameChange(bookmark) == false){	// IEΏۂɓĂƂsB
		// IE𖳎邩ǂ̔
		if (noIElink && (level == 1)){
			if (!_stricmp(IElinkDir,mbPath + 1)){
				ignore = true;
				ignoreLevel = level;
			}
		}
	}

	level = level + 1;
}

/**
 * tH_pXɉB
 *
 * @param bookmark ubN}[NIuWFNg
 */
void TreeWriter::addBookmarkName(Bookmark *bookmark)
{
	// pX̐
	size_t lenBefore = strlen(mbPath);
	// tH_؂
	mbstrncatFit((unsigned char *)mbPath,(unsigned char *)"\n",mbBookmarkNameMax - 1);
	// ubN}[N
	if (bookmark->getIeName() != NULL){
		mbstrncatFit((unsigned char *)mbPath,(unsigned char *)bookmark->getIeName(),mbBookmarkNameMax);
	}
	size_t lenAfter = strlen(mbPath);

	if (lenBefore < lenAfter){
		// ŃubN}[Nł؂B
		size_t addLength = lenAfter - lenBefore - 1;
		char *mp = bookmark->getIeName();
		if (mp != NULL){
			mp[addLength] = '\0';
		}
	}

	// pX̐
	lenBefore = wcslen(wcPath);
	// tH_؂
	wcsncatFit(wcPath,L"\n",wcBookmarkNameMax - 1);
	// ubN}[N
	if (bookmark->getIeNameW() != NULL){
		wcsncatFit(wcPath,bookmark->getIeNameW(),wcBookmarkNameMax);
	}
	lenAfter = wcslen(wcPath);

	if (lenBefore < lenAfter){
		// ŃubN}[Nł؂B
		size_t addLength = lenAfter - lenBefore - 1;
		wchar_t *wp = bookmark->getIeNameW();
		if (wp != NULL){
			wp[addLength] = L'\0';
		}
	}
}

// -------------------------------------
// tH_EubN}[NɊւ鏈
// -------------------------------------

/**
 * ȏ̐ݒ<br>
 * IẼNo[tH_Ƃ̓Ȃǒʏ̏ƈقȂʂȏsB
 *
 * @param bookmark ubN}[NIuWFNg
 */
void TreeWriter::setSpecialInformation(Bookmark *bookmark)
{
	if (bookmark->getItemType() == Bookmark::folder) {
		if (level == 0) {
			// ݂̃tH_tH_̎ނݒ肷B
			folderType = bookmark->getFolderType();

			// j[o[zȊOׂẴtH_o͂ȂꍇIE܂Ȃ
			if ((folderType != Bookmark::menuBar) && !allPut) {
				// IẼt@CK𗘗pȂ͗płt@C̒L΂
				mbFolderNameMax = BUFLEN;	// tH_ǉƂ̍ő咷(}`oCg)
				wcFolderNameMax = BUFLEN;	// tH_ǉƂ̍ő咷(wchar_t)
				mbBookmarkNameMax = BUFLEN - 1;	// ubN}[NǉƂ̍ő咷(}`oCg)
				wcBookmarkNameMax = BUFLEN - 1;	// ubN}[NǉƂ̍ő咷(wchar_t)
			} else {
				// j[o[ׂ͂ẴtH_o͂Ƃ
				// IEނۂōő啶ωB
				if (noIEname) {
					// IẼt@CK𗘗pȂ͗płt@C̒L΂
					mbFolderNameMax = BUFLEN;	// tH_ǉƂ̍ő咷(}`oCg)
					wcFolderNameMax = BUFLEN;	// tH_ǉƂ̍ő咷(wchar_t)
					mbBookmarkNameMax = BUFLEN - 1;	// ubN}[NǉƂ̍ő咷(}`oCg)
					wcBookmarkNameMax = BUFLEN - 1;	// ubN}[NǉƂ̍ő咷(wchar_t)
				} else {
					// ő啶̌vZ
					// +2͍ŏ̃ubN}[Nj[tH_̋؂
					// IÊCɓtH_̌\̕

					// tH_ǉƂ̍ő咷(}`oCg)
					// \.url\0̕cČB
					mbFolderNameMax = 247 - mbFavoriteFolderLen + 2;
					// tH_ǉƂ̍ő咷(wchar_t)
					wcFolderNameMax = 247 - wcFavoriteFolderLen + 2;
					// ubN}[NǉƂ̍ő咷(}`oCg)
					mbBookmarkNameMax = MAX_PATH - mbFavoriteFolderLen - 5 + 2;
					// ubN}[NǉƂ̍ő咷(wchar_t)
					wcBookmarkNameMax = MAX_PATH - wcFavoriteFolderLen - 5 + 2;
				}
			}
		}
	} else {
		// ubN}[NŏʂɗƂ̓tH_^CvZbgA
		// 񒷂IE܂ȂƂ̒ɐݒ肷B
		// (SafarĩubN}[N(RNV)pAFirefox 3ɂH)
		if (level == 0) {
			folderType = Bookmark::topFolder;

			// IẼt@CK𗘗pȂ͗płt@C̒L΂
			mbFolderNameMax = BUFLEN;	// tH_ǉƂ̍ő咷(}`oCg)
			wcFolderNameMax = BUFLEN;	// tH_ǉƂ̍ő咷(wchar_t)
			mbBookmarkNameMax = BUFLEN - 1;	// ubN}[NǉƂ̍ő咷(}`oCg)
			wcBookmarkNameMax = BUFLEN - 1;	// ubN}[NǉƂ̍ő咷(wchar_t)
		}
	}
}

/**
 * t@CEtH_ϊsvǂ肷B
 *
 * @return true:t@CEtH_ϊ͕sv false:t@CEtH_ϊKv
 */
bool TreeWriter::noNameChange(Bookmark *bookmark)
{
	// IEϊɗ܂ȂƂ͏true
	if (noIEname) {
		return true;
	}

	// j[o[zȊȌꍇIE܂Ȃ̂ŕϊsv
	if ((folderType != Bookmark::menuBar) && !allPut) {
		return true;
	}

	// j[o[tH_gϊsv
	if ((level == 0) &&
		(bookmark->getItemType() == Bookmark::folder) &&
		(bookmark->getFolderType() == Bookmark::menuBar)) {
		return true;
	}
	return false;
}

/**
 * IEŎgȂt@CEtH_ϊB
 *
 * @param bookmark ϊΏۂ̃ubN}[NIuWFNg
 */
void TreeWriter::changeInvalidName(Bookmark *bookmark)
{
	// IẼt@CgȂ(IEϊΏۂɓĂȂ)ꍇ
	// t@CEtH_̕̕ϊsȂB
	if (noNameChange(bookmark)){
		return;
	}
	// IEŎgȂEt@Cl[̃`FbNsB
	changeIeInvalidName(bookmark);

}

/**
 * IEŎgȂt@CEtH_ϊB(Ch)
 *
 * @param bookmark ϊΏۂ̃ubN}[NIuWFNg
 */
void TreeWriter::changeInvalidNameW(Bookmark *bookmark)
{
	// IẼt@CgȂ(IEϊΏۂɓĂȂ)ꍇ
	// t@CEtH_̕̕ϊsȂB
	if (noNameChange(bookmark)){
		return;
	}

	// IEŎgȂEt@Cl[̃`FbNsB
	changeIeInvalidNameW(bookmark);
}

/**
 * IẼNtH_ȂǓʂȏ̂tH_ύXB
 *
 * @param tH_ύXΏۂ̃ACe
 * @return true:tH_ύXꂽ false:tH_͕ύXȂB
 */
bool TreeWriter::changeFolderName(Bookmark *bookmark)
{
	bool changed = false;

	// IẼt@CgȂ(IEϊΏۂɓĂȂ)ꍇ
	// tH_̕̕ϊsȂB
	if (noNameChange(bookmark) == false){
		// Windows VistaIE7
		// ubN}[Nj[̈ԍŏ̊Kw"N"tH_ɓ
		// LinksɓǂݑւB(Ȃ񂾂AB)
		if ((getIeMajorVersion() < 8)
			&& (gWindowsMajorVersion > 5)
			&& (level == 1)
			&& (folderType == Bookmark::menuBar)) {

			if (treatAsVistaLink){	// ǂݑւŝݓǂݑւsB
				if (bookmark->getIeNameW() != NULL) {
					if (!wcscmp(bookmark->getIeNameW(),IE7_LINK_NAME_JP_W)){
						bookmark->setIeName(IE7_LINK_NAME);
						bookmark->setIeNameW(IE7_LINK_NAME_W);
						changed = true;
					}
				}
			}
		}

		if (bookmark->getIeName() != NULL){
			// 낪.ŏIꍇ.폜B
			trimLastPeriod((unsigned char *)bookmark->getIeName());
			trimLastPeriodW(bookmark->getIeNameW());

			if (isNoname(bookmark->getIeName())){
				// 󔒂݂̂̃t@C
				bookmark->setIeName(NONAME);
				bookmark->setIeNameW(NONAMEW);
				noNameFlag = true;
				changed = true;
			}
		}else{
			bookmark->setIeName(NONAME);
			bookmark->setIeNameW(NONAMEW);
			noNameFlag = true;
			changed = true;
		}

		// IẼtH_͌̋󔒂Ȃߍ폜B
		trimLastSpace((unsigned char *)bookmark->getIeName());
		trimLastSpaceW(bookmark->getIeNameW());
	}else{
		// ĂȂ󕶎B
		if (bookmark->getIeName() == NULL){
			bookmark->setIeName("");
			bookmark->setIeNameW(L"");
		}
	}
	return changed;
}

/**
 * w̃oCgjIɂ炷
 *
 * @param str Ώە
 * @param count 炷
 */
void TreeWriter::shiftString(char *str, int count)
{
	char *p;

	p = str;
	while(*(p + count)) {
		*p = *(p + count);
		p++;
	}
	*p = *(p + count);
}

/**
 * t@C̃Xy[X̐KjIɍsB<br>
 * ͓{ꂪ݂ł͂Ȃ̂ŁAXy[X݂̂ŗǂƎvB
 *
 * @param name t@C
 */
void TreeWriter::normalizeSpace(char *name)
{
	bool spaceFlag = false;
	char *p;
	int spaceWidth;

	p = name;
	while(*p) {
		spaceWidth = isSpaceType(p);
		if (spaceWidth) {
			if (spaceFlag) {
				// ߂Xy[XōĂуXy[Xo
				// Xy[X̕炷
				shiftString(p, spaceWidth);
				continue;
			} else {
				spaceFlag = true;
				*p = ' ';
				if (spaceWidth > 1) {
					shiftString(p + 1, spaceWidth - 1);
				}
			}
		} else {
			spaceFlag = false;
		}
		p++;
	}
}

/**
 * t@C̃Xy[X̐KjIɍsB<br>
 * ͓{ꂪ݂ł͂Ȃ̂ŁAXy[X݂̂ŗǂƎvB
 *
 * @param name t@C
 */
void TreeWriter::normalizeSpace(wchar_t *name)
{
	bool spaceFlag = false;
	wchar_t *p;
	wchar_t *pn;

	p = name;
	while(*p) {
		if (isSpaceTypeW(p)) {
			if (spaceFlag) {
				// ߂Xy[XōĂуXy[XoB
				pn = p;
				// ꂼ1炷
				while(*pn) {
					*pn = *(pn + 1);
					pn++;
				}
				continue;
			} else {
				spaceFlag = true;
				*p = L' ';
			}
		} else {
			spaceFlag = false;
		}
		p++;
	}
}

/**
 * ubN}[N𐳋KB
 *
 * @param bookmark ΏۂƂȂubN}[N
 * @return 0:I(G[ɂ鎞̂߂ɗ\񂷂B)
 */
int TreeWriter::normalizeName(Bookmark *bookmark)
{
	if (!normalize) {
		// KsȂꍇ͉ȂB
		return 0;
	}

	char *name = bookmark->getName();
	if (name != NULL) {
		normalizeSpace(name);
	}

	wchar_t *ieNameW = bookmark->getIeNameW();
	if (ieNameW != NULL) {
		normalizeSpace(ieNameW);
	}

	char *ieName = bookmark->getIeName();
	if (ieName != NULL) {
		normalizeSpace(ieName);
	}
	return 0;
}

/**
 * tH_̎ޓɂăubN}[NEtH_ς鏈̓
 *
 * @param bookmark ΏۂƂȂubN}[N
 * @return 0:I(G[ɂ鎞̂߂ɗ\񂷂B)
 */
int TreeWriter::modifyName(Bookmark *bookmark)
{
	// OύXǂH
	bool nameChanged = false;

	normalizeName(bookmark);

	// IẼNtH_Ȃǂ̏Ԃɉȏs
	setSpecialInformation(bookmark);

	// IEpɃt@CϊB(t@Cgps)
	if (bookmark->getIeName() != NULL){
		changeInvalidName(bookmark);
	}
	if (bookmark->getIeNameW() != NULL){
		changeInvalidNameW(bookmark);
	}

	if (bookmark->getItemType() == Bookmark::folder) {
		// tH_̏ꍇ
		nameChanged = changeFolderName(bookmark);
	} else {
		// ubN}[N̏ꍇ
		// OȂubN}[N̏
		if (bookmark->getIeName() != NULL){
			if (isNoname(bookmark->getIeName())){
				// 󔒂̏ꍇ̓t@C.urlƂB
				bookmark->setIeName("");
				bookmark->setIeNameW(L"");
			}
		}else{
			bookmark->setIeName("");
			bookmark->setIeNameW(L"");
		}
	}
	return 0;
}

/**
 * ubN}[NBOOKLISTɊi[B
 *
 * @param path pXւ̃|C^
 * @param bookmark ubN}[Ni[\̂ւ̃pX
 * @return 0 i[ 1 i[s
 */
int TreeWriter::storeItem(Bookmark *bookmark)
{
	//	Bookmark *bm;

	//	printf("storeItem %s\n\n",bookmark->getName());
	bool mbCatFlag = false;	// ubN}[Nǂ(}`oCg)
	bool wcCatFlag = false;	// ubN}[Nǂ(Ch)

	// tH_̎ޓɂĖOύXB
	modifyName(bookmark);

	// pXǉ
	if (bookmark->getItemType() == Bookmark::folder){
		// tH_ɑ΂鏈sB
		addFolderName(bookmark);
	}else{
		// ubN}[Nɑ΂鏈sB
		size_t lenBefore = strlen(mbPath);
		size_t lenBeforeW = wcslen(wcPath);

		addBookmarkName(bookmark);

		size_t lenAfter = strlen(mbPath);
		size_t lenAfterW = wcslen(wcPath);
		// pX̊Kw̌vZ
		if (lenBefore < lenAfter){
			mbCatFlag = true;
		}

		// pX̊Kw̌vZ
		if (lenBeforeW < lenAfterW){
			wcCatFlag = true;
		}
	}

	// i[sB
	int result = 0;
	// tH_sĂ邩ǂɂďςĂB
	if (ignore == false){
		result = store(wcPath,bookmark);
	}else{
		// tH_͊i[ƂB
		result = 0;
	}

	// pX폜
	if (bookmark->getItemType() == Bookmark::bookmark){
		// \nȉ̃t@CB
		if (mbCatFlag){	// }`oCg̃ubN}[NpXɕǉꍇ
			cutLastEndl(mbPath);
		}
		if (wcCatFlag){	// Ch̃ubN}[NpXɕǉꍇ
			cutLastWchar(wcPath , L'\n');
		}
	}

	if (result){
		char buf[BUFLEN + 256];
		const char *p;
		
		if (bookmark->getItemType() == Bookmark::folder){
			p = TreeWriter_message[1];
		}else{
			p = TreeWriter_message[0];
		}
		if (bookmark->getName() != NULL){
			sprintf(buf,p,bookmark->getName());
		}else{
			sprintf(buf,p,NONAME);
		}
		putMessage(buf);
	}

	// CPUׂ邽߁AxɈxSleepB
	if (needSleep) {
		Sleep(0);
		needSleep = false;
	} else {
		needSleep = true;
	}

//	printf("storeItem End.%s\n\n",bookmark->getName());

	return result;

}

/**
 * ubN}[NBOOKLISTɊi[B(QƃJEgt)
 *
 * @param path pXւ̃|C^
 * @param bookmark ubN}[Ni[\̂ւ̃pX
 * @return 0 i[ 1 i[s
 */
int TreeWriter::storeItemWithRefer(Bookmark *bookmark)
{
	bool mbCatFlag = false;	// ubN}[Nǂ(}`oCg)
	bool wcCatFlag = false;	// ubN}[Nǂ(Ch)

	// tH_̎ޓɂĖOύXB
	modifyName(bookmark);

	if (bookmark->getItemType() == Bookmark::folder){
		// tH_ɑ΂鏈sB
		addFolderName(bookmark);
	}else{
		// ubN}[Nɑ΂鏈sB
		size_t lenBefore = strlen(mbPath);
		size_t lenBeforeW = wcslen(wcPath);

		addBookmarkName(bookmark);

		size_t lenAfter = strlen(mbPath);
		size_t lenAfterW = wcslen(wcPath);
		// pX̊Kw̌vZ
		if (lenBefore < lenAfter){
			mbCatFlag = true;
		}

		// pX̊Kw̌vZ
		if (lenBeforeW < lenAfterW){
			wcCatFlag = true;
		}
	}

	Bookmark *bm;
	// BookmarkRs[B
	try{
		bm = new Bookmark(*bookmark);
		if (bm == NULL){
			return 1;
		}
		// ̃Rs[
		MozillaBookmark *mozFrom,*mozTo;
		OperaBookmark *opeFrom,*opeTo;
		switch (browserType){
			case BOOKMARK_TYPE_MOZILLA:	// Mozilla
				mozTo = bm->getMozillaBookmark(browserNo);
				mozFrom = bookmark->getMozillaBookmark(browserNo);
				
				*mozTo = *mozFrom;
				break;
			case BOOKMARK_TYPE_OPERA:	// Opera
				opeTo = bm->getOperaBookmark(browserNo);
				opeFrom = bookmark->getOperaBookmark(browserNo);
				
				*opeTo = *opeFrom;
				break;
		}
	}catch(...){
		return 1;
	}
	
	int result = m_bmTree->storeItemWithRefer(wcPath,bm);

	if (bookmark->getItemType() == Bookmark::bookmark){
		// \nȉ̃t@CB
		if (mbCatFlag){	// }`oCg̃ubN}[NpXɕǉꍇ
			cutLastEndl(mbPath);
		}
		if (wcCatFlag){	// Ch̃ubN}[NpXɕǉꍇ
			cutLastWchar(wcPath , L'\n');
		}
	}

	if (result){
		char buf[BUFLEN + 256];
		const char *p;
		
		if (bookmark->getItemType() == Bookmark::folder){
			p = TreeWriter_message[1];
		}else{
			p = TreeWriter_message[0];
		}
		if (bookmark->getName() != NULL){
			sprintf(buf,p,bookmark->getName());
		}else{
			sprintf(buf,p,NONAME);
		}
		putMessage(buf);
	}
	// CPUׂ邽߁AxɈxSleepB
	if (needSleep) {
		Sleep(0);
		needSleep = false;
	} else {
		needSleep = true;
	}

	return result;

}

/**
 * tH_ւ̊i[IƂ̏
 *
 */
void TreeWriter::upFolder(void) 
{
	// tH_Kwi[IuWFNg̃tH_1i߂B
	m_bmTree->upFolder();

	// tH_̊Kw߂B
	level--;

	// tH_sĂꍇ
	if (ignore){
		// tH_n߂KwɒBĂtH_sȂ悤ɂB
		if (level == ignoreLevel){
			ignore = false;
		}
	}

	// pX폜
	// g̎tH_߂B
	// mbLevel,wcLevel̓pXł+1Ă̂ŁA
	// pXׂlevel+1ɂȂĂB
	if (level == (mbLevel - 1)){
		cutLastEndl(mbPath);
		mbLevel--;
	}
	if (level == (wcLevel - 1)){
		cutLastWchar(wcPath , L'\n');
		wcLevel--;
	}
}

/**
 * ubN}[Nj[̃ubN}[NXg<br>
 * ڂĂubN}[NXgɂB
 *
 */
void TreeWriter::upToBookmarkMenu(void)
{
	m_bmTree->upToBookmarkMenu();
	folderType = Bookmark::menuBar;
	level = 1;

	// j[o[̂ƂIEނۂōő啶ωB
	if (noIEname) {
		// IẼt@CK𗘗pȂ͗płt@C̒L΂
		mbFolderNameMax = BUFLEN;	// tH_ǉƂ̍ő咷(}`oCg)
		wcFolderNameMax = BUFLEN;	// tH_ǉƂ̍ő咷(wchar_t)
		mbBookmarkNameMax = BUFLEN - 1;	// ubN}[NǉƂ̍ő咷(}`oCg)
		wcBookmarkNameMax = BUFLEN - 1;	// ubN}[NǉƂ̍ő咷(wchar_t)
	} else {
		// ő啶̌vZ
		// +2͍ŏ̃ubN}[Nj[tH_̋؂
		// IÊCɓtH_̌\̕

		// tH_ǉƂ̍ő咷(}`oCg)
		// \.url\0̕cČB
		mbFolderNameMax = 247 - mbFavoriteFolderLen + 2;
		// tH_ǉƂ̍ő咷(wchar_t)
		wcFolderNameMax = 247 - wcFavoriteFolderLen + 2;
		// ubN}[NǉƂ̍ő咷(}`oCg)
		mbBookmarkNameMax = MAX_PATH - 6 - mbFavoriteFolderLen + 2;
		// ubN}[NǉƂ̍ő咷(wchar_t)
		wcBookmarkNameMax = MAX_PATH - 4 - wcFavoriteFolderLen + 2;
	}
}

/**
 * ŏĩubN}[NXg<br>
 * ڂĂubN}[NXgɂB
 *
 */
void TreeWriter::upToTop(void)
{
	m_bmTree->upToTop();
	folderType = Bookmark::topFolder;
	level = 0;

	mbFolderNameMax = BUFLEN;	// tH_ǉƂ̍ő咷(}`oCg)
	wcFolderNameMax = BUFLEN;	// tH_ǉƂ̍ő咷(wchar_t)
	mbBookmarkNameMax = BUFLEN - 1;	// ubN}[NǉƂ̍ő咷(}`oCg)
	wcBookmarkNameMax = BUFLEN - 1;	// ubN}[NǉƂ̍ő咷(wchar_t)

	mbPath[0] = '\0';
	wcPath[0] = L'\0';
}

