#include	"BScommon.h"

/**
 * ubN}[N̒ʂԍނ߂
 *
 * @param totalNo ʂԍ
 * @return 
 */
int totalNoToType(int totalNo) {
	switch (totalNo) {
		case BOOKMARK_IE:
			return BOOKMARK_TYPE_IE;
		case BOOKMARK_EDGE:
			return BOOKMARK_TYPE_EDGE;
		default:
			if (totalNo < 17) {
				// IEEdge̊(1`16)
				return (totalNo + 1) / 2 + 1;
			} else {
				// Vivaldi`(18`)
				return totalNo / 2 + 1;
			}

	}
}

/**
 * ubN}[N̒ʂԍTuԍ߂
 *
 * @param totalNo ʂԍ
 * @return Tuԍ
 */
int totalNoToSubNo(int totalNo)
{

	switch (totalNo) {
		case BOOKMARK_IE:
			return 0;
		case BOOKMARK_EDGE:
			return 0;
		default:
			if (totalNo < 17) {
				// IEEdge̊(1`16)
				return (totalNo - 1) % 2;
			} else {
				// Vivaldi`(18`)
				return totalNo % 2;
			}
	}
}

/**
 * ubN}[N̎ނƃTuԍʂԍɒB
 *
 * @param type 
 * @param subNo Tuԍ
 * @return ʂԍ
 */
int toTotal(int type, int subNo)
{
	int baseNo;

	switch (type) {
		case BOOKMARK_TYPE_IE:
			return BOOKMARK_IE;
		case BOOKMARK_TYPE_EDGE:
			return BOOKMARK_EDGE;
		case BOOKMARK_TYPE_MOZILLA:
			baseNo = BOOKMARK_MOZILLA_1;
			break;
		case BOOKMARK_TYPE_OPERA:
			baseNo = BOOKMARK_OPERA_1;
			break;
		case BOOKMARK_TYPE_FIREFOX:
			baseNo = BOOKMARK_FIREFOX_1;
			break;
		case BOOKMARK_TYPE_SAFARI:
			baseNo = BOOKMARK_SAFARI_1;
			break;
		case BOOKMARK_TYPE_CHROME:
			baseNo = BOOKMARK_CHROME_1;
			break;
		case BOOKMARK_TYPE_XBEL:
			baseNo = BOOKMARK_XBEL_1;
			break;
		case BOOKMARK_TYPE_OPERA15:
			baseNo = BOOKMARK_OPERA15_1;
			break;
		case BOOKMARK_TYPE_OPERA25:
			baseNo = BOOKMARK_OPERA25_1;
			break;
		case BOOKMARK_TYPE_VIVALDI:
			baseNo = BOOKMARK_VIVALDI_1;
			break;
	}
	return baseNo + subNo;
}