#ifndef CONFIGRATION_H
#define CONFIGRATION_H

#include	<string>

#include	"..\common\BScommon.h"

class Configuration {
public:
	enum ConvertType
	{
		Sync,
		Convert,
		Edit
	};

private:
	std::string mozPath[2];
	bool mozIgnoreIe[2];
	bool mozNs4Format[2];
	bool mozConvert[2];

	std::string operaPath[2];
	bool opera7Format[2];
	bool operaIgnoreTrush[2];
	bool operaConvert[2];
	bool operaWinMobile[2];
	bool operaSyncMobile[2];

	std::string iePath;
	bool ieIgnoreLinkFolder;
	bool ieEraseFavorite;
	bool ieSyncronizeLinkFolder;
	bool ieConvert;
	bool ieSyncronizeFxLinkFolder;
	bool ieNoLinkToMenu;

	// EdgêCɓtH_
	std::string edgePath;
	// EdgêCɓo[𖳎邩H
	bool edgeIgnoreLinkFolder;
	// OEdgêCɓ邩H
	bool edgeEraseFavorite;
	// EdgêCɓo[Firefox 2ȑOAMozillaANetscapeƓ邩H
	bool edgeSyncronizeLinkFolder;
	// EdgêCɓ𓯊EϊEҏW邩H
	bool edgeConvert;
	// EdgêCɓo[Firefox 3ȍ~Ɠ邩H
	bool edgeSyncronizeFxLinkFolder;
	bool edgeNoLinkToMenu;

	std::string fxPath[2];
	bool fxIgnoreIe[2];
	bool fxConvert[2];
	bool fxIgnoreToolbar[2];
	bool fxDoOptimize[2];

	std::string sfPath[2];
	bool sfConvert[2];
	bool sfIgnoreToolbar[2];

	std::string chPath[2];
	bool chIgnoreToolbar[2];

	std::string xbPath[2];
	int xbLayout[2];
	bool xbIgnoreToolbar[2];

#ifdef WITH_OP15
	std::string op15Path[2];
	bool op15Convert[2];
	bool op15InFolder[2];
	bool op15Optimize[2];
#endif	// WITH_OP15

	std::string op19Path[2];
	bool op19Convert[2];
	bool op19InFolder[2];
	int op19Layout[2];
	bool op19IgnoreTrush[2];
	bool op19IgnoreToolbar[2];
	bool op19IgnoreUnsorted[2];


	std::string viPath[2];
	bool viConvert[2];
	bool viIgnoreTrush[2];

	std::string edge2Path[2];
	bool edge2IgnoreToolbar[2];

	int property;
	int sortType;
	bool update;

	bool convertFrom[ALL_BOOKMARKS];
	bool convertTo[ALL_BOOKMARKS];

	bool editMode;
	int editTarget;
	bool convertAll;

	int readOrder[ALL_BOOKMARKS];

	bool placesPut;
	bool op29SpeedDialPut;
	ConvertType convertType;

	bool leaveDuplicateName;
	bool normalize;
	bool noIEFavbar;
	int logLevel;

public:
	Configuration();

	// Mozilla̐ݒ֘Agetter/setter
	std::string getMozPath(int no){
		return mozPath[no];
	};
	void setMozPath(int no,const char *path){
		mozPath[no] = path;
	}

	bool getMozIgnoreIe(int no){
		return mozIgnoreIe[no];
	}
	void setMozIgnoreIe(int no,bool value){
		mozIgnoreIe[no] = value;
	}

	bool getMozNs4Format(int no){
		return mozNs4Format[no];
	}
	void setMozNs4Format(int no,bool value){
		mozNs4Format[no] = value;
	}

	bool getMozConvert(int no){
		return mozConvert[no];
	}
	void setMozConvert(int no,bool value){
		mozConvert[no] = value;
	}

	// Opera̐ݒ֘Agetter/setter
	std::string getOperaPath(int no){
		return operaPath[no];
	};
	void setOperaPath(int no,const char *path){
		operaPath[no] = path;
	}

	bool getOpera7Format(int no){
		return opera7Format[no];
	}
	void setOpera7Format(int no,bool value){
		opera7Format[no] = value;
	}

	bool getOperaIgnoreTrush(int no){
		return operaIgnoreTrush[no];
	}
	void setOperaIgnoreTrush(int no,bool value){
		operaIgnoreTrush[no] = value;
	}

	bool getOperaWinMobile(int no){
		return operaWinMobile[no];
	}
	void setOperaWinMobile(int no,bool value){
		operaWinMobile[no] = value;
	}

	bool getOperaSyncMobile(int no){
		return operaSyncMobile[no];
	}
	void setOperaSyncMobile(int no,bool value){
		operaSyncMobile[no] = value;
	}

	bool getOperaConvert(int no){
		return operaConvert[no];
	}
	void setOperaConvert(int no,bool value){
		operaConvert[no] = value;
	}

	// IE̐ݒ֘Agetter/setter
	std::string getIePath(void){
		return iePath;
	};
	void setIePath(const char *path){
		iePath = path;
	}

	bool getIeIgnoreLinkFolder(void){
		return ieIgnoreLinkFolder;
	}
	void setIeIgnoreLinkFolder(bool value){
		ieIgnoreLinkFolder = value;;
	}

	bool getIeEraseFavorite(void){
		return ieEraseFavorite;
	}
	void setIeEraseFavorite(bool value){
		ieEraseFavorite = value;
	}

	bool getIeSyncronizeLinkFolder(void){
		return ieSyncronizeLinkFolder;
	}
	void setIeSyncronizeLinkFolder(bool value){
		ieSyncronizeLinkFolder = value;
	}

	bool getIeConvert(void){
		return ieConvert;
	}
	void setIeConvert(bool value){
		ieConvert = value;
	}

	bool getIeSyncronizeFxLinkFolder(void){
		return ieSyncronizeFxLinkFolder;
	}
	void setIeSyncronizeFxLinkFolder(bool value){
		ieSyncronizeFxLinkFolder = value;
	}

	bool getIeNoLinkToMenu(void) {
		return ieNoLinkToMenu;
	}
	void setIeNoLinkToMenu(bool value) {
		ieNoLinkToMenu = value;
	}

	// Edge̐ݒ֘Agetter/setter
	std::string getEdgePath(void){
		return edgePath;
	};
	void setEdgePath(const char *path){
		edgePath = path;
	}

	bool getEdgeIgnoreLinkFolder(void){
		return edgeIgnoreLinkFolder;
	}
	void setEdgeIgnoreLinkFolder(bool value){
		edgeIgnoreLinkFolder = value;;
	}

	bool getEdgeEraseFavorite(void){
		return edgeEraseFavorite;
	}
	void setEdgeEraseFavorite(bool value){
		edgeEraseFavorite = value;
	}

	bool getEdgeSyncronizeLinkFolder(void){
		return edgeSyncronizeLinkFolder;
	}
	void setEdgeSyncronizeLinkFolder(bool value){
		edgeSyncronizeLinkFolder = value;
	}

	bool getEdgeConvert(void){
		return edgeConvert;
	}
	void setEdgeConvert(bool value){
		edgeConvert = value;
	}

	bool getEdgeSyncronizeFxLinkFolder(void){
		return edgeSyncronizeFxLinkFolder;
	}
	void setEdgeSyncronizeFxLinkFolder(bool value){
		edgeSyncronizeFxLinkFolder = value;
	}

	bool getEdgeNoLinkToMenu(void) {
		return edgeNoLinkToMenu;
	}
	void setEdgeNoLinkToMenu(bool value) {
		edgeNoLinkToMenu = value;
	}

	// Firefox̐ݒ֘Agetter/setter
	std::string getFxPath(int no){
		return fxPath[no];
	};
	void setFxPath(int no,const char *path){
		fxPath[no] = path;
	}

	bool getFxIgnoreIe(int no){
		return fxIgnoreIe[no];
	}
	void setFxIgnoreIe(int no,bool value){
		fxIgnoreIe[no] = value;
	}

	bool getFxConvert(int no){
		return fxConvert[no];
	}
	void setFxConvert(int no,bool value){
		fxConvert[no] = value;
	}
	bool getFxIgnoreToolbar(int no){
		return fxIgnoreToolbar[no];
	}
	void setFxIgnoreToolbar(int no,bool value){
		fxIgnoreToolbar[no] = value;
	}
	bool getFxDoOptimize(int no){
		return fxDoOptimize[no];
	}
	void setFxDoOptimize(int no,bool value){
		fxDoOptimize[no] = value;
	}


	// Safari̐ݒ֘Agetter/setter
	std::string getSfPath(int no){
		return sfPath[no];
	};
	void setSfPath(int no,const char *path){
		sfPath[no] = path;
	}

	bool getSfConvert(int no){
		return sfConvert[no];
	}
	void setSfConvert(int no,bool value){
		sfConvert[no] = value;
	}

	bool getSfIgnoreToolbar(int no){
		return sfIgnoreToolbar[no];
	}
	void setSfIgnoreToolbar(int no,bool value){
		sfIgnoreToolbar[no] = value;
	}

	// Chrome̐ݒ֘Agetter/setter
	std::string getChPath(int no){
		return chPath[no];
	};
	void setChPath(int no,const char *path){
		chPath[no] = path;
	}

	bool getChIgnoreToolbar(int no){
		return chIgnoreToolbar[no];
	}
	void setChIgnoreToolbar(int no,bool value){
		chIgnoreToolbar[no] = value;
	}

	// XBEL̐ݒ֘Agetter/setter
	std::string getXbPath(int no){
		return xbPath[no];
	};
	void setXbPath(int no,const char *path){
		xbPath[no] = path;
	}

	int getXbLayout(int no) {
		return xbLayout[no];
	}
	void setXbLayout(int no,const int value) {
		xbLayout[no] = value;
	}

	bool getXbIgnoreToolbar(int no){
		return xbIgnoreToolbar[no];
	}
	void setXbIgnoreToolbar(int no,bool value){
		xbIgnoreToolbar[no] = value;
	}

#ifdef WITH_OP15
	// Opera 15̐ݒ֘Agetter/setter
	std::string getOp15Path(int no){
		return op15Path[no];
	};
	void setOp15Path(int no,const char *path){
		op15Path[no] = path;
	}

	bool getOp15Convert(int no){
		return op15Convert[no];
	}
	void setOp15Convert(int no,bool value){
		op15Convert[no] = value;
	}

	bool getOp15InFolder(int no){
		return op15InFolder[no];
	}
	void setOp15InFolder(int no,bool value){
		op15InFolder[no] = value;
	}

	bool getOp15Optimize(int no){
		return op15Optimize[no];
	}
	void setOp15Optimize(int no,bool value){
		op15Optimize[no] = value;
	}
#endif	// WITH_OP15

	// Opera 19ubN}[No[̐ݒ֘Agetter/setter
	std::string getOp19Path(int no){
		return op19Path[no];
	};
	void setOp19Path(int no,const char *path){
		op19Path[no] = path;
	}

	bool getOp19Convert(int no){
		return op19Convert[no];
	}
	void setOp19Convert(int no,bool value){
		op19Convert[no] = value;
	}

	bool getOp19InFolder(int no){
		return op19InFolder[no];
	}
	void setOp19InFolder(int no,bool value){
		op19InFolder[no] = value;
	}

	int getOp19Layout(int no) {
		return op19Layout[no];
	}
	void setOp19Layout(int no,const int value) {
		op19Layout[no] = value;
	}

	bool getOp19IgnoreTrush(int no){
		return op19IgnoreTrush[no];
	}
	void setOp19IgnoreTrush(int no,bool value){
		op19IgnoreTrush[no] = value;
	}

	bool getOp19IgnoreToolbar(int no) {
		return op19IgnoreToolbar[no];
	}
	void setOp19IgnoreToolbar(int no, bool value) {
		op19IgnoreToolbar[no] = value;
	}

	bool getOp19IgnoreUnsorted(int no) {
		return op19IgnoreUnsorted[no];
	}
	void setOp19IgnoreUnsorted(int no, bool value) {
		op19IgnoreUnsorted[no] = value;
	}


	// Vivaldi̐ݒ֘Agetter/setter
	std::string getViPath(int no) {
		return viPath[no];
	};
	void setViPath(int no, const char *path) {
		viPath[no] = path;
	}

	bool getViConvert(int no) {
		return viConvert[no];
	}
	void setViConvert(int no, bool value) {
		viConvert[no] = value;
	}

	bool getViIgnoreTrush(int no) {
		return viIgnoreTrush[no];
	}
	void setViIgnoreTrush(int no, bool value) {
		viIgnoreTrush[no] = value;
	}


	// Edge(Chromium)̐ݒ֘Agetter/setter
	std::string getEdge2Path(int no) {
		return edge2Path[no];
	};
	void setEdge2Path(int no, const char *path) {
		edge2Path[no] = path;
	}

	bool getEdge2IgnoreToolbar(int no) {
		return edge2IgnoreToolbar[no];
	}
	void setEdge2IgnoreToolbar(int no, bool value) {
		edge2IgnoreToolbar[no] = value;
	}


	int getProperty(void){
		return property;
	}
	void setProperty(int value){
		property = value;
	}

	int getSortType(void){
		return sortType;
	}
	void setSortType(int value){
		sortType = value;
	}

	bool getUpdate(void){
		return update;
	}
	void setUpdate(bool value){
		update = value;
	}

	bool getConvertFrom(int no){
		return convertFrom[no];
	}
	void setConvertFrom(int no,bool value){
		convertFrom[no] = value;
	}

	bool getConvertTo(int no){
		return convertTo[no];
	}
	void setConvertTo(int no,bool value){
		convertTo[no] = value;
	}

	bool getEditMode(){
		return editMode;
	}
	void setEditMode(bool mode){
		editMode = mode;
	}

	int getEditTarget(){
		return editTarget;
	}
	void setEditTarget(int target){
		editTarget = target;
	}

	/**
	 * ϊɂׂẴubN}[NIɕϊΏۂɂ邩ǂ擾B
	 *
	 * @return true:ׂẴubN}[NϊΏۂɂ false:euEUUIɍ킹
	 */
	bool getConvertAll(){
		return convertAll;
	}
	/**
	 * ϊɂׂẴubN}[NIɕϊΏۂɂ邩ǂݒ肷B
	 *
	 * @param setting true:ׂẴubN}[NϊΏۂɂ false:euEUUIɍ킹
	 */
	void setConvertAll(bool setting){
		convertAll = setting;
	}

	int getReadOrder(int order) {
		return readOrder[order];
	}
	void setReadOrder(int order,int type) {
		readOrder[order] = type;
	}

	bool getPlacesPut() {
		return placesPut;
	}
	void setPlacesPut(bool mode) {
		placesPut = mode;
	}

	bool getOp29SpeedDialPut() {
		return op29SpeedDialPut;
	}
	void setOp29SpeedDialPut(bool mode) {
		op29SpeedDialPut = mode;
	}

	ConvertType getConvertType(void) {
		return convertType;
	}
	void setConvertType(ConvertType type) {
		convertType = type;
	}

	bool getLeaveDuplicateName(void) {
		return leaveDuplicateName;
	}
	void setLeaveDuplicateName(bool flag) {
		leaveDuplicateName = flag;
	}

	bool getNormalize(void) {
		return normalize;
	}
	void setNormalize(bool flag) {
		normalize = flag;
	}

	bool getNoIEFavbar(void) {
		return noIEFavbar;
	}
	void setNoIEFavbar(bool flag) {
		noIEFavbar = flag;
	}

	int getLogLevel(void) {
		return logLevel;
	}
	void setLogLevel(int level) {
		logLevel = level;
	}
};

#endif
