#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <ctype.h>
#include <wchar.h>
#include <mbstring.h>
#include <assert.h>
#include <cstdint>
#include "typewrap.h"
#include "BScommon.h"
#include "encutil.h"
#include "encutil2.h"

/**
 * @brief UTF-16̃oCg񂩂UCS4(UTF-32)1oB
 * @param src o
 * @return o1
 */
uint64_t UTF16toUCS4(const wchar_t* src)
{
	uint64_t ucchar;
	uint64_t ucfirst;
	uint64_t high;
	uint64_t low;

	ucfirst = expandWchat_t(*src);
	high = (ucfirst - 55296) * 1024;

	if (*(src + 1) == 0) {
		return 0;
	}

	uint64_t nextChar;

	nextChar = expandWchat_t(*(src + 1));
	low = (nextChar & 0xffff) - 56320;

	ucchar = high + low + 65536;

	return ucchar;
}

/**
 * @brief UTF-16LEUTF-8ɕϊƂ̕vZ
 * @param src ϊΏUTF-16LE̐擪w
 * @return 
*/
int countUTF16toUTF8(const wchar_t *src, int &utf16Count)
{
	int utf8Count;
	uint64_t ucchar;
	uint64_t uccurrent;
	int high;
	int low;

	utf8Count = 0;

	assert(src != NULL);

	uccurrent = expandWchat_t(*src);

	if ((uccurrent < 55296) || (uccurrent > 56319)) {
		// TQ[gyAł͂Ȃ
		ucchar = *src;
		utf16Count = 1;
	} else {
		// TQ[gyA
		ucchar = UTF16toUCS4(src);
		utf16Count = 2;
	}

	if (ucchar > 0xffffL) {
		utf8Count = 4;
	} else if (ucchar > 0x7ffL) {
		utf8Count = 3;
	} else if (ucchar > 0x7fL) {
		utf8Count = 2;
	} else {
		utf8Count = 1;
	}

	return utf8Count;
}

/**
 * wchar_t(Unicode)UTF-8ɕϊB
 * 
 * @param dst ϊ
 * @param src ϊ
 */
void toUTF8(unsigned char *dst, const wchar_t *src)
{
	int i,count;
	uint64_t ucchar;
	int high;
	int low;

	assert(src != NULL);

	const wchar_t *current = src;

	while (*current) {
		uint64_t currentChar;
		currentChar = expandWchat_t(*current);

		if ((currentChar >= 55296) && (currentChar <= 56319)) {
			// TQ[gyA
			ucchar = UTF16toUCS4(current);

			current += 2;
		} else {
			ucchar = (int)(*current);
			current++;
		}

		if (ucchar > 0xffffL) {
			*dst = (ucchar >> 19) & 0x7 | 0xf0;
			dst++;
			*dst = (ucchar >> 12) & 0x3f | 0x80;
			dst++;
			*dst = (ucchar >> 6) & 0x3f | 0x80;
			dst++;
			*dst = ucchar & 0x3f | 0x80;
			dst++;
		} else if (ucchar > 0x7ffL) {
			*dst = (ucchar >> 12) & 0x0f | 0xe0;
			dst++;
			*dst = (ucchar >> 6) & 0x3f | 0x80;
			dst++;
			*dst = ucchar & 0x3f | 0x80;
			dst++;
		} else if (ucchar > 0x7fL) {
			*dst = (ucchar >> 6) & 0x1f | 0xc0;
			dst++;
			*dst = ucchar & 0x3f | 0x80;
			dst++;
		} else {
			*dst = ucchar & 0x7f;
			dst++;
		}
	}
	*dst = '\0';
}

/**
 * @brief UTF-16LEUTF-8ɕϊƂ̕vZ
 * @param src ϊΏUTF-16LE
 * @return (\0͊܂܂Ȃ)
 */
int countUTF16LEtoUTF8str(const wchar_t *src)
{
	int count;
	
	count = 0;

	assert(src != NULL);
	
	while(*src != L'\0') {
		int utf16Count;
		int utf8Count = countUTF16toUTF8(src, utf16Count);

		count += utf8Count;

		src += utf16Count;
	}
	return count;
}

/* ȈՃfR[h */
void decodeDescription(char *dst,const char *src)
{
	int c;
	int isUTF8 = 0;

	assert(src != NULL);

	while(*src){
		// ȃ}`oCgł邩ǂ`FbNAłȂꍇ͖悤ɂB
		if (isleadbyte(*src) && (!isUTF8)){
			c = *src;
			src++;
			if (*src){
				if ( _ismbbtrail(*((unsigned char *)src)) ){
					*dst = c;
					dst++;
					*dst = *src;
					dst++;
				}
			}
		}else{
			switch(*src){
				case '%':
					if (*(src+1) == 'u'){
						// Skip UTF-8 Sign
						src += 2;
						isUTF8 = 1;
						continue;
					}
					c = 0;
					src++;
					if (*src){
						if (isdigit(*src)){
							c = *src - '0';
						}else if (isxdigit(*src)){
							c = toupper(*src) - 'A' + 10;
						}
						src++;
						if (*src){
							if (isdigit(*src)){
								c = (c << 4) + *src - '0';
							}else if (isxdigit(*src)){
								c = (c << 4) + toupper(*src) - 'A' + 10;
							}
							*dst = (char)c;
							dst++;
						}
					}
				break;
	/*
				case '+':	//URLfR[ĥƂ͂ϊKvB
					*dst = ' ';
				break;
	*/
				default:
					*dst = *src;
					dst++;
			}
		}
		if (*src != '\0')
			src++;
	}
	*dst = '\0';
}

/**
 * @brief ϊΏۂ̒ƁAϊoCgPʂŕԂmbstowcs
 * @param wcstr ϊ̃ChoCg
 * @param mbstr ϊ̃}`oCg
 * @param count ϊoCg(VOoCĝƂ̃oCgB}`oCg̕ɂ炸B)
 * @return ϊ}`oCg
 * @remarks rɕϊłȂ݂ꍇmbstowcsƈقȂAϊłȂϊO̕ԂB
*/
int mbstowcsByte(wchar_t *wcstr,const char *mbstr,size_t count)
{
	size_t i;
	int trans,result;
	trans = 0;
	wchar_t buf[2];
	int wccopyed = 0;
	int wcCount;
	int now = 0;
	wchar_t *wccurrent;

	assert(mbstr != NULL);

	if (mbstr == NULL){
		return 0;
	}

	wccurrent = wcstr;
	
	for (i = 0;i < count;) {
		result = mbtowc(buf,mbstr + i, MB_CUR_MAX);
		if (result == -1){
			if (wccurrent != NULL) {
				*wccurrent = L'\0';
			}
			break;
		}else{
			if (result == 0) {
				if (wccurrent != NULL) {
					*wccurrent = L'\0';
				}
				break;
			} else {
				i += result;
				trans++;
				if (wccurrent != NULL) {
					*wccurrent = buf[0];
					wccurrent++;
				}
			}
		}
	}
	if (wccurrent != NULL) {
		*wccurrent = L'\0';
	}
	return i;
}


/*
int __strcmpi(const char *s,const char *t)
{
	int sl,tl;
	
//	printf("%d %s\n",strlen(s),s);
//	printf("%d %s\n\n",strlen(t),t);
	
	do{
		sl = (*s >= 'A' && *s <= 'Z')? *s + 0x20: *s ;
		tl = (*t >= 'A' && *t <= 'Z')? *t + 0x20: *t ;
		s++;
		t++;
		
	}while(sl && (sl == tl));
	return(sl - tl);
}
*/
/*
int __strcmpi (
        const char * src,
        const char * dst
        )
{
        int ret = 0 ;

        while( ! (ret = *(unsigned char *)src - *(unsigned char *)dst) && *dst)
                ++src, ++dst;

        if ( ret < 0 )
                ret = -1 ;
        else if ( ret > 0 )
                ret = 1 ;

        return( ret );
}
*/

// [N
// wchar_t(UTF-16)
static char *s_internalMB = NULL;
static size_t internalMBcount = 0;
// wchar_t(UTF-16)
static wchar_t *s_internalW = NULL;
static size_t internalWcount = 0;
// UTF-8
static char *s_internalU = NULL;
static size_t internalUcount = 0;
// GR[hꂽ
static char *s_internalEnc = NULL;
static size_t internalEncCount = 0;

/**
 * UnicodeUTF-8ɕϊēobt@Ɋi[B
 * obt@͕KvɉăTCYςĊmۂ̂
 * 蓖Ă炷ƂłB
 *
 * @param wcstr ϊΏۂUnicode
 * @return NULL:ϊ NULL:ϊɎs
 */
char *wctoUTF8Internal(const wchar_t *wcstr)
{
	int count;
	char *p2;

	assert(wcstr != NULL);

	if (wcstr == NULL){
		return NULL;
	}

	// Unicode -> UTF-8ɕϊB
	count = countUTF16LEtoUTF8str(wcstr);
	if ((count + 1) > internalUcount){
		// obt@ȂƂ͍ĊmۂB
		if (s_internalU != NULL){
			free(s_internalU);
		}
		
		p2 = (char *)calloc(count + 1,sizeof(char));
		if (p2 == NULL){
			s_internalU = NULL;
			internalUcount = 0;
			return NULL;
		}
		s_internalU = p2;
		internalUcount = count + 1;
	}
	s_internalU[count] = '\0';

	toUTF8((unsigned char *)s_internalU,wcstr);
	
	return s_internalU;
}

/**
 * }`oCgUTF-8ɕϊēobt@Ɋi[B<br>
 * obt@͕KvɉăTCYςĊmۂ̂<br>
 * 蓖Ă炷ƂłB<br>
 *
 * @param mbstr ϊΏۂ̃}`oCg
 * @return NULL:ϊ NULL:ϊɎs
 */
char *mbtoUTF8Internal(const char *mbstr)
{
	int count;
	wchar_t *p;
	char *p2;

	assert(mbstr != NULL);

	if (mbstr == NULL){
		return NULL;
	}

	// ܂UnicodeɕϊB
	count = mbstowcsByte(NULL,mbstr,strlen(mbstr));
	if ((count + 1) > internalWcount){
		// obt@ȂƂ͍ĊmۂB
		if (s_internalW != NULL){
			free(s_internalW);
		}
		
		p = (wchar_t *)calloc(count + 1,sizeof(wchar_t));
		if (p == NULL){
			s_internalW = NULL;
			internalWcount = 0;
			return NULL;
		}
		s_internalW = p;
		internalWcount = count + 1;
	}
	s_internalW[count] = L'\0';
	mbstowcsByte(s_internalW,mbstr,strlen(mbstr));

	// Unicode -> UTF-8ɕϊB
	count = countUTF16LEtoUTF8str(s_internalW);
	if ((count + 1) > internalUcount){
		// obt@ȂƂ͍ĊmۂB
		if (s_internalU != NULL){
			free(s_internalU);
		}
		
		p2 = (char *)calloc(count + 1,sizeof(char));
		if (p2 == NULL){
			s_internalU = NULL;
			internalUcount = 0;
			return NULL;
		}
		s_internalU = p2;
		internalUcount = count + 1;
	}
	s_internalU[count] = '\0';

	toUTF8((unsigned char *)s_internalU,s_internalW);
	
	return s_internalU;
}

/**
	}`oCgUnicodeɕϊēobt@Ɋi[B
	obt@͕KvɉăTCYςĊmۂ̂
	蓖Ă炷ƂłB
	
	@param mbstr }`oCgւ̃|C^
	@return ϊ:obt@ւ̃|C^ s:NULL
*/
wchar_t *mbtowcInternal(const char *mbstr)
{
	int count;
	wchar_t *p;

	assert(mbstr != NULL);

	if (mbstr == NULL){
		return NULL;
	}

	// ܂UnicodeɕϊB
	count = mbstowcsByte(NULL,mbstr,strlen(mbstr));
	if ((count + 1) > internalWcount){
		// obt@ȂƂ͍ĊmۂB
		if (s_internalW != NULL){
			free(s_internalW);
		}
		
		p = (wchar_t *)calloc(count + 1,sizeof(wchar_t));
		if (p == NULL){
			s_internalW = NULL;
			internalWcount = 0;
			return NULL;
		}
		s_internalW = p;
		internalWcount = count + 1;
	}
	s_internalW[count] = L'\0';
	mbstowcsByte(s_internalW,mbstr,strlen(mbstr));

	return s_internalW;
}

/**
	}`oCgUnicodeɕϊēobt@Ɋi[B
	obt@͕KvɉăTCYςĊmۂ̂
	蓖Ă炷ƂłB
	
	@param mbstr }`oCgւ̃|C^
	@return ϊ:obt@ւ̃|C^ s:NULL
*/
char *wctombInternal(const wchar_t *wcstr)
{
	size_t count;
	char *p;

	assert(wcstr != NULL);

	if (wcstr == NULL){
		return NULL;
	}

	// ܂UnicodeɕϊB
	count = wcstombsByte(NULL,wcstr,(wcslen(wcstr) + 1) * (sizeof(char) * 2) );
	if ((count + 1) > internalMBcount){
		// obt@ȂƂ͍ĊmۂB
		if (s_internalMB != NULL){
			free(s_internalMB);
		}
		
		p = (char *)calloc(count + 1,sizeof(char));
		if (p == NULL){
			s_internalMB = NULL;
			internalMBcount = 0;
			return NULL;
		}
		s_internalMB = p;
		internalMBcount = count + 1;
	}
	s_internalMB[count] = '\0';
	wcstombsByte(s_internalMB,wcstr,count + 1);

	return s_internalMB;
}

/*
	UTF-8}`oCgɕϊēobt@Ɋi[B
	obt@͕KvɉăTCYςĊmۂ̂
	蓖Ă炷ƂłB
*/
char *UTF8tombInternal(char *utf8str)
{
	size_t count;
	wchar_t *p;
	char *p2;
	int converted;

	assert(utf8str != NULL);

	if (utf8str == NULL){
		return NULL;
	}

	// ܂UnicodeɕϊB
	count = utf8towc(NULL, utf8str);
	if ((count + 1) > internalWcount){
		// obt@ȂƂ͍ĊmۂB
		if (s_internalW != NULL){
			free(s_internalW);
		}
		
		p = (wchar_t *)calloc(count + 1,sizeof(wchar_t));
		if (p == NULL){
			s_internalW = NULL;
			internalWcount = 0;
			return NULL;
		}
		s_internalW = p;
		internalWcount = count + 1;
	}
	s_internalW[count] = L'\0';
	utf8towc(s_internalW,utf8str);

	// Unicode -> }`oCgɕϊB
	count = wcstombsByte(NULL,s_internalW,(count + 1) * 2);
	if ((count + 1) > internalMBcount){
		// obt@ȂƂ͍ĊmۂB
		if (s_internalMB != NULL){
			free(s_internalMB);
		}
		
		p2 = (char *)calloc(count + 1,sizeof(char));
		if (p2 == NULL){
			s_internalMB = NULL;
			internalMBcount = 0;
			return NULL;
		}
		s_internalMB = p2;
		internalMBcount = count + 1;
	}
	s_internalMB[count] = '\0';
	converted = wcstombsByte(s_internalMB,s_internalW,count + 1);
	s_internalMB[converted] = '\0';

	return s_internalMB;
}

/**
 * @brief UTF-8}`oCgɕϊēobt@Ɋi[B
 * @param utf8str UTF-8
 * @return obt@
 */
char *UTF8tombFileNameInternal(const char *utf8str)
{
	int count;
	wchar_t *p;
	char *p2;
	int converted;

	assert(utf8str != NULL);

	if (utf8str == NULL){
		return NULL;
	}

	// ܂UnicodeɕϊB
	count = utf8towc(NULL,utf8str);
	if ((count + 1) > internalWcount){
		// obt@ȂƂ͍ĊmۂB
		if (s_internalW != NULL){
			free(s_internalW);
		}
		
		p = (wchar_t *)calloc(count + 1,sizeof(wchar_t));
		if (p == NULL){
			s_internalW = NULL;
			internalWcount = 0;
			return NULL;
		}
		s_internalW = p;
		internalWcount = count + 1;
	}
	s_internalW[count] = L'\0';
	utf8towc(s_internalW,utf8str);

	// Unicode -> }`oCgɕϊB
	count = wcstombsByteFileName(NULL,s_internalW,(count + 1) * 2);
	if ((count + 1) > internalMBcount){
		// obt@ȂƂ͍ĊmۂB
		if (s_internalMB != NULL){
			free(s_internalMB);
		}
		
		p2 = (char *)calloc(count + 1,sizeof(char));
		if (p2 == NULL){
			s_internalMB = NULL;
			internalMBcount = 0;
			return NULL;
		}
		s_internalMB = p2;
		internalMBcount = count + 1;
	}
	s_internalMB[count] = '\0';
	converted = wcstombsByteFileName(s_internalMB,s_internalW,count + 1);
	s_internalMB[converted] = '\0';

	return s_internalMB;
}

/*
	UTF-8wchar_tɕϊēobt@Ɋi[B
	obt@͕KvɉăTCYςĊmۂ̂
	蓖Ă炷ƂłB
*/
wchar_t *UTF8towcFileNameInternal(const char *utf8str)
{
	int count;
	wchar_t *p;

	assert(utf8str != NULL);

	if (utf8str == NULL){
		return NULL;
	}

	// ܂UnicodeɕϊB
	count = utf8towc(NULL,utf8str);
	if ((count + 1) > internalWcount){
		// obt@ȂƂ͍ĊmۂB
		if (s_internalW != NULL){
			free(s_internalW);
		}
		
		p = (wchar_t *)calloc(count + 1,sizeof(wchar_t));
		if (p == NULL){
			s_internalW = NULL;
			internalWcount = 0;
			return NULL;
		}
		s_internalW = p;
		internalWcount = count + 1;
	}
	s_internalW[count] = L'\0';
	utf8towc(s_internalW,utf8str);
	s_internalW[count] = L'\0';

	return s_internalW;
}


/*
	GR[hēobt@Ɋi[B
*/
char *encodeDescriptionInternal(char *str)
{
	int count;
	char *p2;

	assert(str != NULL);

	if (str == NULL){
		return NULL;
	}
	
	// GR[hB
	count = encodeDescriptionU8(NULL,str);
	if ((count + 1) > internalEncCount){
		// obt@ȂƂ͍ĊmۂB
		if (s_internalEnc != NULL){
			free(s_internalEnc);
		}
		
		p2 = (char *)calloc(count + 1,sizeof(char));
		if (p2 == NULL){
			s_internalEnc = NULL;
			internalEncCount = 0;
			return NULL;
		}
		s_internalEnc = p2;
		internalEncCount = count + 1;
	}
	s_internalEnc[count] = '\0';

	encodeDescriptionU8(s_internalEnc,str);
	
	return s_internalEnc;
}

/*
	炩ߓobt@mۂĂB
	ɂA̍Ċmۂ邱ƂŃXs[hAbv҂łB
*/
void setupInternalBuffer(void)
{
	char *p;
	wchar_t *wp;

	p = (char *)calloc(BUFLEN,sizeof(char));
	if (p != NULL){
		s_internalMB = p;
		internalMBcount = BUFLEN;
	}

	wp = (wchar_t *)calloc(BUFLEN,sizeof(wchar_t));
	if (wp != NULL){
		s_internalW = wp;
		internalWcount = BUFLEN;
	}
	

	p = (char *)calloc(BUFLEN,sizeof(char));
	if (p != NULL){
		s_internalU = p;
		internalUcount = BUFLEN;
	}

	p = (char *)calloc(BUFLEN,sizeof(char));
	if (p != NULL){
		s_internalEnc = p;
		internalEncCount = BUFLEN;
	}
}

/**
 * obt@JB
 */
void resetInternalBuffer(void)
{
	if (s_internalMB != NULL){
		free(s_internalMB);
	}

	if (s_internalW != NULL){
		free(s_internalW);
	}

	if (s_internalU != NULL){
		free(s_internalU);
	}

	if (s_internalEnc != NULL){
		free(s_internalEnc);
	}
		
}

/**
 * wchar_t(Unicode)t@C|C^o͐JSON̕񃊃eŏo͂B
 *
 * @param fp t@C|C^
 * @param target o͑Ώە
 * @see https://developer.mozilla.org/ja/Core_JavaScript_1.5_Guide/Literals#.e6.96.87.e5.ad.97.e5.88.97.e3.83.aa.e3.83.86.e3.83.a9.e3.83.ab
 */
void putJSONString(FILE *fp,const wchar_t *target)
{
	int i = 0;

	assert(fp != NULL);
	assert(target != NULL);

	while (*(target + i)) {
		wchar_t c = *(target + i);
		if (c < 0x0080) {
			switch (c) {
				case 0x0008:	// Backspace()
					fputc('\\',fp);
					fputc('b',fp);
					break;
				case 0x0009:	// ^u
					fputc('\\',fp);
					fputc('t',fp);
					break;
				case 0x000a:	// s(LF)
					fputc('\\',fp);
					fputc('n',fp);
					break;
				case 0x000b:	// ^u
					fputc('\\',fp);
					fputc('v',fp);
					break;
				case 0x000c:	// y[W
					fputc('\\',fp);
					fputc('f',fp);
					break;
				case 0x000d:	// A(CR)
					fputc('\\',fp);
					fputc('r',fp);
					break;
				case 0x0022:	// dp
					fputc('\\',fp);
					fputc('\"',fp);
					break;
/* ChromẽubN}[Nł̓GXP[vȂB
				case 0x0027:	// Pp
					fputc('\\',fp);
					fputc('\'',fp);
					break;
*/
				case 0x005c:	// obNXbV
					fputc('\\',fp);
					fputc('\\',fp);
					break;
				default:
					if (c > 0x001f) {
						fputc((int)(c & 0x7f),fp);
					} else {
						fprintf(fp,"\\x");
						fprintf(fp,"%02X", c);
					}
					break;
			}
		} else {
			fprintf(fp,"\\u");
			fprintf(fp,"%01X",(int)((c >> 12) & 0x0f));
			fprintf(fp,"%01X",(int)((c >> 8) & 0x0f));
			fprintf(fp,"%01X",(int)((c >> 4) & 0x0f));
			fprintf(fp,"%01X",(int)(c & 0x0f));
		}
		i++;
	}
}

/* BOMpp^[ */
static char bomPattern[][4] = {
	{0xef,0xbb,0xbf,0x00},	// UTF-8 BOM
	{0xfe,0xff,0x00,0x00},	// UTF-16BE BOM
	{0xff,0xfe,0x00,0x00},	// UTF-16LE BOM
	{0x00,0x00,0xfe,0xff},	// UTF-32BE BOM
	{0xff,0xfe,0x00,0x00}	// UTF-32LE BOM
};

/**
 * BOM̎ނ`FbNB
 *
 * @param filename `FbNΏۃt@C̃t@C
 * @return 茋<br>
 *  ENCODE_PARSE_ERROR -1 GR[hG[<br>
 *  ENCODE_8BIT 0 UTF-8Ȃ8bitnBOMȂ<br>
 *  ENCODE_UTF8_BOM 1 UTF-8+BOM<br>
 *  ENCODE_UTF16_BE 2 UTF-16BE+BOM<br>
 *  ENCODE_UTF16_LE 3 UTF-16LE+BOM<br>
 *  ENCODE_UTF32_BE 4 UTF-32BE+BOM<br>
 *  ENCODE_UTF32_LE 5 UTF-32LE+BOM<br>
 */
int checkBOM(const char *filename)
{
	FILE *fp;
	char buf[16];
	size_t read;

	fp = fopen(filename,"rb");
	if (fp == NULL) {
		return -1;
	}
	read = fread(buf,1,16,fp);
	fclose(fp);

	if (read < 2) {
		/* 1ȉ̏ꍇBOMUTF-16ɂȂȂ */
		return ENCODE_8BIT;
	}
	if (read > 3) {
		/* UTF-32 BEǂH */
		if (!memcmp(buf,bomPattern[ENCODE_UTF32_BE - 1],4)) {
			return ENCODE_UTF32_BE;
		}
		/* UTF-32 LEǂH */
		if (!memcmp(buf,bomPattern[ENCODE_UTF32_LE - 1],4)) {
			return ENCODE_UTF32_LE;
		}
	}
	if (read > 2) {
		/* BOMUTF-8ǂH */
		if (!memcmp(buf,bomPattern[ENCODE_UTF8_BOM - 1],3)) {
			return ENCODE_UTF8_BOM;
		}
	}
	/* UTF-16 BEǂH */
	if (!memcmp(buf,bomPattern[ENCODE_UTF16_BE - 1],2)) {
		return ENCODE_UTF16_BE;
	}
	/* UTF-32 LEǂH */
	if (!memcmp(buf,bomPattern[ENCODE_UTF16_LE - 1],2)) {
		return ENCODE_UTF16_LE;
	}


	/* ܂łƂƂBOMŔʂłGR[h */
	/* sꂽt@Cł͂Ȃ悤B */
	return ENCODE_8BIT;
}

