#include	<stdio.h>
#include	<stdlib.h>
#include	<string.h>
#include	<ctype.h>
#include	<wchar.h>
#include	<mbstring.h>
#include	<locale.h>
#include	<assert.h>

#include	"encutil.h"

/**
 * charunsignedƂ݂Ȃintɕϊ
 *
 * @param c ϊchar
 * @return cunsignedƂ݂Ȃĕϊl
 */
int charToInt(char c)
{
	if (c < 0) {
		return 256 + c;
	}
	else {
		return c;
	}

}

 /**
  * UTF-8wchar_tɕϊB
  *
  * @param dst ϊ(NULL̎̓oCĝ݂vZ)
  * @param src ϊ
  * @return ϊUTF-16ł̃oCg
  */
size_t utf8towc(wchar_t *dst, const char *src)
{
	int wc;
	int shift_count;
	int i;
	size_t convCount;

	assert(src != NULL);

	convCount = 0;

	while (*src) {
		// Extruct to Unicode
		int c = charToInt(*src);

		wc = 0;
		if (c < 0x80) {
			// 1byte(7bit)
			wc = c;
			shift_count = 0;
		} else if (c >= 0xfc) {
			// 6bytes(27-32bit:no use)
			wc = c & 0x01;
			shift_count = 5;
		} else if (c >= 0xf8) {
			// 5bytes(22-26bit:no use)
			wc = c & 0x03;
			shift_count = 4;
		} else if (c >= 0xf0) {
			// 4bytes(17-21bit)
			wc = c & 0x07;
			shift_count = 3;
		} else if (c >= 0xe0) {
			// 3bytes(12-16bit)
			wc = c & 0x0f;
			shift_count = 2;
		} else if (c >= 0xc0) {
			// 2bytes(8-11bit)
			wc = c & 0x1f;
			shift_count = 1;
		} else {
			break;
		}

		src++;
		for (i = 0; i < shift_count; i++) {
			if (*src == '\0') {
				wc = L'\0';
				break;
			}
			c = charToInt(*src);

			wc = wc << 6;
			wc = wc | (c & 0x3f);
			src++;
		}

		if (wc >= 0x10000) {
			// Windows uses UTF-16 LE
			// ʃTQ[g
			int c1 = (wc & 0x3ff) | 0xdc00;
			// 10rbgl
			int high = ((wc - 0x10000) >> 10) & 0x3ff;
			int c2 = 0xd800 | high;

			if (dst != NULL) {
				*dst = c2;
				dst++;
				*dst = c1;
				dst++;
			}
			convCount += 2;
		} else {
			if (dst != NULL) {
				*dst = wc;
				dst++;
			}
			convCount++;
		}

	}
	if (dst != NULL) {
		*dst = L'\0';
	}

	return convCount;
}

// INIt@Cɓ悤ȒPȃGR[hsB
void encodeDescription(char *dst,char *src)
{
	char *p;
	
	assert(src != NULL);

	p = NULL;
	while(*src){
		if (*src < 0x21 && *src > -1){
			if (*src == '\n'){
				p = dst;
			}
			sprintf(dst,"%%%02.2x",(int)*src & 0xff);
			dst += 3;
			src++;
			continue;
		}
		switch(*src){
			case '%':
			case '\"':
			case '\'':
				sprintf(dst,"%%%02.2x",(int)*src & 0xff);
				dst += 3;
			break;
			default:
				*dst = *src;
				dst++;
			break;
		}
		src++;
	}
	*dst = '\0';
	// e^ȎOɓXy[X̕B
	if (p != NULL){
		*p = '\0';
	}
}

// INIt@C̃fR[hsB
int encodeDescriptionU8(char *dst,char *src)
{
	char *p;
	int count = 0;
	
	assert(src != NULL);

	if (dst != NULL){
		strcpy(dst,"%u");
		dst += 2;
	}
	count += 2;
	
	p = NULL;
	while(*src){
		if (*src < 0x20){
			// Control-Code,UTF-8
			if (dst != NULL){
//				if (*src == '\n'){
//					p = dst;
//				}
				sprintf(dst,"%%%02.2x",(int)*src & 0xff);
				dst += 3;
			}
			count += 3;
			src++;
			continue;
		}
		switch(*src){
			case '%':
			case '\"':
			case '\'':
				if (dst != NULL){
					sprintf(dst,"%%%02.2x",(int)*src & 0xff);
					dst += 3;
				}
				count += 3;
			break;
			default:
				if (dst != NULL){
					*dst = *src;
					dst++;
				}
				count++;
			break;
		}
		src++;
	}
	if (dst != NULL){
		*dst = '\0';
	}
	// e^ȎOɓXy[X̕B
//	if (p != NULL){
//		*p = '\0';
//	}
	return count;
}


/*
	}`oCglA
	(A̍Ō͕K\0ŏIB)
	
		dst Rs[obt@
		src Rs[
		bufLength Rs[obt@̒(strncatƂ͈قȂB)
	߂l
		Rs[obt@̐擪
*/
unsigned char *mbstrncatFit(unsigned char *dst,unsigned char *src,int bufLength)
{
	unsigned char *p;
	int count = 0;

	assert(dst != NULL);
	assert(src != NULL);

	/* ܂͖ȃAhX̊mFB */
	if (dst == NULL)
		return dst;

	if (src == NULL)
		return dst;

	p = dst;
	/* ސ擪ʒu𒲂ׂB */
	while(*p){
		p++;
		count++;
		if (count == bufLength){
			/* ɓ]obt@̍Ō߂B */
			return dst;
		}
	}
	
	while(*src){
		if (count == (bufLength - 1)){
			break;
		}
		if (isleadbyte(*src)){
			if (count >= (bufLength - 2)){
				/* 2oCgڂobt@̍ŌɂȂ\0Ȃ */
				break;
			}else{
				*p = *src;
				p++;
				count++;
				src++;
				if (*src){
					*p = *src;
					p++;
					count++;
					src++;
				}else{
					break;
				}
			}
		}else{
			*p = *src;
			p++;
			count++;
			src++;
		}
	}
	
	/* I[ */
	*p = '\0';
	
	return dst;

}

/*
	UnicodeA
	(A̍Ō͕K\0ŏIB)
	
		dst Rs[obt@
		src Rs[
		bufLength Rs[obt@̒(strncatƂ͈قȂB)
	߂l
		Rs[obt@̐擪
*/
wchar_t *wcsncatFit(wchar_t *dst,const wchar_t *src,int bufLength)
{
	wchar_t *p;
	int count = 0;

	assert(dst != NULL);
	assert(src != NULL);

	/* ܂͖ȃAhX̊mFB */
	if (dst == NULL)
		return dst;

	if (src == NULL)
		return dst;

	p = dst;
	/* ސ擪ʒu𒲂ׂB */
	while(*p){
		p++;
		count++;
		if (count == bufLength){
			/* ɓ]obt@̍Ō߂B */
			return dst;
		}
	}
	
	while(*src){
		if (count == (bufLength - 1)){
			break;
		}
		*p = *src;
		p++;
		count++;
		src++;
	}
	
	/* I[ */
	*p = L'\0';
	
	return dst;

}

/*
	ϊłȂo?ɒuĕϊ𒆎~Ȃ
	wcstombs֐B(wchar_t *char *)
*/
size_t wcstombsByte(char *mbstr,const wchar_t *wcstr,size_t count)
{
	size_t converted;
	size_t len = 0;
	char *p,buf[4];
	int i = 0;
	
	assert(wcstr != NULL);

	if (wcstr == NULL){
		return 0;
	}
	
	while(*(wcstr + i) != L'\0'){
		if (count < (len + MB_CUR_MAX)){
			break;
		}

		// mbstrNULL̎̓_~[̃obt@Ɋi[B
		// ̕ӂVC++ 7.1ŗLLŁAmbstowcs֐ƈقȂB
		if (mbstr == NULL){
			p = buf;
		}else{
			p = mbstr;
		}
		
		converted = wctomb(p,*(wcstr + i));
		if (converted == -1){
			/* ϊłȂ */
			if (mbstr != NULL){
				*mbstr = '?';
				mbstr++;
			}
			len++;
//			printf("Count 1:%d\n",len);
		}else{
			if (mbstr != NULL){
				mbstr += converted;
			}
			len += converted;
//			printf("Count 2:%d\n",len);
		}
		i++;
	}
	return len;
}

/*
	ϊłȂo?ɒuĕϊ𒆎~Ȃ
	wcstombs֐B(wchar_t *char *)
*/
size_t wcstombsByteFileName(char *mbstr,const wchar_t *wcstr,size_t count)
{
	size_t converted;
	size_t len = 0;
	char *p,buf[4];
	
	assert(wcstr != NULL);

	if (wcstr == NULL){
		return 0;
	}
	
	while(*wcstr != L'\0'){
		if (count < (len + MB_CUR_MAX)){
			break;
		}

		// mbstrNULL̎̓_~[̃obt@Ɋi[B
		// ̕ӂVC++ 7.1ŗLLŁAmbstowcs֐ƈقȂB
		if (mbstr == NULL){
			p = buf;
		}else{
			p = mbstr;
		}
		
		converted = wctomb(p,*wcstr);
		if (converted == -1){
			/* ϊłȂ */
			if (mbstr != NULL){
				*mbstr = '_';
				mbstr++;
			}
			len++;
//			printf("Count 1:%d\n",len);
		}else{
			if (mbstr != NULL){
				mbstr += converted;
			}
			len += converted;
//			printf("Count 2:%d\n",len);
		}
		wcstr++;
	}
	return len;
}
