#include	<stdio.h>
#include	<string.h>
#include	<locale.h>

#include	<windows.h>
#include	<winbase.h>

#include	"NTfunction.h"
#include	"clearKey.h"

/*  cl -D SELFTEST clearKey.cpp -link advapi32.lib rel\NTfunction.obj /LTCG */

/**
 * WXgL[̒lׂďB(Windows 9x)
 *
 * @param hKey ΏۂƂȂ郌WXgL[
 */
void deleteValues(HKEY hKey)
{
	char buf[256];
	DWORD bufSize = 256;
	LONG enumResult;

	do {
		// lƂɂB
		bufSize = 256;
		enumResult = RegEnumValue(hKey,0,buf,&bufSize,NULL,NULL,NULL,NULL);
		if (enumResult == ERROR_SUCCESS){
			// printf("Value:%s\n",buf);
			RegDeleteValue(hKey,buf);
		}
	}while(enumResult != ERROR_NO_MORE_ITEMS);

}

/**
 * WXgL[̃TuL[ׂďB(Windows 9x)
 *
 * @param keyName ΏۂƂȂ郌WXgL[
 */
void deleteKeys(const char *keyName)
{
	char buf[256];
	DWORD bufSize = 256;
	FILETIME time;
	HKEY hKey;		// WXgL[nh
	LONG enumResult;

	// printf("TargetKey:%s\n",keyName);
	int result = RegOpenKeyEx(HKEY_CURRENT_USER,keyName,0,
						KEY_READ | KEY_WRITE,&hKey);
	if (result != ERROR_SUCCESS) {
		// WXgL[݂Ȃ悤ȏꍇȂǃL[JȂꍇ
		// ǂ悤Ȃ̂łŔB
		return;
	}

	do {
		bufSize = 256;
		enumResult = RegEnumKeyEx(hKey,0,buf,&bufSize,NULL,NULL,NULL,&time);
		if (enumResult == ERROR_SUCCESS){
			char *subKey;
			int len;
			len = strlen(keyName) + strlen(buf) + 2;
			subKey = (char *)calloc(len,sizeof(char));
			if (subKey == NULL){
				break;
			}
			strcpy(subKey,keyName);
			strcat(subKey,"\\");
			strcat(subKey,buf);
			
			deleteKeys(subKey);
			free(subKey);
			
			// printf("SubKey:%s\n",buf);
			RegDeleteKey(hKey,buf);
		}
	}while(enumResult != ERROR_NO_MORE_ITEMS);

	// L[񋓂I獡x͒lĂB
	deleteValues(hKey);

	RegCloseKey(hKey);

}


/**
 * WXgL[̒lׂďB(Windows NTn)
 *
 * @param hKey ΏۂƂȂ郌WXgL[
 */
void deleteValuesW(HKEY hKey)
{
	wchar_t buf[256];
	DWORD bufSize = 256;
	LONG enumResult;

	do {
		// lƂɂB
		bufSize = 256;
		enumResult = RegEnumValueW(hKey,0,buf,&bufSize,NULL,NULL,NULL,NULL);
		if (enumResult == ERROR_SUCCESS){
			// printf("Value:%S\n",buf);
			RegDeleteValueW(hKey,buf);
		}
	}while(enumResult != ERROR_NO_MORE_ITEMS);

}

/**
 * WXgL[̃TuL[ׂďB(Windows NTn)
 *
 * @param keyName ΏۂƂȂ郌WXgL[
 */
void deleteKeysW(const wchar_t *keyName)
{
	wchar_t buf[256];
	DWORD bufSize = 256;
	FILETIME time;
	HKEY hKey;		// WXgL[nh
	LONG enumResult;

	// printf("TargetKey:%S\n",keyName);
	int result = RegOpenKeyExW(HKEY_CURRENT_USER,keyName,0,
						KEY_READ | KEY_WRITE,&hKey);
	if (result != ERROR_SUCCESS) {
		// WXgL[݂Ȃ悤ȏꍇȂǃL[JȂꍇ
		// ǂ悤Ȃ̂łŔB
		return;
	}

	do {
		bufSize = 256;
		enumResult = RegEnumKeyExW(hKey,0,buf,&bufSize,NULL,NULL,NULL,&time);
		if (enumResult == ERROR_SUCCESS){
			wchar_t *subKey;
			int len;
			len = wcslen(keyName) + wcslen(buf) + 2;
			subKey = (wchar_t *)calloc(len,sizeof(wchar_t));
			if (subKey == NULL){
				break;
			}
			wcscpy(subKey,keyName);
			wcscat(subKey,L"\\");
			wcscat(subKey,buf);
			
			deleteKeysW(subKey);
			free(subKey);
			
			// printf("SubKey:%S\n",buf);
			RegDeleteKeyW(hKey,buf);
		}
	}while(enumResult != ERROR_NO_MORE_ITEMS);

	// L[񋓂I獡x͒lĂB
	deleteValuesW(hKey);

	RegCloseKey(hKey);

}

#ifdef SELFTEST
int main(int argc,char *argv[])
{
	setlocale(LC_ALL,".ACP");
	loadNTfunction();

	if (g_isWinNT){
		printf("Windows NT series.\n");
		deleteKeysW(favoriteOrderKeyW);
	}else{
		printf("Windows 9x series.\n");
		deleteKeys(favoriteOrderKey);
	}

	unloadNTfunction();
}
#endif	// SELFTEST
