#include	<stdio.h>
#include	<string.h>
#include	<stdlib.h>
#include	<string.h>
#include	<ctype.h>
#include	<direct.h>
#include	<time.h>
#include	<locale.h>
#include	<assert.h>

// Windows֘Awb_
#include	<mbctype.h>
#include	<windows.h>
#include	<winbase.h>
#include	<shlobj.h>
#include	<rpc.h>

#define BSLIB_CPP

#include	"BScommon.h"
#include	"bslib.h"
#include	"NTfunction.h"
#include	"encutil.h"
#include	"encutil2.h"

/**
 * w肵񂪃t@CƂĖǂׂB
 *
 * @param name ׂ镶
 * @return 0:󔒈ȊO݂̕ 1:ׂċ󔒂󕶎
 */
int isNoname(const char *name)
{
	if (name == NULL){
		return 1;
	}
	
	while(*name){
		if (isspace(*name)){
			name++;
		}else{
			/* 󔒈ȊO݂̕ */
			return 0;
		}
	}
	return 1;
}

/*
	s؂蕶̍Ō̉sB
	
		path s؂蕶
	߂l
		0 Ō̉s؂藣B
		1 s͂ȂB
*/
int cutLastEndl(char *path)
{
	char *p,*found;
	p = path;
	found = NULL;

	if (path == NULL){
		return 1;
	}

	while(*p){
		if (*p == '\n'){
			found = p;
		}
		p++;
	}
	if (found != NULL){
		*found = '\0';
		return 0;
	}else{
		*path = '\0';
		return 1;
	}
}

/*
	Ō\ȍ~؂藣B
	pathȍ~𒼐ڏ̂ŒӁB
	
		path Ώە
	߂l
		0 ؂藣ɐ
		1 ؂藣Ɏs
*/
int cutLast(char *path)
{
	char *find = NULL,*ptmp;
	
	if (path == NULL){
		return 1;
	}

	if (*path == '\\'){	// ΃pX?
		path++;
		if (*path == '\\'){	// UNC\LB
			path++;
		}
	}
	while(*path){
		if (isleadbyte(*path)){
			path++;
		}else{
			if (*path == '\\'){
				ptmp = path;
				while(*path == '\\'){	// \₪Y΍
					path++;
				}
				path--;
				if (*(path+1))	// \0łȂ
					find = ptmp;
			}
		}
		path++;
	}
	if (find != NULL){
		*find = '\0';	// Ō̗vfԂ؂
		return(0);
	}else{
		return(1);
	}
}

/*
	Ō\ȍ~؂藣B
	pathȍ~𒼐ڏ̂ŒӁB
	
		path Ώە
	߂l
		0 ؂藣ɐ
		1 ؂藣Ɏs
*/
int cutLastW(wchar_t *path)
{
	wchar_t *find = NULL,*ptmp;
	
	if (path == NULL){
		return 1;
	}

	if (*path == L'\\'){	// ΃pX?
		path++;
		if (*path == L'\\'){	// UNC\LB
			path++;
		}
	}
	while(*path){
		if (*path == L'\\'){
			ptmp = path;
			while(*path == L'\\'){	// \₪Y΍
				path++;
			}
			path--;
			if (*(path+1))	// \0łȂ
				find = ptmp;
		}
		path++;
	}
	if (find != NULL){
		*find = L'\0';	// Ō̗vfԂ؂
		return 0;
	}else{
		return 1;
	}
}

/*
	̍Ō̎w肵ȍ~B(ڏ)
	
		path ^[Qbg
		ch Ώە
	߂l
		0 Ō̉s؂藣B
		1 s͂ȂB
*/
int cutLastWchar(wchar_t *path,wchar_t ch)
{
	wchar_t *p,*found;
	p = path;
	found = NULL;

	if (path == NULL){
		return 1;
	}

	while(*p){
		if (*p == ch){
			found = p;
		}
		p++;
	}
	if (found != NULL){
		*found = L'\0';
		return 0;
	}else{
		*path = L'\0';
		return 1;
	}
}


/*
	pX΃pXɒB
	
		szDir ϊ
		dir ϊ
		maxlen ϊobt@̕
	߂l
		Ȃ
*/
void getAbsoluteDirectoryName(char *szDir,char *dir,int maxlen)
{
	int len;

	/* printf("w肵pX:%s\n",dir); */
	/* 댯h~̂߂炩NULL`FbNsB */
	if (szDir == NULL){
		return;
	}

	if (dir == NULL){
		return;
	}

	len = strlen(dir);

	if (len < 2){
		if (dir[0] == '\\'){
			/* ݂̃hCũ[gfBNg */
			/* printf("Current Drive's root directory\n"); */
			szDir[0] = '@' + _getdrive();
			szDir[1] = ':';
			strcpy(szDir + 2,"\\");
		}else{
			/* JgfBNg̑΃pX */
			/* printf("JghCȗ΃pX\n"); */

			/* ΃pXɒB */
			_getcwd(szDir,maxlen);
			if (szDir[strlen(szDir) - 1] != '\\'){
				strcat(szDir,"\\");
			}
			strcat(szDir,dir);
		}
	}else{
		if (dir[0] == '\\'){
			/* UNC݂̃hCũJgfBNg */
			if (dir[1] == '\\'){
				/* UNC */
				/* printf("UNC\n"); */
				strcpy(szDir,dir);
			}else{
				/* ݂̃hCũ[gfBNg̐Ύw */
				/* printf("݂̃hCũ[gfBNg̐Ύw\n"); */
				szDir[0] = '@' + _getdrive();
				szDir[1] = ':';
				strcpy(szDir + 2,dir);
			}
		}else{
			if (dir[1] == ':'){
				/* hCuw肳ĂB */
				if (len > 2){
					if (dir[2] == '\\'){
						/* ΃pX */
						/* printf("Absolute path\n"); */
						strcpy(szDir,dir);
					}else{
						/* printf("whCȗ΃pX\n"); */
						if (isalpha(dir[0])){
							char *p;
							p = _getdcwd( toupper(dir[0]) - 'A' + 1, szDir, maxlen );
							if (p != NULL){
								/* ݂hCu */
								if (szDir[strlen(szDir) - 1] != '\\'){
									strcat(szDir,"\\");
								}
								strcat(szDir,dir + 2);
							}else{
								/* ݂ȂhCu */
								strcpy(szDir,dir);
							}
						}else{
							/* hCuȊÔ̂w肳Ă */
							strcpy(szDir,dir);
						}
					}
				}else{
					/* printf("hCuŵ\n"); */
					if (isalpha(dir[0])){
						char *p;
						p = _getdcwd( toupper(dir[0]) - 'A' + 1, szDir, maxlen );
						if (p != NULL){
							/* ݂hCu */
							/*
							if (szDir[strlen(szDir) - 1] != '\\'){
								strcat(szDir,"\\");
							}
							*/
							strcat(szDir,dir + 2);
						}else{
							/* ݂ȂhCu */
							strcpy(szDir,dir);
						}
					}else{
						/* hCuȊÔ̂w肳Ă */
						strcpy(szDir,dir);
					}
				}
			}else{
				/* printf("JghCȗ΃pX\n"); */

				/* JgfBNg̑΃pX */
				/* ΃pXɒB */
				_getcwd(szDir,maxlen);
				if (szDir[strlen(szDir) - 1] != '\\'){
					strcat(szDir,"\\");
				}
				strcat(szDir,dir);
			}
		}
	}
}

/*
	l𕶎ɕϊB
	sprintfƂł͑傰B_itoa͔WȂ̂ŎgCȂB
	
		buf ݐ
		target ΏۂƂ鐔
	߂l
		Ȃ
		buf̐ɕϊꂽ
*/
void toString(char *buf,int target)
{
	int i,n,quotient,flag;
	n = 10000;
	flag = 0;
	
	for (i = 0;i < 5;i++){
		quotient = target / n;
		if ((flag) || (quotient > 0)){
			*buf = '0' + quotient;
			flag = 1;
			buf++;
		}
		n = n / 10;
	}
	if (!flag){
		*buf = '0';
		buf++;
	}
	*buf = '\0';
}

/*
	l𕶎ɕϊB
	sprintfƂł͑傰B_itoa͔WȂ̂ŎgCȂB
	
		buf ݐ
		target ΏۂƂ鐔
	߂l
		Ȃ
		buf̐ɕϊꂽ
*/
void toStringW(wchar_t *buf,int target)
{
	int i,n,quotient,flag;
	n = 10000;
	flag = 0;
	
	for (i = 0;i < 5;i++){
		quotient = target / n;
		if ((flag) || (quotient > 0)){
			*buf = L'0' + quotient;
			flag = 1;
			buf++;
		}
		n = n / 10;
	}
	if (!flag){
		*buf = L'0';
		buf++;
	}
	*buf = L'\0';
}

/*
	̃Xy[X؂B
*/
void trimLastSpace(unsigned char *buf)
{
	int flag = 0;	// JbgXy[XǂH
	unsigned char *p;
	
	while(*buf){
		if (*buf < 0x21){
			// Xy[X݂
			if (!flag){
				// ŏ̃Xy[X̏ꍇAtO𗧂ĂăJbgʒuۑB
				flag = 1;
				p = buf;
			}
		}else{
			flag = 0;
		}
		
		buf++;
	}
	if (flag){
		// JbgXy[X炻łB
		*p = '\0';
	}
}

/*
	̃Xy[X؂B
*/
void trimLastSpaceW(wchar_t *buf)
{
	int flag = 0;	// JbgXy[XǂH
	wchar_t *p;
	
	while(*buf){
		if (*buf < 0x21){
			// Xy[X݂
			if (!flag){
				// ŏ̃Xy[X̏ꍇAtO𗧂ĂăJbgʒuۑB
				flag = 1;
				p = buf;
			}
		}else{
			flag = 0;
		}
		
		buf++;
	}
	if (flag){
		// JbgXy[X炻łB
		*p = L'\0';
	}
}

/**
 * bZ[Wo͂B
 *
 * @param message o͂郁bZ[W
 */
void putMessage(const char *message)
{
	if (g_messageType){
		MessageBox(NULL,message,"BookSync",MB_OK | MB_ICONEXCLAMATION);
	}else{
		fprintf(stderr,"%s",message);
	}
}

/**
 * bZ[Wo͂B
 *
 * @param message o͂郁bZ[W
 */
void putMessageW(const wchar_t *message)
{
	if (g_messageType){
		gMessageBoxW(NULL,message,L"BookSync",MB_OK | MB_ICONEXCLAMATION);
	}else{
		fprintf(stderr,"%S",message);
	}
}

/**
 * bZ[Wo͂B(ǉ)
 *
 * @param message o͂郁bZ[W
 * @param message 󋵂ɉo͂郁bZ[W
 */
void putMessage2(const char *message,const char *subMessage)
{
	char *p;
	int len;
	
	if (subMessage == NULL){
		return;
	}
	len = strlen(message) + strlen(subMessage) + 1;
	p = (char *)malloc(len * sizeof(char));
	if (p == NULL){
		return;
	}
	sprintf(p,message,subMessage);
	putMessage(p);
	
	free(p);
}

/**
 * bZ[Wo͂B(ǉ)
 *
 * @param message o͂郁bZ[W
 * @param message 󋵂ɉo͂郁bZ[W
 */
void putMessageWithInfo(const char *message,const char *subMessage)
{
	char *p;
	int len;
	
	if (subMessage == NULL){
		len = 0;
	} else {
		len = strlen(subMessage);
	}
	len = len + strlen(message) + 1;
	p = (char *)malloc(len * sizeof(char));
	if (p == NULL){
		return;
	}
	strcpy(p,message);
	if (subMessage != NULL) {
		strcat(p,subMessage);
	}
	putMessage(p);
	
	free(p);
}

/**
 * bZ[Wo͂B(ǉ)
 *
 * @param message o͂郁bZ[W
 * @param message 󋵂ɉo͂郁bZ[W
 */
void putMessageWithInfoW(const char *message,const wchar_t *subMessage)
{
	wchar_t *p;
	int len;
	int messageLen = 0;

	messageLen = mbstowcsByte(NULL,message,strlen(message));
	
	if (subMessage == NULL){
		len = 0;
	} else {
		len = wcslen(subMessage);
	}
	len = messageLen + len + 1;
	p = (wchar_t *)calloc(len,sizeof(wchar_t));
	if (p == NULL){
		return;
	}
	mbstowcsByte(p,message,strlen(message));
	if (subMessage != NULL) {
		wcscat(p,subMessage);
	}
	putMessageW(p);
	
	free(p);
}

// ----------
// ֘A
// ----------

/**
 * time_t^FILETIME\̂֕ϊB
 *
 * @param time ϊtime_t^̎
 * @param fileTime ϊFILETIME\̂ւ̃|C^
 */
void time_tToFileTime(INT_TIME_T time,FILETIME *fileTime)
{
	struct tm *ptTime;
	SYSTEMTIME sysTime;			// [NpVXe

	// ̃f[^`Ro[g
	ptTime = gmtime((time_t *)&time);
	if (ptTime == NULL){
		return;
	}

	// tm^SYSTEMTIME^ւ̕ϊ
	sysTime.wYear = ptTime->tm_year + 1900;
	sysTime.wMonth = ptTime->tm_mon + 1;
	sysTime.wDay = ptTime->tm_mday;
	sysTime.wHour = ptTime->tm_hour;
	sysTime.wMinute = ptTime->tm_min;
	sysTime.wSecond = ptTime->tm_sec;
	sysTime.wMilliseconds = 0;	// time_t^͕b܂łȂ̂Ń~b0ɂĂB
	sysTime.wDayOfWeek = ptTime->tm_wday;	// jꉞĂB

	// SYSTEMTIME^FILETIME^ւ̕ϊ
	SystemTimeToFileTime(&sysTime,fileTime);
}

/**
 * t@C̍XVݒ肷B
 *
 * @param name t@C
 * @param writeTime XV
 * @param creationTime 쐬
 */
int setulFileTime(
	char *name,
	INT_TIME_T writeTime,
	INT_TIME_T creationTime
)
{
	HANDLE hFile;				// t@Cnh
	FILETIME writeWinTime;		// ŏIXV
	FILETIME creationWinTime;	// 쐬

	// ŏIXV
	// time_tFILETIME^ւ̕ϊ
	time_tToFileTime(writeTime,&writeWinTime);

	// 쐬
	// time_tFILETIME^ւ̕ϊ
	time_tToFileTime(creationTime,&creationWinTime);

	// Zbg
	hFile = CreateFile(name,
						GENERIC_WRITE | GENERIC_READ,
						0,
						NULL,
						OPEN_EXISTING,
						FILE_ATTRIBUTE_NORMAL,
						NULL);
	if (hFile == INVALID_HANDLE_VALUE){
		return 0;
	}

	if (creationTime > 0){
		SetFileTime(hFile,&creationWinTime,NULL,&writeWinTime);
	}else{
		SetFileTime(hFile,NULL,NULL,&writeWinTime);
	}
	CloseHandle(hFile);
	return 1;
}

/**
 * t@C̍XVݒ肷B
 *
 * @param name t@C
 * @param writeTime XV
 * @param creationTime 쐬
 */
int setulFileTimeW(
	wchar_t *name,
	INT_TIME_T writeTime,
	INT_TIME_T creationTime
)
{
	HANDLE hFile;				// t@Cnh
	FILETIME writeWinTime;		// ŏIXV
	FILETIME creationWinTime;	// 쐬

	// ŏIXV
	// time_tFILETIME^ւ̕ϊ
	time_tToFileTime(writeTime,&writeWinTime);

	// 쐬
	// time_tFILETIME^ւ̕ϊ
	time_tToFileTime(creationTime,&creationWinTime);

	// Zbg
	hFile = gCreateFileW(name,
						GENERIC_WRITE | GENERIC_READ,
						0,
						NULL,
						OPEN_EXISTING,
						FILE_ATTRIBUTE_NORMAL,
						NULL);
	if (hFile == INVALID_HANDLE_VALUE){
		return 0;
	}

	if (creationTime > 0){
		SetFileTime(hFile,&creationWinTime,NULL,&writeWinTime);
	}else{
		SetFileTime(hFile,NULL,NULL,&writeWinTime);
	}
	CloseHandle(hFile);
	return 1;
}

/**
 * WindowsFILETIME\̂time_tɕϊB
 * (~b邱ƂɒӁB)
 *
 * @param fTime FILETIME\̂̎
 * @return time_t`̎
 */
INT_TIME_T FileTimeToTime_t(FILETIME *fTime)
{
	struct tm tmTime;
	time_t time;
	SYSTEMTIME sysTime;

	FileTimeToSystemTime(fTime,&sysTime);

	tmTime.tm_year = sysTime.wYear - 1900;
	tmTime.tm_mon = sysTime.wMonth - 1;
	tmTime.tm_mday = sysTime.wDay;
	tmTime.tm_hour = sysTime.wHour;
	tmTime.tm_min = sysTime.wMinute;
	tmTime.tm_sec = sysTime.wSecond;
	tmTime.tm_wday = sysTime.wDayOfWeek;
	tmTime.tm_isdst = -1;
	
	time = mktime(&tmTime);

	// SYSTEMTIMEUTCȂ̂Ŏ␳sB
	TIME_ZONE_INFORMATION timezone;
	DWORD infoResult = GetTimeZoneInformation(&timezone);
	if (infoResult != TIME_ZONE_ID_INVALID){
		time = time - timezone.Bias * 60;
	}

	return time;
}

/**
 * Firefox 3̃ubN}[N̎time_t^ɕϊB<br>
 * v̓~bE}CNb̐؎̂
 *
 * @param fx3Time Firefox 3̎
 * @return time_tɕϊ
 */
time_t fx3TimeToTimet(const char *fx3Time)
{
	INT_TIME_T time = 0;
	int len,i;
	
	if (fx3Time == NULL) {
		return (time_t)0;
	}
	len = strlen(fx3Time);
	if (len < 7) {
		return (time_t)0;
	}

	for (i = 0; i < (len - 6);i++){
		time = time * 10;
		time = time + (fx3Time[i] - '0');
	}
	return (time_t)time;

}

/**
 * ChromẽubN}[N̎time_t^ɕϊB<br>
 * ~bE}CNb̐؎̂ā{␳
 *
 * @param chTime Chrome̎
 * @return time_tɕϊ
 */
time_t chTimeToTimet(const char *chTime)
{
	unsigned __int64 time = 0;
	int len,i;
	
	if (chTime == NULL) {
		return (time_t)0;
	}
	len = strlen(chTime);
	if (len < 7) {
		return (time_t)0;
	}

	for (i = 0; i < (len - 6);i++){
		time = time * 10;
		time = time + (chTime[i] - '0');
	}
	// time_t(Unix time)Chrome̎̎B
	return (time_t)(time - DIFF_UNIX_TO_CHROME);

}

/**
 * IÊCɓ肩ǂ肷B
 *
 * @param ext gq
 * @return 0:IÊCɓł͂Ȃ 1:IÊCɓł
 */
int isIEfavorites(wchar_t *ext)
{
	if ( _wcsicmp( L"url" , ext) == 0 ){
		return 1;
	}
	return 0;
}

/**
 * ̃sIhׂč폜B<br>
 * tH_̐`p<br>
 * Shift_JISp
 *
 * @param buf Ώە
 */
void trimLastPeriod(unsigned char *buf)
{
	unsigned char last;
	unsigned char *top,*p;
	
	top = buf;

	for(;;){
		p = top;
		last = '\0';

		while(*p){
			if (isleadbyte(*p)){
				p++;
			}
			last = *p;
			p++;
		}
		
		if (last == '.'){
			*(p - 1) = '\0';
		}else{
			break;
		}
	}
}

/**
 * ̃sIhׂč폜B(Ch)<br>
 * tH_̐`p
 *
 * @param buf Ώە
 */
void trimLastPeriodW(wchar_t *buf)
{
	wchar_t last;
	wchar_t *top,*p;
	
	top = buf;

	for(;;){
		p = top;
		last = L'\0';

		while(*p){
			last = *p;
			p++;
		}
		
		if (last == L'.'){
			*(p - 1) = L'\0';
		}else{
			break;
		}
	}
}

const char utf8Space[3] = { 0xe3, 0x80, 0x80 };

/**
 * |C^Ă镶UTF-8̑SpXy[X܂ރXy[Xǂ
 *
 * @param target Ώ
 * @return 0:Ώۂ̓Xy[Xł͂Ȃ 1ȏ:Xy[XƂ݂Ȃ
 */
int isSpaceType(char *target)
{
	if (isspace(*target)) {
		return 1;
	}
	if (!memcmp(target, utf8Space, 3)) {
		return 3;
	}
	return 0;
}

/**
 * |C^Ă镶UTF-8̑SpXy[X܂ރXy[Xǂ
 *
 * @param target Ώ
 * @return 0:Ώۂ̓Xy[Xł͂Ȃ 1ȏ:Xy[XƂ݂Ȃ
 */
int isSpaceTypeW(wchar_t *target)
{
	if (iswspace(*target)) {
		return 1;
	}
	if (*target == L'@') {
		return 1;
	}
	return 0;
}

/**
 * P[ݒ肷BvO̍ŏɌĂяoKvB
 *
 */
void setLocale()
{
	if (strstr(setlocale(LC_ALL,LOCALE_NAME),"Japanese") != NULL){
		g_lang = 1;
	}else{
		g_lang = 0;
	}
	_setmbcp(_MB_CP_LOCALE);
}

#define MAX_DEVICE_NAMES 23

/* foCXt@Cێp */
struct deviceNames {
	const char *name;			/* t@C */
	const wchar_t *nameW;		/* t@C(Ch) */
	int len;			/* t@C */
};

/* foCXt@C(\) */
static struct deviceNames deviceNames[MAX_DEVICE_NAMES] = {
	{ "CON", L"CON", 3 },
	{ "PRN", L"PRN", 3 },
	{ "AUX", L"AUX", 3 },
	{ "NUL", L"NUL", 3 },
	{ "COM1", L"COM1", 4 },
	{ "COM2", L"COM2", 4 },
	{ "COM3", L"COM3", 4 },
	{ "COM4", L"COM4", 4 },
	{ "COM5", L"COM5", 4 },
	{ "COM6", L"COM6", 4 },
	{ "COM7", L"COM7", 4 },
	{ "COM8", L"COM8", 4 },
	{ "COM9", L"COM9", 4 },
	{ "LPT1", L"LPT1", 4 },
	{ "LPT2", L"LPT2", 4 },
	{ "LPT3", L"LPT3", 4 },
	{ "LPT4", L"LPT4", 4 },
	{ "LPT5", L"LPT5", 4 },
	{ "LPT6", L"LPT6", 4 },
	{ "LPT7", L"LPT7", 4 },
	{ "LPT8", L"LPT8", 4 },
	{ "LPT9", L"LPT9", 4 },
	{ "CLOCK$", L"CLOCK$", 6 }
};


/**
 * 񂪃foCXt@Cǂ̌
 *
 * @param name Ώە
 * @return 1:foCXt@C 0:̓foCXt@Cł͂Ȃ
 */
int isDeviceName(char *name)
{
	int i;
	
	for (i = 0;i < MAX_DEVICE_NAMES;i++){
		/* ̂̃YoǂH */
		if (_stricmp(name,deviceNames[i].name) == 0){
			return 1;
		}
		
		/* "foCXt@C." t@CƂĔF߂Ȃ̂Ń`FbN */
		if (_strnicmp(name,deviceNames[i].name,deviceNames[i].len) == 0){
			if (name[deviceNames[i].len] == '.'){
				return 1;
			}
		}
	}
	
	return 0;
}

/**
 * 񂪃foCXt@Cǂ̌(ChL)
 *
 * @param name Ώە
 * @return 1:foCXt@C 0:̓foCXt@Cł͂Ȃ
 */
int isDeviceNameW(wchar_t *name)
{
	int i;
	
	for (i = 0;i < MAX_DEVICE_NAMES;i++){
		/* ̂̃YoǂH */
		if (_wcsicmp(name,deviceNames[i].nameW) == 0){
			return 1;
		}

		/* "foCXt@C." t@CƂĔF߂Ȃ̂Ń`FbN */
		if (_wcsnicmp(name,deviceNames[i].nameW,deviceNames[i].len) == 0){
			if (name[deviceNames[i].len] == L'.'){
				return 1;
			}
		}
	}
	
	return 0;
}

// ----------------
// IE֘A
// ----------------

/**
 * IẼW[o[W擾B(IE4ȍ~)
 *
 * @return -1:擾s ȊO:W[o[W
 *
 */
int getIeMajorVersion(void)
{
	char buf[32];	// WXglobt@
	char *p;		// 
	LONG result;	// e֐̎sʁB
	HKEY hKey;		// WXgL[nh
	int version = -1;	// 
	DWORD size;		// obt@TCY

	// IẼo[WWXgL[JB
	result = RegOpenKeyEx(HKEY_LOCAL_MACHINE,"Software\\Microsoft\\Internet Explorer",0,
							KEY_READ,&hKey);

	if (result == ERROR_SUCCESS){
		// WXgL[J獡xVersionl擾B
		buf[31] = '\0';
		size = 31;

		result = RegQueryValueEx(hKey,"svcVersion",NULL,NULL,
								(LPBYTE)buf,&size);
		if (result == ERROR_SUCCESS){
			// IE 10ȍ~svcVersion̒lƂB
			// ŏ.܂(W[o[W)擾B
			p = strchr(buf,'.');
			if (p != NULL){
				*p = '\0';
				version = atoi(buf);
			}
		} else {
			// IE 9ȉVersion̒lƂB
			result = RegQueryValueEx(hKey,"Version",NULL,NULL,
									(LPBYTE)buf,&size);
			
			if (result == ERROR_SUCCESS){
				// ŏ.܂(W[o[W)擾B
				p = strchr(buf,'.');
				if (p != NULL){
					*p = '\0';
					version = atoi(buf);
				}
			}
		}
		RegCloseKey(hKey);
	}

	return version;
}

/**
 * IÊCɓtH_擾B
 *
 * @param buf 擾
 */
void getIEfavoriteFolder(char *buf)
{
	LPITEMIDLIST pItemIDList;
	HRESULT hr;
	LPMALLOC pMalloc = NULL;//IMallocւ̃|C^
	HRESULT r;

	// CɓtH_̎擾
	r = SHGetSpecialFolderLocation(GetDesktopWindow(),CSIDL_FAVORITES,&pItemIDList);
	if (r == NOERROR){
		hr = SHGetMalloc(&pMalloc);
		if (hr != E_FAIL) {
			// szDirփpXƂĎ擾
			SHGetPathFromIDList(pItemIDList,buf);
			pMalloc->Free(pItemIDList);
			pMalloc->Release();
		}
	}
}

/**
 * LocalSettings\Application DatafBNg擾B 
 *
 * @param buf 擾
 */
void GetWindowsDir(char *buf)
{
	ITEMIDLIST *lpid;

    HRESULT hr;
    LPMALLOC pMalloc = NULL;//IMallocւ̃|C^

	hr = SHGetSpecialFolderLocation(NULL,CSIDL_WINDOWS,&lpid);
	if (hr != NOERROR) {
		return;
	} else {
        hr = SHGetMalloc(&pMalloc);
        if (hr == E_FAIL) {
            ::MessageBox(NULL, "SHGetMalloc Error", "Error", MB_OK);
            return;
        }
        SHGetPathFromIDList(lpid, buf);

		pMalloc->Free(lpid);
		pMalloc->Release();
	}
}

/**
 * e|t@C𐶐B
 *
 * @param buf e|t@C̊i[
 * @return 0:쐬 1:쐬s
 */
int getTemporaryName(char *buf)
{
	char *temp;	// e|tH_

	try {
		temp = new char[_MAX_PATH];
	}catch(...){
		return 1;
	}

	// e|fBNgB
	DWORD tempResult = GetTempPath(_MAX_PATH,temp);
	if (tempResult == 0){
		delete []temp;
		return 1;
	}

	// e|t@C
	GetTempFileName(temp,"BS",0,buf);

	delete []temp;
	return 0;
}

/**
 * Application DatafBNg擾B 
 *
 * @param buf 擾
 */
void GetAppDataDir(char *buf)
{
	ITEMIDLIST *lpid;

    HRESULT hr;
    LPMALLOC pMalloc = NULL;//IMallocւ̃|C^

	hr = SHGetSpecialFolderLocation(NULL,CSIDL_APPDATA,&lpid);
	if (hr != NOERROR) {
		return;
	} else {
        hr = SHGetMalloc(&pMalloc);
        if (hr == E_FAIL) {
            ::MessageBox(NULL, "SHGetMalloc Error", "Error", MB_OK);
            return;
        }
        SHGetPathFromIDList(lpid, buf);

		pMalloc->Free(lpid);
		pMalloc->Release();
	}
}

/**
 * LocalSettings\Application DatafBNg擾B 
 *
 * @param buf 擾
 */
void GetLocalAppDataDir(char *buf)
{
	ITEMIDLIST *lpid;

    HRESULT hr;
    LPMALLOC pMalloc = NULL;//IMallocւ̃|C^

	hr = SHGetSpecialFolderLocation(NULL,CSIDL_LOCAL_APPDATA,&lpid);
	if (hr != NOERROR) {
		return;
	} else {
        hr = SHGetMalloc(&pMalloc);
        if (hr == E_FAIL) {
            ::MessageBox(NULL, "SHGetMalloc Error", "Error", MB_OK);
            return;
        }
        SHGetPathFromIDList(lpid, buf);

		pMalloc->Free(lpid);
		pMalloc->Release();
	}
}

/**
 * 񂪃tpXǂB
 *
 * @param path ΏۃpX
 * @return true:tpX false:tpXł͂Ȃ
 */
bool isFullPath(const char *path)
{
	if (path == NULL) {
		return false;
	}

	if (strlen(path) < 3) {
		return false;
	}

	if (isalpha(path[0]) && (path[1] == ':') && (path[2] == '\\')) {
		// tpX
		return true;
	}
	if ((path[0] == '\\') && (path[1] == '\\')) {
		// lbg[NpX̃tpX
		return true;
	}
	return false;
}
/**
 * Ō\ȍ~擾B
 *
 * @param path Ώە
 * @return 
 */
char *getLast(char *path)
{
	char *find = NULL;
	char *p;
	
	if (path == NULL){
		return path;
	}
	p = path;

	if (*p == '\\'){	// ΃pX?
		p++;
		if (*p == '\\'){	// UNC\LB
			p++;
		}
		find = p;
	}
	while(*p){
		if (isleadbyte(*p)){
			p++;
		}else{
			if (*p == '\\'){
				p++;
				while(*p == '\\'){	// \₪Y΍
					p++;
				}
				find = p;
			}
		}
		p++;
	}
	if (find != NULL){
		return find;
	}else{
		return path;
	}
}

/**
 * UUID𐶐B
 *
 * @param buf UUIDi[(38oCgȏKv)
 */
void createUUID(char *buf)
{
	unsigned char *p;
	UUID uuid;

	::UuidCreate(&uuid);                  // UUID
	::UuidToStringA(&uuid, &p);           // UUID𕶎ɂ

	strcpy(buf, (char *)p);

	::RpcStringFree(&p);
}

/**
* ̃̕ubNJĐṼubNݒ肷B
*
* @param pointer li[|C^
* @param item ݒ肷l
* @return ݒ肵lւ̃|C^
*/
char *reAllocate(char *&pointer, const char *item)
{
	char *p;
	int len;

	if (pointer != NULL){
		delete[]pointer;
		pointer = NULL;
	}

	if (item == NULL){
		return NULL;
	}

	len = strlen(item) + 1;

	try{
		p = new char[len];
		if (p == NULL){
			return NULL;
		}
		strcpy(p, item);
		pointer = p;
	}
	catch (...){
		return NULL;
	}
	return p;
}

/**
* Unix timeChrome̎\ŏo͂B
*
* @param fp o͐̃t@C|C^
* @param time o͂鎞(Unix time)
*/
void putChromeDateTime(FILE *fp, time_t time)
{
	unsigned __int64 time64;

	time64 = (unsigned __int64)time;
	// time_t(Unix time)Chrome̎̎𑫂B
	time64 += DIFF_UNIX_TO_CHROME;
	fprintf(fp, "%I64u000000", time64);
}

