#ifndef TJSONVALUE_H
#define TJSONVALUE_H

#include	<vector>
#include	<map>
#include	<utility>
#include	<string>

class TJsonValue {
public:
	// ľ^
	enum ValueType {
		UNKNOWN_TYPE,	// s
		VALUE,	// l
		ARRAY,	// z
		OBJECT	// IuWFNg
	};

	// l̃Tu^Cv
	enum ValueSubType {
		UNKNOWN_SUB_TYPE,	// s
		STRING,		// 
		NUMBER		// l
	};

private:
	ValueType type;
	ValueSubType subType;

	std::vector<TJsonValue *> arrayValue;
	std::map<const std::string,TJsonValue *> objectValueMap;
	char *value;

	void _copy(const TJsonValue &src);

public:

	TJsonValue();
	TJsonValue(const TJsonValue &src);
	virtual ~TJsonValue();
	TJsonValue & operator = (const TJsonValue &src);

	ValueType getType(void) const
	{
		return type;
	}

	ValueType setType(ValueType newType)
	{
		type = newType;
		return type;
	}

	ValueSubType getSubType(void) const
	{
		return subType;
	}

	ValueSubType setSubType(ValueSubType newSubType)
	{
		subType = newSubType;

		return subType;
	}

	char *getValue(void) const
	{
		return value;
	}
	void setValue(const char *newValue);

	TJsonValue *addArrayValue(void);
	unsigned int getArrayCount(void) const
	{
		return arrayValue.size();
	}
	TJsonValue *getArrayValue(unsigned int no) const
	{
		return arrayValue[no];
	}

	TJsonValue *addObjectValue(std::string key);
	TJsonValue *getObjectValue(const std::string key) const;
	TJsonValue *getObjectValue(int index) const;
	std::string getObjectKey(int index) const;

	unsigned int getObjectCount(void) const
	{
		return objectValueMap.size();
	}

};

typedef std::pair<const std::string,TJsonValue *> object_value;
typedef std::map<const std::string,TJsonValue *> OBJECT_MAP;

#endif
