#include	<assert.h>
#include	<stdio.h>
#include	<string.h>
#include	"TJsonValue.h"

// cl -GX TJsonValue.cpp

/**
 * RXgN^
 */
TJsonValue::TJsonValue()
{
	value = NULL;
	type = TJsonValue::UNKNOWN_TYPE;
	subType = TJsonValue::UNKNOWN_SUB_TYPE;
}

/**
 * Rs[RXgN^
 *
 * @param src Rs[̃IuWFNg
 */
TJsonValue::TJsonValue(const TJsonValue &src)
{
	value = NULL;
	type = TJsonValue::UNKNOWN_TYPE;
	subType = TJsonValue::UNKNOWN_SUB_TYPE;

	_copy(src);
}

/**
 * fXgN^
 */
TJsonValue::~TJsonValue()
{
	if (value != NULL) {
		delete []value;
	}
	
	for (unsigned int i = 0;i < arrayValue.size();i++) {
		if (arrayValue[i] != NULL) {
			delete arrayValue[i];
		}
	}

	for (OBJECT_MAP::iterator it = objectValueMap.begin();it != objectValueMap.end();it++) {
		TJsonValue *objectValue = it->second;
		if (objectValue != NULL) {
			delete objectValue;
		}
	}
}

/**
 * =Zq̃I[o[[h
 *
 * @param src ʌ̎Q
 * @return *this
 */
TJsonValue & TJsonValue::operator = (const TJsonValue &src)
{
#ifdef SELFTEST
	printf("= operator called.\n");
#endif
	_copy(src);

	return *this;
}

/**
 * ẽRs[
 *
 * @param src Rs[̃IuWFNg
 */
void TJsonValue::_copy(const TJsonValue &src)
{
	// `̃Rs[
	setType(src.getType());
	// ľ`̃Rs[
	setSubType(src.getSubType());

	// lꍇRs[B
	if (src.getValue() != NULL) {
		setValue(src.getValue());
	}

	if (src.getType() == TJsonValue::ARRAY) {
		// z̏ꍇAzRs[B
		unsigned int size = src.getArrayCount();
		for (unsigned int i = 0; i < size; i++) {
			if (src.getArrayValue(i) != NULL) {
				// zɍڂǉĒlRs[B
				*addArrayValue() = *(src.getArrayValue(i));
			} else {
				// Ȃ̂ŁANULLǉB
				arrayValue.push_back(NULL);
			}
		}
	}

	if (src.getType() == TJsonValue::OBJECT) {
		// IuWFNg̏ꍇARs[B
		unsigned int itemCount = src.getObjectCount();
		for (unsigned int i = 0; i < itemCount; i++) {
			std::string key = src.getObjectKey(i);
			*addObjectValue(key) = *(src.getObjectValue(key));
		}
	}
}

/**
 * lݒ肷B
 *
 * @param newValue Vl
 */
void TJsonValue::setValue(const char *newValue)
{
	if (value != NULL) {
		delete []value;
		value = NULL;
	}

	if (newValue == NULL) {
		return;
	}
	int len = strlen(newValue);

	try {
		value = new char[len + 1];
		if (value == NULL) {
			return;
		}
		strcpy(value,newValue);
	} catch(...) {
		return;
	}
}

/**
 * z̒lǉB
 *
 * @return NULL:Vl NULL:l̒ǉɎs
 */
TJsonValue *TJsonValue::addArrayValue(void)
{

	try {
		TJsonValue *newValue = new TJsonValue();
		if (newValue == NULL) {
			return NULL;
		}
		arrayValue.push_back(newValue);
		return newValue;
	} catch(...) {
		return NULL;
	}
}

/**
 * IuWFNg̒lǉB
 *
 * @return NULL:Vl NULL:l̒ǉɎs
 */
TJsonValue *TJsonValue::addObjectValue(std::string key)
{
	try {
		TJsonValue *newValue = new TJsonValue();
		if (newValue == NULL) {
			return NULL;
		}
		objectValueMap.insert(object_value(key,newValue));
		return newValue;
	} catch(...) {
		return NULL;
	}
}

/**
 * IuWFNg̒l擾B
 *
 * @param key IuWFNg̃L[
 * @return NULL:擾l NULL:l݂͑Ȃ
 */
TJsonValue *TJsonValue::getObjectValue(const std::string key) const
{
	OBJECT_MAP::const_iterator gotValue;

	gotValue = objectValueMap.find(key);
	if (gotValue != objectValueMap.end()) {
		return gotValue->second;
	}
	return NULL;
}

/**
 * IuWFNg̒l擾B
 *
 * @param index IuWFNg̃CfbNX
 * @return NULL:擾l NULL:l݂͑Ȃ
 */
TJsonValue *TJsonValue::getObjectValue(int index) const
{
	int count = getObjectCount();
	if (index >= count) {
		return NULL;
	}
	std::map<const std::string,TJsonValue *>::const_iterator it = objectValueMap.begin();
	for (int i = 0; i < count; i++) {
		if (i == index) {
			return it->second;
		}
		it++;
	}

	return NULL;
}

/**
 * IuWFNg̃L[擾B
 *
 * @param index IuWFNg̃CfbNX
 * @return NULL:擾L[ NULL:l݂͑Ȃ
 */
std::string TJsonValue::getObjectKey(int index) const
{
	int count = getObjectCount();
	if (index >= count) {
		return NULL;
	}
	std::map<const std::string,TJsonValue *>::const_iterator it = objectValueMap.begin();
	for (int i = 0; i < count; i++) {
		if (i == index) {
			return it->first;
		}
		it++;
	}

	return NULL;
}

#ifdef SELFTEST

int main(int argc, char *argv[])
{
	TJsonValue *val1;
	TJsonValue *val2;
	TJsonValue *val3;
	TJsonValue *val4;
	TJsonValue *val5;
	TJsonValue *val6;

	// l̃eXg
	val1 = new TJsonValue();
	val2 = new TJsonValue();

	val1->setType(TJsonValue::VALUE);
	val1->setSubType(TJsonValue::STRING);
	val1->setValue("This is a test.");
	
	*val2 = *val1;
	
	assert(val2->getType() == TJsonValue::VALUE);
	assert(val2->getSubType() == TJsonValue::STRING);
	assert(!strcmp("This is a test.", val2->getValue()));
	assert(val1->getValue() != val2->getValue());
	
	free(val2);
	free(val1);

	// z̃eXg
	val1 = new TJsonValue();
	val2 = new TJsonValue();

	val1->setType(TJsonValue::ARRAY);
	val1->addArrayValue();
	val1->addArrayValue();

	val3 = val1->getArrayValue(0);
	val3->setType(TJsonValue::VALUE);
	val3->setSubType(TJsonValue::STRING);
	val3->setValue("This is a test.");

	val4 = val1->getArrayValue(1);
	val4->setType(TJsonValue::VALUE);
	val4->setSubType(TJsonValue::NUMBER);
	val4->setValue("12345");

	*val2 = *val1;
	
	assert(val2->getType() == TJsonValue::ARRAY);

	val5 = val2->getArrayValue(0);

	assert(val5->getType() == TJsonValue::VALUE);
	assert(val5->getSubType() == TJsonValue::STRING);
	assert(!strcmp("This is a test.", val5->getValue()));
	assert(val3->getValue() != val5->getValue());

	val6 = val2->getArrayValue(1);

	assert(val6->getType() == TJsonValue::VALUE);
	assert(val6->getSubType() == TJsonValue::NUMBER);
	assert(!strcmp("12345", val6->getValue()));
	assert(val4->getValue() != val6->getValue());

	free(val2);
	free(val1);

	// IuWFNg̃eXg
	val1 = new TJsonValue();
	val2 = new TJsonValue();

	val1->setType(TJsonValue::OBJECT);
	val1->addObjectValue("ABC");
	val1->addObjectValue("XYZ");

	val3 = val1->getObjectValue("ABC");
	val3->setType(TJsonValue::VALUE);
	val3->setSubType(TJsonValue::STRING);
	val3->setValue("This is a test.");

	val4 = val1->getObjectValue("XYZ");
	val4->setType(TJsonValue::VALUE);
	val4->setSubType(TJsonValue::NUMBER);
	val4->setValue("12345");

	*val2 = *val1;
	
	assert(val2->getType() == TJsonValue::OBJECT);

	val5 = val2->getObjectValue("ABC");
	assert(val5 != NULL);

	assert(val5->getType() == TJsonValue::VALUE);
	assert(val5->getSubType() == TJsonValue::STRING);
	assert(!strcmp("This is a test.", val5->getValue()));
	assert(val3->getValue() != val5->getValue());

	val6 = val2->getObjectValue("XYZ");
	assert(val6 != NULL);

	assert(val6->getType() == TJsonValue::VALUE);
	assert(val6->getSubType() == TJsonValue::NUMBER);
	assert(!strcmp("12345", val6->getValue()));
	assert(val4->getValue() != val6->getValue());

	free(val2);
	free(val1);

}

#endif
