#ifndef TJSON_H
#define TJSON_H

#include	<vector>
#include	"TJsonValue.h"

#define TJSON_BUFLEN 40960

class TJson {

	enum ItemType {
		INVALID,	// sȃ^Cv
		NONE,	// ^CvȂ
		ARRAY,	// z
		OBJECT,	// IuWFNg
		KEY,	// L[݂ĂB
		VALUE,	// l
		NEED_SEPARATOR	// ؂肪Kv
	};

	// JSON͏
	struct TJsonParseStatus {
		bool inString;		// ̒H
		bool stringEscape;	// ̃GXP[vH
		bool inValue;		// l̒?
	};

private:

	unsigned int elementPoint;	// \vf݈̌ʒu
	std::vector<ItemType> elementStack;	// \vf
	unsigned int valuePoint;	// \vf݈̌ʒu
	std::vector<TJsonValue *> valueStack;	// \vf
	TJsonValue topValue;		// 擪̒l
	TJsonValue *currentValue;	// ݈Ăl

	// ꎞobt@
	char *keyBuf;	// L[obt@
	char *valueBuf;	// lobt@
	char *valuePtr;	// lobt@̃|C^
	int valueCount;	// lobt@̕JE^
	int valueMax;	// lobt@̗e
	char *workBuf;	// [Npobt@
	int lineCount;	// sԍ

	void addValue(char c);
	void resetValue(void);

	void extractEscape(char *dst,int dstSize,char *src);
	int extractHex(char *dst,char *src);
	int extractHex2(char *dst,char *src);

	void pushElement(ItemType type);
	void popElement(void);
	ItemType previousElement(void);

	void pushValue(TJsonValue *type);
	void popValue(void);
	TJsonValue * previousValue(void);

	int testArrayStart();
	int testObjectStart();
	int testKey();
	int testSeparator();

	int onArrayStart();
	int onObjectStart();
	int onKey();

	int arrayEnd();
	int objectEnd();
	int valueEnd(TJsonValue::ValueSubType subType);

	int parseString(struct TJsonParseStatus *stat,char c);
	int parseJSON(struct TJsonParseStatus *stat,char c);
	void initParseStatus(struct TJsonParseStatus *stat);

public:
	int readFile(const char *bmFile);
	TJsonValue *getTopValue(void)
	{
		return &topValue;
	}

	TJson();
	~TJson();

};

#endif
