// Wwb_
#if defined(_DEBUG) && defined(_MSC_VER) && defined(_NOT_MFC)
#define _CRTDBG_MAP_ALLOC
#endif

#include	<stdlib.h>

#if defined(_DEBUG) && defined(_MSC_VER) && defined(_NOT_MFC)
#include	<crtdbg.h>
#endif

#include	<fstream>
#include	<iostream>
#include	<stdio.h>
#include	<string.h>
#include	<wchar.h>
#include	<direct.h>
#include	<locale.h>
#include	<windows.h>
#include	<winbase.h>
#include	<winnetwk.h>
#include	<shlobj.h>
#include	<winreg.h>
#include	<io.h>
#include	<time.h>

// vbgtH[wb_
#include	"TJson.h"
#include	"encutil2.h"

#ifdef __BORLANDC__
#define	_stricmp stricmp
#endif

/**
 *	RXgN^
 */
TJson::TJson()
{
	keyBuf = NULL;
	valueBuf = NULL;
	workBuf = NULL;
	elementPoint = 0;
	// Ăl̏
	valuePoint = 0;
	currentValue = &topValue;

	try {
		keyBuf = new char[TJSON_BUFLEN + 1];
		if (keyBuf == NULL) {
			return;
		}
		keyBuf[TJSON_BUFLEN] = '\0';

		valueBuf = new char[TJSON_BUFLEN + 1];
		if (valueBuf == NULL) {
			delete []keyBuf;
			return;
		}
		valuePtr = valueBuf;
		valueBuf[TJSON_BUFLEN] = '\0';
		valueMax = TJSON_BUFLEN;
		valueCount = 0;

		workBuf = new char[TJSON_BUFLEN + 1];
		if (workBuf == NULL) {
			delete []keyBuf;
			delete []valueBuf;
			return;
		}
		workBuf[TJSON_BUFLEN] = '\0';
	} catch (...) {
		if (keyBuf != NULL) {
			delete []keyBuf;
		}
		if (valueBuf == NULL) {
			delete []valueBuf;
			return;
		}
		return;
	}

}

/**
 * fXgN^
 *
 */
TJson::~TJson()
{
	if (keyBuf != NULL) {
		delete []keyBuf;
	}

	if (valueBuf != NULL) {
		delete []valueBuf;
	}

	if (workBuf != NULL) {
		delete []workBuf;
	}

}

/**
 * lobt@ɕǉB
 *
 * @param c ǉ镶
 */
void TJson::addValue(char c)
{
	if (valueCount < TJSON_BUFLEN) {
		*valuePtr = c;
		*(valuePtr + 1) = '\0';
		valuePtr++;
		valueCount++;
	}
}

/**
 * lobt@B
 */
void TJson::resetValue(void)
{
	valuePtr = valueBuf;
	valueCount = 0;
	*valuePtr = '\0';
}

/**
 * \vfX^bNɒlpushB
 *
 * @param type \vf
 */
void TJson::pushElement(ItemType type)
{
	if (elementPoint >= elementStack.size()) {
		elementStack.push_back(type);
		elementPoint++;
	} else {
		elementStack[elementPoint] = type;
		elementPoint++;
	}
}

/**
 * \vfX^bN̒lpopB
 */
void TJson::popElement(void)
{
	if (elementPoint > 0) {
		elementPoint--;
	}
}

/**
 * 1O̍\vfԂB
 *
 * @return \vf
 */
TJson::ItemType TJson::previousElement(void)
{
	if (elementPoint == 0) {
		return TJson::NONE;
	}
	return elementStack[elementPoint - 1];
}

/**
 * lX^bNɒlpushB
 *
 * @param type \vf
 */
void TJson::pushValue(TJsonValue *value)
{
	if (valuePoint >= valueStack.size()) {
		valueStack.push_back(value);
		valuePoint++;
	} else {
		valueStack[valuePoint] = value;
		valuePoint++;
	}
}

/**
 * \vfX^bN̒lpopB
 */
void TJson::popValue(void)
{
	if (valuePoint > 0) {
		valuePoint--;
	}
}

/**
 * 1O̍\vfԂB
 *
 * @return \vf
 */
TJsonValue *TJson::previousValue(void)
{
	if (valuePoint == 0) {
		return NULL;
	}
	return valueStack[valuePoint - 1];
}

/**
 * 416iWJB
 *
 * @param dst WJ(3ȏ̗̈悪Kv)
 * @param src WJ
 * @return 0:ϊs 1:ϊ̕
 */
int TJson::extractHex(char *dst,char *src)
{
	unsigned long uc;
	int c;
	wchar_t buf[2];
	
	uc = 0;

	for (int i = 0;i < 4;i++) {
		if (!isxdigit(*(src + i))){
			// 16iłȂꍇ͕sƂB
			return 0;
		}
		c = (int)(*(src + i));
		if (isdigit(c)){
			uc = (uc << 4) + (c - '0');
		}else if (isupper(c)){
			uc = (uc << 4) + (c - 'A' + 10);
		}else{
			// ͏Ȃ
			uc = (uc << 4) + (c - 'a' + 10);
		}
	}
	buf[0] = (wchar_t)(uc);
	buf[1] = L'\0';
	int result = countUTF16LEtoUTF8str(buf);
	toUTF8((unsigned char *)dst,buf);

	return result;
}

/**
 * 216iWJB
 *
 * @param dst WJ(3ȏ̗̈悪Kv)
 * @param src WJ
 * @return 0:ϊs 1:ϊ̕
 */
int TJson::extractHex2(char *dst,char *src)
{
	unsigned long uc;
	int c;
	wchar_t buf[2];
	
	uc = 0;

	for (int i = 0;i < 2;i++) {
		if (!isxdigit(*(src + i))){
			// 16iłȂꍇ͕sƂB
			return 0;
		}
		c = (int)(*(src + i));
		if (isdigit(c)){
			uc = (uc << 4) + (c - '0');
		}else if (isupper(c)){
			uc = (uc << 4) + (c - 'A' + 10);
		}else{
			// ͏Ȃ
			uc = (uc << 4) + (c - 'a' + 10);
		}
	}
	buf[0] = (wchar_t)(uc);
	buf[1] = L'\0';
	int result = countUTF16LEtoUTF8str(buf);
	toUTF8((unsigned char *)dst,buf);

	return result;
}

/**
 * obNXbVGXP[vWJB
 *
 * @param dst WJ(WJƓTCYKv)
 * @param dstSize WJ̃TCY
 * @param src WJ
 */
void TJson::extractEscape(char *dst,int dstSize,char *src)
{
	char *next = dst;
	char *current = src;
	int result = 0;
	int dstCount = 0;

	while(*current) {
		if (dstCount > (dstSize - 4)) {
			break;
		}
		switch (*current) {
			case '\\':
				switch (*(current + 1)) {
					case '\\':
						*next = '\\';
						next++;
						dstCount++;
						current += 2;
						break;
					case '/':
						*next = '/';
						next++;
						dstCount++;
						current += 2;
						break;
					case 'b':
						*next = '\b';
						next++;
						dstCount++;
						current += 2;
						break;
					case 'f':
						*next = '\f';
						next++;
						dstCount++;
						current += 2;
						break;
					case 'n':
						*next = '\n';
						next++;
						dstCount++;
						current += 2;
						break;
					case 'r':
						*next = '\r';
						next++;
						dstCount++;
						current += 2;
						break;
					case 't':
						*next = '\t';
						next++;
						dstCount++;
						current += 2;
						break;
					case 'u':
						// 16i`
						result = extractHex(next,current + 2);
						if (result != 0) {
							next += result;
							dstCount += result;
							current += 6;
						} else {
							*next = 'u';
							next++;
							dstCount++;
							current += 2;
						}
						break;
					case 'x':
						// 216i`
						result = extractHex2(next,current + 2);
						if (result != 0) {
							next += result;
							dstCount += result;
							current += 4;
						} else {
							*next = 'x';
							next++;
							dstCount++;
							current += 2;
						}
						break;
					default:
						*next = *(current + 1);
						next++;
						dstCount++;
						current += 2;
						break;
				}
				break;
			default:
				*next = *current;
				current++;
				next++;
				dstCount++;
				break;
		}
	}
	*next = '\0';
}

//
// \͕
//

/**
 * zJnĂ悢ǂB
 *
 * @return 0:Jn\ 1:Jns\
 */
int TJson::testArrayStart()
{
	ItemType current;

	current = previousElement();
	switch(current) {
		case NONE:
			return 0;
		case OBJECT:	// IuWFNg̒ɂ͓Ȃ
			return 1;
		case ARRAY:		// z̒̔z\
			return 0;
		case KEY:	// L[ɑ΂l͉\B
			return 0;
		default:
			return 1;
	}

}

/**
 * IuWFNgJnĂ悢ǂB
 *
 * @return 0:Jn\ 1:Jns\
 */
int TJson::testObjectStart()
{
	ItemType current;

	current = previousElement();
	switch(current) {
		case NONE:
			return 0;
		case OBJECT:	// IuWFNg̒ɂ͓Ȃ
			return 1;
		case ARRAY:		// z̗vfƂẴIuWFNg͉\
			return 0;
		case KEY:	// L[ɑ΂l͉\B
			return 0;
		default:
			return 1;
	}

}

/**
 * Zp[^݂Ă悢ǂB
 *
 * @return 0:݉\ 1:ݕs\
 */
int TJson::testSeparator()
{
	ItemType current;

	current = previousElement();
	switch(current) {
		case NEED_SEPARATOR:
			// J}Kvȏꍇ͎̗vfB
			popElement();
			return 0;
		default:
			return 1;
	}

}

/**
 * L[݂Ă悢ǂB
 *
 * @return 0:݉\ 1:ݕs\
 */
int TJson::testKey()
{
	ItemType current;

	current = previousElement();
	switch(current) {
		case INVALID:
			return 1;
		case OBJECT:	// IuWFNg̒ɓ
			return 0;
		case ARRAY:		// z̗vfł͂Ȃ
			return 1;
		case KEY:	// L[̎L[͕sB
			return 1;
		default:
			return 1;
	}

}

/**
 * zJn
 *
 * @return 0:I 1:G[
 */
int TJson::onArrayStart()
{
	ItemType current;
	TJsonValue *newValue;	// ǉIuWFNg

	current = previousElement();
	switch(current) {
		case NONE:
			newValue = &topValue;
			break;
		case OBJECT:	// IuWFNg̒ɂ͓Ȃ
			return 1;
		case ARRAY:		// z̗vfƂẴIuWFNg͉\
			newValue = currentValue->addArrayValue();
			if (newValue == NULL) {
				return 1;
			}
			break;
		case KEY:	// L[ɑ΂l͉\B
			newValue = currentValue->addObjectValue(keyBuf);
			if (newValue == NULL) {
				return 1;
			}
			break;
		default:
			return 1;
	}
	newValue->setType(TJsonValue::ARRAY);
	// ꂩ͔zB
	pushValue(newValue);
	currentValue = newValue;

	pushElement(TJson::ARRAY);
	return 0;
}

/**
 * IuWFNgJn
 *
 * @return 0:I 1:G[
 */
int TJson::onObjectStart()
{
	ItemType current;
	TJsonValue *newValue;	// ǉIuWFNg

	current = previousElement();
	switch(current) {
		case NONE:
			newValue = &topValue;
			break;
		case OBJECT:	// IuWFNg̒ɂ͓Ȃ
			return 1;
		case ARRAY:		// z̗vfƂẴIuWFNg͉\
			newValue = currentValue->addArrayValue();
			if (newValue == NULL) {
#ifdef TJSON_TRACE
				std::cout << "z̃IuWFNgǉɎs" << std::endl;
#endif
				return 1;
			}
			break;
		case KEY:	// L[ɑ΂l͉\B
			newValue = currentValue->addObjectValue(keyBuf);
			if (newValue == NULL) {
#ifdef TJSON_TRACE
				std::cout << "IuWFNgւ̃IuWFNgǉɎs" << std::endl;
#endif
				return 1;
			}
			break;
		default:
			return 1;
	}
	newValue->setType(TJsonValue::OBJECT);
	// ꂩ̓IuWFNgB
	pushValue(newValue);
	currentValue = newValue;

	pushElement(TJson::OBJECT);
	return 0;
}

/**
 * L[쐬
 *
 * @return 0:I 1:G[
 */
int TJson::onKey()
{
	ItemType current;

	current = previousElement();
	switch(current) {
		case INVALID:
			return 1;
		case OBJECT:	// IuWFNg̒ɓ
			strcpy(keyBuf,valueBuf);
			pushElement(TJson::KEY);
			return 0;
		case ARRAY:		// z̗vfł͂Ȃ
			return 1;
		case KEY:	// L[̎L[͕sB
			return 1;
		default:
			return 1;
	}

}


/**
 * zȈ
 */
int TJson::arrayEnd()
{
	ItemType current;

	// 1ȏ̒lāA,҂̏ꍇ͌ɖ߂B
	current = previousElement();
	if (current == NEED_SEPARATOR) {
		popElement();
	}

	// Ăl݂̔z񂩂1Oɖ߂B
	popValue();
	currentValue = previousValue();

	// z񊮗
	popElement();
	if (previousElement() == TJson::ARRAY) {
		// z񂪃L[̒l̏ꍇ́AɃJ}Kv
		pushElement(TJson::NEED_SEPARATOR);
	} else if (previousElement() == TJson::KEY) {
		// z񂪃L[̒l̏ꍇ́AL[IB
		popElement();
		pushElement(TJson::NEED_SEPARATOR);
	}
	return 0;
}

/**
 * IuWFNgȈ
 */
int TJson::objectEnd()
{
	ItemType current;

	// 1ȏ̃L[Fl̑gāA,҂̏ꍇ͌ɖ߂B
	current = previousElement();
	if (current == NEED_SEPARATOR) {
		popElement();
	}

	// Ăl݂̔z񂩂1Oɖ߂B
	popValue();
	currentValue = previousValue();

	// IuWFNg
	popElement();
	if (previousElement() == TJson::KEY) {
		// IuWFNgL[̒l̏ꍇ́AL[IB
		popElement();
		pushElement(TJson::NEED_SEPARATOR);
	} else if (previousElement() == TJson::ARRAY) {
		// IuWFNgz̒l̏ꍇ́Ali[B
		pushElement(TJson::NEED_SEPARATOR);
	}
	return 0;
}

/**
 * lȈ
 *
 * @return 0:l̏ɐ 1:l̏Ɏs
 */
int TJson::valueEnd(TJsonValue::ValueSubType subType)
{
	ItemType current;
	TJsonValue *newValue;	// ǉl

#ifdef TJSON_TRACE
	std::cout << '\n';
	std::cout << "lI";
#endif

	current = previousElement();
	switch(current) {
		case ARRAY:
			// z̒l
			// z̒l̒ǉ
			newValue = currentValue->addArrayValue();
			if (newValue == NULL) {
				return 1;
			}
			newValue->setType(TJsonValue::VALUE);
			newValue->setSubType(subType);
			newValue->setValue(valueBuf);

			// z̒lɂ͋؂肪Kv
			pushElement(TJson::NEED_SEPARATOR);
#ifdef TJSON_TRACE
			std::cout << " ͔zvf";
#endif
			break;
		case OBJECT:
			// IuWFNg̃L[
#ifdef TJSON_TRACE
			std::cout << " ̓IuWFNg̒l";
#endif
			break;
		case KEY:
			// IuWFNg̒l
			popElement();	// ΉL[̏I

			// L[ɑΉl̒ǉ
			newValue = currentValue->addObjectValue(keyBuf);
			if (newValue == NULL) {
				return 1;
			}
			newValue->setType(TJsonValue::VALUE);
			newValue->setSubType(subType);
			newValue->setValue(valueBuf);

			// IuWFNg̒lɂ͋؂肪Kv
			pushElement(TJson::NEED_SEPARATOR);
#ifdef TJSON_TRACE
			std::cout << " ̓IuWFNg̃L[";
#endif
			break;
	}
#ifdef TJSON_TRACE
	std::cout << '\n';
#endif
	return 0;
}

//
// ͕
//

/**
 * JSON̉͂sB
 *
 * @param stat ͏ԕۑ\
 * @param c ǂݍ񂾕
 * @return 0:͐ 1:̓G[
 */
int TJson::parseString(struct TJsonParseStatus *stat,char c)
{
	if (stat->stringEscape) {
		// 1O\o
		if (c == '\"') {
#ifdef TJSON_TRACE
			std::cout << '\\';
			std::cout << c;
#endif
			addValue('\\');
			addValue(c);
		} else {
#ifdef TJSON_TRACE
			std::cout << '\\';
			std::cout << c;
#endif
			addValue('\\');
			addValue(c);
		}
		stat->stringEscape = false;
	} else {
		switch(c) {
			case '\\':
				stat->stringEscape = true;
				break;
			case '\"':
				stat->inString = false;
				stat->stringEscape = false;
				// GXP[vWJ
				strcpy(workBuf,valueBuf);
				extractEscape(valueBuf,TJSON_BUFLEN,workBuf);
				if (valueEnd(TJsonValue::STRING)) {
					return 1;
				}
				break;
			default:
#ifdef TJSON_TRACE
				std::cout << c;
#endif
				addValue(c);
				break;
		}
	}
	return 0;
}

/**
 * JSON̎͂sB
 *
 * @param stat ͏ԕۑ\
 * @param c ǂݍ񂾕
 * @return 0:͐ 1:̓G[
 */
int TJson::parseJSON(struct TJsonParseStatus *stat,char c)
{

	if (stat->inString) {
		parseString(stat,c);
		return 0;
	}

	switch(c) {
		case '\"':	// 
			if (stat->inValue) {
				if (valueEnd(TJsonValue::NUMBER)) {
					return 1;
				}
			}
			stat->inValue = false;

			stat->inString = true;
			resetValue();
			break;
		case '[':	// zJn
			if (stat->inValue) {
				if (valueEnd(TJsonValue::STRING)) {
					return 1;
				}
			}
			stat->inValue = false;

			if (testArrayStart()) {
#ifdef TJSON_TRACE
				std::cout << "zJnłꏊł͂Ȃ" << std::endl;
#endif
				return 1;
			}
			if (onArrayStart()) {
#ifdef TJSON_TRACE
				std::cout << "zJnɎs" << std::endl;
#endif
				return 1;
			}
#ifdef TJSON_TRACE
			std::cout << "zJn" << std::endl;
#endif
			break;
		case ']':	// zI
			if (stat->inValue) {
				if (valueEnd(TJsonValue::NUMBER)) {
					return 1;
				}
			}
			stat->inValue = false;

			arrayEnd();
#ifdef TJSON_TRACE
			std::cout << "zI" << std::endl;
#endif
			break;
		case ',':	// z/IuWFNgvf̋؂
			if (stat->inValue) {
				if (valueEnd(TJsonValue::NUMBER)) {
					return 1;
				}
			}
			stat->inValue = false;

			if (testSeparator()) {
#ifdef TJSON_TRACE
				std::cout << "؂蕶̈ʒu" << std::endl;
#endif
				return 1;
			}
#ifdef TJSON_TRACE
			std::cout << "zvf̋؂" << std::endl;
#endif
			break;
		case '{':	// IuWFNgJn
			if (stat->inValue) {
				if (valueEnd(TJsonValue::NUMBER)) {
					return 1;
				}
			}
			stat->inValue = false;

			if (testObjectStart()) {
#ifdef TJSON_TRACE
				std::cout << "IuWFNgJnłꏊł͂Ȃ" << std::endl;
#endif
				return 1;
			}
			if (onObjectStart()) {
#ifdef TJSON_TRACE
				std::cout << "IuWFNgJnɎs" << std::endl;
#endif
				return 1;
			}
#ifdef TJSON_TRACE
			std::cout << "IuWFNgJn" << std::endl;
#endif
			break;
		case '}':	// IuWFNgI
			if (stat->inValue) {
				if (valueEnd(TJsonValue::NUMBER)) {
					return 1;
				}
			}
			stat->inValue = false;

			objectEnd();
#ifdef TJSON_TRACE
			std::cout << "IuWFNgI" << std::endl;
#endif
			break;
		case ':':	// IuWFNgL[؂
			if (stat->inValue) {
				if (valueEnd(TJsonValue::NUMBER)) {
					return 1;
				}
			}
			stat->inValue = false;

#ifdef TJSON_TRACE
			std::cout << "IuWFNgL[" << std::endl;
#endif
			if (testKey()) {
#ifdef TJSON_TRACE
				std::cout << "IuWFNgL[Jnłꏊł͂Ȃ" << std::endl;
#endif
				return 1;
			}
			if (onKey()) {
#ifdef TJSON_TRACE
				std::cout << "IuWFNgL[ݒɎs" << std::endl;
#endif
				return 1;
			}
			break;
		default:
			if ((c == 0x20) || (c == 0x08) || (c == '\r') || (c == '\n')) {
				// Xy[XA^u͖B
				if (stat->inValue) {
					if (valueEnd(TJsonValue::NUMBER)) {
						return 1;
					}
					if (previousElement() == TJson::KEY) {
						popElement();
					}
				}
				stat->inValue = false;

				if (c == '\n') {
					lineCount++;
				}
				break;
			} else {
				if (!stat->inValue) {
					// ln܂ꍇ̓obt@NAĂB
					resetValue();
				}
				stat->inValue = true;
				addValue(c);
#ifdef TJSON_TRACE
				std::cout << c;
#endif
			}
			break;
	}

	return 0;
}

/**
 * JSONߏԏ
 *
 * @param stat ߏ
 */
void TJson::initParseStatus(struct TJsonParseStatus *stat)
{
	stat->inString = false;
	stat->stringEscape = false;

	resetValue();
}

/**
 * t@Cǂݍݕ
 *
 * @param bmFile t@C
 *
 * @return 0:ǂݍݐ 1:ǂݍݎs
 */
int TJson::readFile(const char *bmFile)
{
	int ret = 0;	// s
	std::ifstream fin;	// ǂݍ݃Xg[
	char c;	// ǂݍ񂾕
	TJsonParseStatus stat;

	initParseStatus(&stat);	// ͏ԂB
	
	if (bmFile == NULL) {
		return 1;
	}
	fin.open(bmFile , std::ios::in | std::ios::binary);
	if (fin.bad()) {
		return 1;
	}
	if (!fin){
		return(1);
	}
	lineCount = 1;

	// t@Cǂݍ݂sB
	while (fin.get(c)){
		ret = parseJSON(&stat,c);	/* HTMLߕɓnB */
		if (ret){
			/* G[炻̎_ŔB */
#ifdef TJSON_TRACE
			std::cout << "\G[ sF" << lineCount << std::endl;
#endif
			break;
		}
	}

	fin.close();

	if (elementPoint == 0) {
#ifdef TJSON_TRACE
		std::cout << "\vf̑Ή֌W͐" << std::endl;
#endif
	} else {
#ifdef TJSON_TRACE
		std::cout << "\vf̑Ή֌Wُ" << std::endl;
		std::cout << "cvf" << elementPoint << std::endl;
#endif
		ret = 1;
	}

	if (valuePoint == 0) {
#ifdef TJSON_TRACE
		std::cout << "l̑Ή֌W͐" << std::endl;
#endif
	} else {
#ifdef TJSON_TRACE
		std::cout << "l̑Ή֌Wُ" << std::endl;
		std::cout << "cl" << valuePoint << std::endl;
#endif
		ret = 1;
	}

	return ret;
}

