#include	<stdio.h>
#include	<windows.h>
#include	"RegistoryProfile.h"

/*
 * RpC@
 * cl -D SELFTEST -GX RegistoryProfile.cpp -link kernel32.lib advapi32.lib
 */

/**
 * WXgɕ񍀖ڂށB<br>
 * (߂l͓APIɍ킹ĂB)
 *
 * @param section ZNV
 * @param entry L[
 * @param value l
 * @param 1:ݐ 0:ݎs
 */
BOOL RegistoryProfile::WriteProfileString(LPCTSTR section,LPCTSTR entry,const char *value) throw (io_exception)
{
	LONG result;
	DWORD bufSize = 4;
	char keyName[_MAX_PATH];

	// WXg̃L[B
	strcpy(keyName,"Software");
	strcat(keyName,"\\");
	strcat(keyName,registoryKey);
	strcat(keyName,"\\");
	strcat(keyName,appName);
	strcat(keyName,"\\");
	strcat(keyName,section);

	result = RegCreateKeyEx(HKEY_CURRENT_USER,keyName,
		0,NULL,REG_OPTION_NON_VOLATILE,
		KEY_WRITE,NULL,&hKey,NULL);
	if (result != ERROR_SUCCESS){
		throw io_exception();
		//return 0;
	}

	result = RegSetValueEx(hKey,entry,0,REG_SZ,(const BYTE *)value,strlen(value) + 1);
	RegCloseKey(hKey);
	if (result == ERROR_SUCCESS){
		return 1;
	}else{
		throw io_exception();
		// return 0;
	}
}

/**
 * INIt@CɐlڂށB<br>
 * (߂l͓APIɍ킹ĂB)
 *
 * @param section ZNV
 * @param entry L[
 * @param value l
 * @param 1:ݐ 0:ݎs
 */
BOOL RegistoryProfile::WriteProfileInt(LPCTSTR section,LPCTSTR entry,int value) throw (io_exception)
{
	LONG result;
	DWORD bufSize = 4;
	char keyName[_MAX_PATH];

	// WXg̃L[B
	strcpy(keyName,"Software");
	strcat(keyName,"\\");
	strcat(keyName,registoryKey);
	strcat(keyName,"\\");
	strcat(keyName,appName);
	strcat(keyName,"\\");
	strcat(keyName,section);

	result = RegCreateKeyEx(HKEY_CURRENT_USER,keyName,
		0,NULL,REG_OPTION_NON_VOLATILE,
		KEY_WRITE,NULL,&hKey,NULL);
	if (result != ERROR_SUCCESS){
		throw io_exception();
		//return 0;
	}

	result = RegSetValueEx(hKey,entry,0,REG_DWORD,(const BYTE *)&value,sizeof(int));
	RegCloseKey(hKey);
	if (result == ERROR_SUCCESS){
		return 1;
	}else{
		throw io_exception();
		//return 0;
	}
}

std::string RegistoryProfile::GetProfileString(LPCTSTR section,LPCTSTR entry,const char *defaultValue)
{
	char buf[_MAX_PATH];
	LONG result;
	DWORD bufSize = _MAX_PATH;
	char keyName[_MAX_PATH];

	// WXg̃L[B
	strcpy(keyName,"Software");
	strcat(keyName,"\\");
	strcat(keyName,registoryKey);
	strcat(keyName,"\\");
	strcat(keyName,appName);
	strcat(keyName,"\\");
	strcat(keyName,section);


	result = RegOpenKeyEx(HKEY_CURRENT_USER,keyName,0,KEY_READ,&hKey);
	if (result != ERROR_SUCCESS){
		return defaultValue;
	}

	result = RegQueryValueEx(hKey,entry,NULL,NULL,(LPBYTE)&buf,&bufSize);
	RegCloseKey(hKey);
	if (result == ERROR_SUCCESS){
		return buf;
	}else{
		return defaultValue;
	}
}

int RegistoryProfile::GetProfileInt(LPCTSTR section,LPCTSTR entry,int defaultValue)
{
	int value;
	LONG result;
	DWORD bufSize = 4;
	char keyName[_MAX_PATH];

	// WXg̃L[B
	strcpy(keyName,"Software");
	strcat(keyName,"\\");
	strcat(keyName,registoryKey);
	strcat(keyName,"\\");
	strcat(keyName,appName);
	strcat(keyName,"\\");
	strcat(keyName,section);

	result = RegOpenKeyEx(HKEY_CURRENT_USER,keyName,0,KEY_READ,&hKey);
	if (result != ERROR_SUCCESS){
		return defaultValue;
	}

	result = RegQueryValueEx(hKey,entry,NULL,NULL,(LPBYTE)&value,&bufSize);
	RegCloseKey(hKey);
	if (result == ERROR_SUCCESS){
		return value;
	}else{
		return defaultValue;
	}
}

#ifdef SELFTEST
int main(int argc,char *argv[])
{
	RegistoryProfile *profile = new RegistoryProfile();
	
	profile->SetRegistryKey("Tatsu_syo");
	profile->SetApplicationName("BookSync2");
	
	profile->WriteProfileInt("Setting","MozillaVersion",2);
	profile->WriteProfileString("Setting","Mozilla","Yes");
	
	profile->SetApplicationName("BookSync");

	std::string moz = profile->GetProfileString("Settings","NS4_bookmark","");
	printf("%s\n",moz.c_str());
	int ver = profile->GetProfileInt("Settings","NS4_do",0);
	printf("%d\n",ver);

	moz = profile->GetProfileString("Setting","NS4_bookmark","");
	printf("%s\n",moz.c_str());
	ver = profile->GetProfileInt("Setting","NS4_do",0);
	printf("%d\n",ver);

	moz = profile->GetProfileString("Settings","NS4_bookmarks","");
	printf("%s\n",moz.c_str());
	ver = profile->GetProfileInt("Settings","NS4_dooo",0);
	printf("%d\n",ver);

	return 0;
}
#endif
