#ifndef NTFUNCTION_H
#define NTFUNCTION_H

#ifdef __cplusplus
extern "C" {
#endif

#include	<windows.h>
#include	<ObjIdl.h>

#ifdef NTFUNCTION_CPP
#define EXTERN
#else
#define EXTERN extern
#endif

typedef HMODULE (WINAPI *PFindFirstFileW)(LPCWSTR,LPWIN32_FIND_DATAW);
typedef BOOL (WINAPI *PFindNextFileW)(HANDLE,LPWIN32_FIND_DATAW);
typedef DWORD (WINAPI *PGetFileAttributesW)(LPCWSTR);
typedef BOOL (WINAPI *PCreateDirectoryW)(LPCWSTR,LPSECURITY_ATTRIBUTES);
typedef BOOL (WINAPI *PWritePrivateProfileStringW)(LPCWSTR,LPCWSTR,LPCWSTR,LPCWSTR);
typedef HANDLE (WINAPI *PCreateFileW)(LPCWSTR,DWORD,DWORD,LPSECURITY_ATTRIBUTES,DWORD,DWORD,HANDLE);
typedef BOOL (WINAPI *PDeleteFileW)(LPCWSTR);
typedef BOOL (WINAPI *PRemoveDirectoryW)(LPCWSTR);
typedef DWORD (WINAPI *PGetPrivateProfileStringW)(LPCWSTR,LPCWSTR,LPCWSTR,LPWSTR,DWORD,LPCWSTR);
typedef LONG (WINAPI *PRegOpenKeyExW)(HKEY,LPCWSTR,DWORD,REGSAM,PHKEY);
typedef LONG (WINAPI *PRegEnumKeyExW)(HKEY,DWORD,LPWSTR,LPDWORD,LPDWORD,LPWSTR,LPDWORD,PFILETIME);
typedef LONG (WINAPI *PRegEnumValueW)(HKEY,DWORD,LPWSTR,LPDWORD,LPDWORD,LPDWORD,LPBYTE,LPDWORD);
typedef LONG (WINAPI *PRegDeleteKeyW)(HKEY,LPCWSTR);
typedef LONG (WINAPI *PRegDeleteValueW)(HKEY,LPCWSTR);
typedef int (WINAPI *PMessageBoxW)(HWND,LPCWSTR,LPCWSTR,UINT);
typedef int (WINAPI *PLoadStringW)(HINSTANCE,UINT,LPWSTR,int);
typedef BOOL (WINAPI *PSetDllDirectoryW)(LPCWSTR);
typedef HRESULT (WINAPI *PSHCreateItemFromParsingName)(PCWSTR,IBindCtx *,REFIID,void **);

/* O[oϐ */
EXTERN HMODULE ghKernel32DLL;
EXTERN HMODULE ghUser32DLL;
EXTERN HMODULE ghShell32DLL;

EXTERN PFindFirstFileW gFindFirstFileW;
EXTERN PFindNextFileW gFindNextFileW;
EXTERN PGetFileAttributesW gGetFileAttributesW;
EXTERN PCreateDirectoryW gCreateDirectoryW;
EXTERN PWritePrivateProfileStringW gWritePrivateProfileStringW;
EXTERN PCreateFileW gCreateFileW;
EXTERN PDeleteFileW gDeleteFileW;
EXTERN PRemoveDirectoryW gRemoveDirectoryW;
EXTERN PGetPrivateProfileStringW gGetPrivateProfileStringW;

EXTERN HMODULE ghAdvapi32DLL;
EXTERN PRegOpenKeyExW gRegOpenKeyExW;
EXTERN PRegEnumKeyExW gRegEnumKeyExW;
EXTERN PRegEnumValueW gRegEnumValueW;
EXTERN PRegDeleteKeyW gRegDeleteKeyW;
EXTERN PRegDeleteValueW gRegDeleteValueW;
EXTERN PMessageBoxW gMessageBoxW;
EXTERN PLoadStringW gLoadStringW;
EXTERN PSetDllDirectoryW gSetDllDirectoryW;
EXTERN PSHCreateItemFromParsingName gSHCreateItemFromParsingName;

EXTERN DWORD gWindowsMajorVersion;	// Windows̃W[o[W
EXTERN bool g_isWinNT;				// true:Windows NTn/false:Windows 9xn

void loadNTfunction(void);
void unloadNTfunction(void);


#ifdef __cplusplus
}
#endif

#undef EXTERN

#endif
