#include	<stdio.h>
#include	<time.h>
#include	<windows.h>

#include	"bslib.h"
#include	"Logger.h"

Logger::Logger()
{
	m_level = NONE;
}

int Logger::start()
{
	char buf[MAX_PATH];

	if (m_level == NONE) {
		return 0;
	}

	// Application DatazɃtH_B
	GetAppDataDir(buf);
	strcat(buf,"\\");
	strcat(buf,"BookSyncLog.log");

	fpo = fopen(buf,"w");
	if (fpo == NULL) {
		return 1;
	}
	return 0;
}

int Logger::stop()
{
	if (m_level == NONE) {
		return 0;
	}

	if (fpo == NULL) {
		return 0;
	}
	return fclose(fpo);
}

void Logger::putTime(void)
{
	time_t now;
	struct tm *timeElement;
	
	now = time(NULL);
	timeElement = localtime(&now);
	
	fprintf(fpo,"%04d/%02d/%02d %02d:%02d:%02d ",
		timeElement->tm_year + 1900,
		timeElement->tm_mon + 1,
		timeElement->tm_mday,
		timeElement->tm_hour,
		timeElement->tm_min,
		timeElement->tm_sec);
}

void Logger::trace(const char *message)
{
	if (m_level == TRACE) {
		putTime();
		fprintf(fpo,"[TRACE] %s\n",message);
		fflush(fpo);
	}
}

void Logger::debug(const char *message)
{
	if (m_level != NONE){
		putTime();
		fprintf(fpo,"[DEBUG] %s\n",message);
		fflush(fpo);
	}
}

