#include	"IniProfile.h"

#include	<stdio.h>

/*
 * RpC@
 * cl -D SELFTEST -GX IniProfile.cpp -link kernel32.lib
 */

/**
 * INIt@Cɕ񍀖ڂށB
 *
 * @param section ZNV
 * @param entry L[
 * @param value l
 * @param 0:ݐ 0:ݎs
 */
BOOL IniProfile::WriteProfileString(LPCTSTR section,LPCTSTR entry,const char *value) throw (io_exception)
{
	BOOL result;

	if (strcmp(value, " ") == 0) {
		result = WritePrivateProfileString(section,entry,SPACE_ALTERNATIVE_STRING,iniFile);
	} else {
		result = WritePrivateProfileString(section,entry,value,iniFile);
	}
	if (!result) {
		throw io_exception();
	}
	return result;
}

/**
 * INIt@CɐlڂށB
 *
 * @param section ZNV
 * @param entry L[
 * @param value l
 * @param 0:ݐ 0:ݎs
 */
BOOL IniProfile::WriteProfileInt(LPCTSTR section,LPCTSTR entry,int value) throw (io_exception)
{
	char buf[20];
	BOOL result;
	
	sprintf(buf,"%d",value);
	
	result = WritePrivateProfileString(section,entry,buf,iniFile);

	if (!result) {
		throw io_exception();
	}
	return result;
}

std::string IniProfile::GetProfileString(LPCTSTR section,LPCTSTR entry,const char *defaultValue)
{
	char buf[_MAX_PATH];

	GetPrivateProfileString(section,entry,defaultValue,buf,_MAX_PATH,iniFile);
	if (strcmp(buf, SPACE_ALTERNATIVE_STRING) == 0) {
		return " ";
	} else {
		return buf;
	}
}

int IniProfile::GetProfileInt(LPCTSTR section,LPCTSTR entry,int defaultValue)
{
	return GetPrivateProfileInt(section,entry,defaultValue,iniFile);
}

#ifdef SELFTEST
#define INIFILE "h:\\test\\hoge.ini"

int main(int argc,char *argv[])
{
	IniProfile *profile = new IniProfile();

	profile->setIniFile(INIFILE);

	profile->WriteProfileString("Setting","Mozilla","Yes");
	profile->WriteProfileInt("Setting","MozillaVersion",2);
	
	std::string moz = profile->GetProfileString("Setting","Mozilla","");
	printf("%s\n",moz.c_str());
	int ver = profile->GetProfileInt("Setting","MozillaVersion",0);
	printf("%d\n",ver);
	
	return 0;
}
#endif
