#include	<stdio.h>
#include	<stdlib.h>
#include	<string.h>
#include	<ctype.h>
#include	"HTMLtag.h"

#ifdef __BORLANDC__
#define	_stricmp stricmp
#endif

//HTML̑i[镔
// HTMLattr\̂𐶐B
struct HTMLattr *newAttr(struct HTMLattr *base,char *name,char *value)
{
	struct HTMLattr *newAttr;

	newAttr = NULL;
	//printf("%s %s\n",name,value);
	try{
		newAttr = new struct HTMLattr;
		if (newAttr == NULL){
			return(NULL);
		}
		newAttr->parent = base;

		// \̂̏
		newAttr->left = NULL;
		newAttr->right = NULL;
		newAttr->Name = NULL;
		newAttr->Value = NULL;

		// ȂႻ̂܂NULL
		newAttr->Name = new char[strlen(name)+1];
		if (newAttr->Name != NULL){
			strcpy(newAttr->Name,name);
			newAttr->Value = new char[strlen(value)+1];
			if (newAttr->Value != NULL){
				strcpy(newAttr->Value,value);
			}
		}
	}catch(...){
		//printf("O\n");
		if (newAttr == NULL){
			return(NULL);
		}
	}
	return(newAttr);
}

// HTMLattr\̂𐶐ĕt
struct HTMLattr *addAttr(struct HTMLattr *base,char *name,char *value)
{
	struct HTMLattr *newattr;
	struct HTMLattr *p;
	int pos;
	
	p = base;
	if (p == NULL){
		return NULL;
	}
	//printf("\ni[Jn\n");
	while(1){
		//printf(":%s\n",p->Name);
		if (p->Name == NULL){
			return(NULL);
		}
		pos = _stricmp(name,p->Name);	// ^[QbgHTMLƂȂ獡̂Ƃ͑͑啶̋ʂȂقÓA͋ʂ̂?
		//printf("񕪌:%d\n",pos);
		if (!pos){	// łɑ݂瑮lXV
			delete [] p->Value;
			try{
				p->Value = new char[strlen(value)+1];
				if (p->Value != NULL){
					strcpy(p->Value,value);
				}
			}catch(...){	// ȂƂɗOԂ̂HP-UXaC++ƂȂB
				p->Value = NULL;
			}
			newattr = p;	// ǂnewƂ˂݂͋pB
			break;
		}
		if (pos > 0){	// őO
			if (p->left == NULL){
				newattr = newAttr(p,name,value);
				if (newattr == NULL){
					return(NULL);
				}else{
					p->left = newattr;
				}
				break;
			}else{
				p = p->left;
			}
		}else{
			if (p->right == NULL){
				newattr = newAttr(p,name,value);
				if (newattr == NULL){
					return(NULL);
				}else{
					p->right = newattr;
				}
				break;
			}else{
				p = p->right;
			}
		}
	}
	return(newattr);
}

void deleteAttr(struct HTMLattr *base)
{
	if (base == NULL){
		return;
	}
	
	/* ċAĂяoɗςȂBX^bNłȂƂ */
	if (base->left != NULL){
		deleteAttr(base->left);
	}
	if (base->right != NULL){
		deleteAttr(base->right);
	}
	if (base->Name != NULL){
		delete [] base->Name;
	}
	if (base->Value != NULL){
		delete [] base->Value;
	}
	delete base;
}

// HTML̃^O͕
void HTMLtag::pushBuf(char c)
{
	if (pbufCount < (BUFLEN-1)){
		*pparsebuf = c;
		pparsebuf++;
		pbufCount++;
	}
}

// ̔
int HTMLtag::ParseValue(char c)
{
	if (inCopy){
		if (c == valueDelim){	// 瑮l
			return(2);
		}
		if ((valueDelim == ' ') && (c == '>')){
			return(1);
		}
	}else{
		if (isspace(c)){	// skip character
			return(4);
		}else{
			inCopy = 1;
			if ((c == '\"') || (c == '\'')){	// ؂蕶Œln܂B
				valueDelim = c;
				return(3);
			}else{
				valueDelim = ' ';
			}
		}
	}
	return(0);
}

// 킩ȂƂ
int HTMLtag::ParseUnknown(char c)
{
	if (isspace(c)){
		return(2);
	}else{
		if (c == '>'){		// Tag end
			return(1);
		}
		if (c == '/'){		// This tag is End tag(XHTML style)
			isEnd = 1;
			return(2);
		}
		if (c == '='){		// 瑮l
			return(3);
		}else{				// 瑮
			inCopy = 1;
			pushBuf(c);
			return(4);
		}
	}
}

// ̔
int HTMLtag::ParseAttrName(char c)
{
	if (inCopy){
		if (c == '='){	// 瑮l
			return(2);
		}
		if (isspace(c)){	// Name end
			return(3);
		}
		if (c == '/'){		// Name end and this tag is End tag(XHTML style)
			isEnd = 1;
			isEmpty = 1;	// vfƎv
			return(3);
		}
		if (c == '>'){		// Tag end
			return(1);
		}
	}else{
		if (isspace(c)){	// skip character
			return(4);
		}
		if (c == '/'){		// This tag is end tag(XHTML style)
			isEnd = 1;
			isEmpty = 1;	// vfƎv
			return(4);
		}
		if (c == '>'){
			return(1);
		}else{
			inCopy = 1;
		}
	}
	return(0);
}

// ^ȌI肩ǂʂB
int HTMLtag::ParseName(char c)
{
	if (inCopy){
		if (isspace(c)){	// Name end(next is value)
			return(3);
		}
		if (c == '/'){		// Name end and this tag is end tag (next is value)
			isEnd = 1;
			isEmpty = 1;	// vfƎv
			return(3);
		}
		if (c == '='){		// Error?
			return(2);
		}
		if (c == '>'){		// Tag end(Ȃ)
			return(1);
		}
	}else{
		if (isspace(c)){	// skip character
			return(4);
		}
		if (c == '/'){
			isEnd = 1;	// I^O(OɗvfƂ̂̂ŁAvfł͂ȂB)
			isEmpty = 0;
			return(4);
		}else{
			inCopy = 1;
		}
	}
	return(0);
}

int HTMLtag::doParse(char c)
{
	int result;
	
	if (isComment){	// RgI؂q͌ĂяoŃ`FbNāǍ̃}[NAbvI
		if (c == '>'){
			complete = 1;
			return(1);
		}
		return(0);
	}
	
	switch (mode){
		case 0:
			result = ParseName(c);
		break;
		case 1:	// attribute name
			result = ParseAttrName(c);
		break;
		case 2:	// unknown
			result = ParseUnknown(c);
		break;
		case 3:	// attribute value
			result = ParseValue(c);
		break;
	}
	if (result){
		switch (mode){
			case 0:	// Gg
				if (result < 4){
					*pparsebuf = '\0';
					pparsebuf = parsebuf;
					pbufCount = 0;
					inCopy = 0;
					mode = 1;	// ͑
					//printf("Element name : %s\n",parsebuf);
					try{
						name = new char[strlen(parsebuf)+1];
						if (name == NULL){
							//printf("No enough memory.\n");
							return(3);
						}
						strcpy(name,parsebuf);
					}catch(...){
						return(3);
					}

					if (!strncmp(parsebuf,"!--",3)){	// Comment? }[Nt錾Jn؂q! + RgJn؂q -- ͂ĂȂƂȂ̂łŃ`FbNĂ悢
						isComment = 1;
						return(2);
					}
				}
			break;
			case 1:	// attribute name
				if (result < 4){
					*pparsebuf = '\0';
					pparsebuf = parsebuf;
					pbufCount = 0;
					inCopy = 0;
					// ő̃Rs[ƒl̏B
					if (attr == NULL){
						attr = newAttr(NULL,parsebuf,parsebuf);
						prevValue = attr;
					}else{
						prevValue = addAttr(attr,parsebuf,parsebuf);
					}
					//printf("\nAttribute name : %s\n",parsebuf);
				}
				if (result == 2){	// = 玟͑l
					mode = 3;
					valueDelim = ' ';
				}else{
					mode = 2;
				}
			break;
			case 2:	// unknown
				if (result != 2){
					if (result == 3){
						mode = 3;
						valueDelim = ' ';
					}else{
						mode = 1;
					}
				}
			break;
			case 3:	// attribute value
				if (result < 3){	// l̏I
					*pparsebuf = '\0';
					pparsebuf = parsebuf;
					pbufCount = 0;
					inCopy = 0;
					// ő̃Rs[ƒl̏B
					if (attr == NULL){
						if (prevValue != NULL && prevValue->Name != NULL){
							attr = newAttr(NULL,prevValue->Name,parsebuf);
						}else{
							attr = newAttr(NULL,parsebuf,parsebuf);
						}
					}else{
						if (prevValue != NULL && prevValue->Name != NULL){
							addAttr(attr,prevValue->Name,parsebuf);
						}else{
							addAttr(attr,parsebuf,parsebuf);
						}
					}
					//printf("Attribute value : %s\n",parsebuf);
					mode = 1;
				}
			break;
		}
	}else{
		pushBuf(c);
	}
	if (result == 1){	// Tag end
		complete = 1;
		return(1);
	}else{
		return(0);
	}
}

void HTMLtag::initialize(void)
{
	mode = 0;	// Name parsing mode
	inCopy = 0;
	pparsebuf = parsebuf;
	pbufCount = 0;
	complete = 0;
	isComment = 0;

	name = NULL;
	attr = NULL;
	prevValue = NULL;
	isEnd = 0;
	isEmpty = 0;
}

// RXgN^ƃfXgN^
HTMLtag::HTMLtag(void)
{
	initialize();
}

HTMLtag::HTMLtag(const char *tag)
{
	initialize();

	if (*tag == '<')
		tag++;

	// ^Ỏ
	if (*tag == '/'){
		isEnd = 1;
		tag++;
	}
	while (*tag){
		doParse(*tag);
		tag++;
	}

}

HTMLtag::~HTMLtag()
{
	if (name != NULL){
		delete [] name;
		name = NULL;
	}
	if (attr != NULL){
		deleteAttr(attr);
	}
	complete = 0;
}

void HTMLtag::init(void)
{
	if (name != NULL){
		delete [] name;
		name = NULL;
	}
	if (attr != NULL){
		deleteAttr(attr);
	}
	initialize();
}

// nameŎw肳ꂽ̒lԂB
char *HTMLtag::getAttrValue(const char *name)
{
	struct HTMLattr *p;
	int pos;
	
	p = attr;

	while(1){
		if (p == NULL){		// l݂Ȃ
			return(NULL);
		}
		if (p->Name == NULL){
			return(NULL);
		}
		pos = _stricmp(name,p->Name);	// ^[QbgHTMLƂȂ獡̂Ƃ͑͑啶̋ʂȂقÓA͋ʂ̂?
		if (!pos){
			//printf("Match!\n");
			return p->Value;
		}
		if (pos > 0){
			p = p->left;
		}else{
			p = p->right;
		}
	}

}

// ^OԂ
char *HTMLtag::getName(void)
{
	if (complete){
		return(name);
	}else{
		return(NULL);
	}
}

// I^Oǂ?
int HTMLtag::isEndtag(void)
{
	return(isEnd);
}
