#ifndef __BOOKMARKTREE_H
#define __BOOKMARKTREE_H

#include	<vector>
#include	<list>
#include	"booklist.h"

#include	"IbookmarkWriter.h"
#include	"IbookmarkTree.h"

class BookmarkTree : public IbookmarkTree {

	BOOKLIST m_topList;			// ŏʃtH_ۑpXg
	BOOKLIST *m_currentList;	// ݂̃tH_ɑΉ郊Xgւ̃|C^
	BOOKLIST *m_parentList;		// ݂̃tH_ɑΉ郊Xg̐eXg
	BOOKLIST::iterator currentItem;	// GetItemŌXg̗vfւ̃Ce[^

	BOOKLIST *m_menuList;		// ubN}[Nj[̃Xg
	BOOKLIST *m_toolbarList;	// ubN}[Nc[o[̃Xg
	BOOKLIST *m_tagsList;		// ^ÕXg
	BOOKLIST *m_unfiledList;		// t@CĂȂubN}[ÑXg

	char g_toolbar[2048];	// c[o[tH_
	int m_level;			// tH_Kwx
	int m_verbose;		// ڍו\tO
	IBookmarkWriter *writer;
	std::vector<int> order;	// eKw̃tH_ɂ鏇
	int browser;		// Cɓi[EoΏۂ̃uEU
						// 0:IE 1,2 Mozilla 3,4 Opera
	bool mainBrowser;	// ҏWΏۃuEȔꍇ̂true
	IbookmarkTree *targetTree;
	bool op29SpeedDialPut;

	void putWithoutToolbar(BOOKLIST *list);
	void putToolBar();
	void putWithoutToolMenu();

public:
	// RXgN^
	BookmarkTree(void);

	// ԂgΎwn֐
	int storeItem(wchar_t *path,Bookmark *bookmark);
	int storeItemWithRefer(wchar_t *path,Bookmark *bookmark);
	int storeItem(Bookmark *bookmark);
	int storeItemWithRefer(Bookmark *bookmark);
	int replaceItem(Bookmark *bookmark);

	Bookmark *getBookmark(wchar_t *path,bool folderFlag);
	Bookmark *findBookmark(wchar_t *path,bool folderFlag);
	void upFolder(void);
	void upToTop(void);
	void upToBookmarkMenu(void);
	void upToToolbar(void);

	void downFolder(void);
	int setBrowser(int no){
		browser = no;
		return no;
	}

	// pXgΎwn֐
	int storeItemByPath(wchar_t *path,Bookmark *bookmark);
	Bookmark *getBookmarkByPath(wchar_t *key,bool folderFlag);	// ubN}[N̓e擾BRTTIŌ^𔻕ʂ̂̓ZtT[rXłB
	BOOKLIST *getBookmarkFolderByPath(const wchar_t *key,Bookmark::FolderType type);	// ubN}[N̓e擾BRTTIŌ^𔻕ʂ̂̓ZtT[rXłB
	Bookmark *getFolderByAttribute(Bookmark::FolderType type);
	bool unreferBookmarkFolderByPath(wchar_t *path,Bookmark::FolderType type);

	bm_listitem *getFolderNodeByAttribute(Bookmark::FolderType type);


	void setTopRefer();
	void setMenuRefer();
	void setTopReferWithoutBar();
	void setUnfiledRefer();
	void setTagsRefer();
	void setReferAll(BOOKLIST *list, bool recursive);
	Bookmark *moveFolder(const wchar_t *path, bool folderFlag);

	void storeList(BOOKLIST *list);
	BOOKLIST::iterator getCurrentItem(void) {
		return currentItem;
	}

	// So͊֐
	int putAll(void);
	int storeAll(void);
	int putWithOriginalToolbar(BookmarkTree *originalTree);

	void putList(BOOKLIST *list);

	// ubN}[NoIuWFNg̐ݒ
	void setWriter(IBookmarkWriter *newWriter) { writer = newWriter; };
	// ubN}[Ni[IuWFNg̐ݒ
	void setTree(IbookmarkTree *newTree) { targetTree = newTree; };
	// ҏWΏۃuEU̐ݒ
	void setMainBrowser(bool flag){
		mainBrowser = flag;
	}
	bool getMainBrowser(void) {
		return mainBrowser;
	}

	void setOp29SpeedDialPut(bool value) {
		op29SpeedDialPut = value;
	}
};

#endif
