#pragma warning( disable : 4786)

//#if defined(_DEBUG) && defined(_MSC_VER)
//#define _CRTDBG_MAP_ALLOC
//#endif

#include	<stdlib.h>
#include	<new>
#include	<memory>

//#if defined(_DEBUG) && defined(_MSC_VER)
//#include	<crtdbg.h>
//#define new  ::new(_NORMAL_BLOCK, __FILE__, __LINE__)
//#endif

#include	<stdio.h>
#include	<time.h>

#include	"Bookmark.h"
#include	"BookmarkTree.h"
#include	"encutil.h"
#include	"url.h"

#ifdef _DEBUG
#define debugprintf printf
#else
#define debugprintf
#endif

BookmarkTree::BookmarkTree(void)
{
	m_verbose = 0;			// ڍו\tO
	m_level = 0;			// tH_Kwx

	m_menuList = NULL;		// ubN}[Nj[̃Xg
	m_toolbarList = NULL;	// ubN}[Nc[o[̃Xg
	m_tagsList = NULL;		// ^ÕXg
	m_unfiledList = NULL;		// t@CĂȂubN}[ÑXg

	m_parentList = NULL;
	m_currentList = &m_topList;
	order.push_back(0);
	browser = BOOKMARK_IE;
	mainBrowser = false;

	op29SpeedDialPut = false;
}

/**
 * ݒڂĂubN}[NXg̈̊Kw̃ubN}[NXg<br>
 * ڂĂubN}[NXgɂB
 *
 */
void BookmarkTree::upFolder(void)
{
	BOOKLIST::iterator item;
	BOOKLIST *parent;

	if (m_parentList == NULL){
		return;
	}

	m_currentList = m_parentList;
	item = m_currentList->begin();
	parent = item->getParent();
	m_parentList = parent;
	m_level--;
}

/**
 * ԏ̊Kw̃ubN}[NXg<br>
 * ڂĂubN}[NXgɂB
 *
 */
void BookmarkTree::upToTop(void)
{
	m_parentList = NULL;
	m_currentList = &m_topList;
	order[0] = 0;
	m_level = 0;
}

/**
 * ubN}[Nj[̃ubN}[NXg<br>
 * ڂĂubN}[NXgɂB
 *
 */
void BookmarkTree::upToBookmarkMenu(void)
{
	m_parentList = NULL;
	m_currentList = m_menuList;	// ubN}[Nj[̃Xgɐݒ肷B
	order[1] = 0;
	m_level = 1;

	if ((int)order.size() <= m_level){
		order.push_back(0);
	}else{
		order[m_level] = 0;
	}
}

/**
 * c[o[̃ubN}[NXg<br>
 * ڂĂubN}[NXgɂB
 *
 */
void BookmarkTree::upToToolbar(void)
{
	m_parentList = NULL;
	m_currentList = m_toolbarList;	// ubN}[Nj[̃Xgɐݒ肷B
	order[1] = 0;
	m_level = 1;

	if ((int)order.size() <= m_level){
		order.push_back(0);
	}else{
		order[m_level] = 0;
	}
}

/**
 * ubN}[NBOOKLISTɊi[B
 *
 * @param path pXւ̃|C^
 * @param bookmark ubN}[Ni[\̂ւ̃pX(Rs[ς݂ł邱)
 * @return 0 i[ 1 i[s
 */
int BookmarkTree::storeItem(wchar_t *path,Bookmark *bookmark)
{
	bm_listitem newItem;
	BOOKLIST::iterator item;
	BOOKLIST *newList;

	//printf("%s\n\n",path);
	
	m_currentList->push_back(newItem);
	item = m_currentList->end();
	item--;
	item->setBookmark(bookmark);
	item->setPath(path);
	if (mainBrowser){	// ҏWΏۃuEÛƂ̂ݎQƃJEg𑝂₷B
		item->addRefer();	// QƃJEg1₷
	}
	if (m_parentList != NULL){
		// e̐ݒ
		item->setParent(m_parentList);
	}
	if ((browser != BOOKMARK_IE) && (browser != BOOKMARK_EDGE)) {	// IE/Edge͏oł͂ȂAg̏ԏKpB
		bookmark->setOrgOrder(browser,order[m_level]);
	}
	order[m_level]++;

	// tH_̏ꍇ̓TutH_pXgȂB
	if (bookmark->getItemType() == Bookmark::folder){
		try{
			newList = new BOOKLIST;
			if (newList == NULL){
				return 1;
			}
		}catch(...){
			return 1;
		}
		
		item->setChild(newList);
		m_parentList = m_currentList;
		m_currentList = newList;
		// IWiubN}[N̏ԂB
		m_level++;
		if ((int)order.size() <= m_level){
			order.push_back(0);
		}else{
			order[m_level] = 0;
		}
		switch(bookmark->getFolderType()) {
			case Bookmark::menuBar:
				m_menuList = newList;
				break;
			case Bookmark::toolBar:
				m_toolbarList = newList;
				break;
			case Bookmark::tags:
				m_tagsList = newList;
				break;
			case Bookmark::unFiled:
				m_unfiledList = newList;
				break;
			case Bookmark::topFolder:
				break;
			case Bookmark::normalFolder:
				break;
		}
	}
	
	return 0;
}

/**
 * ubN}[NBOOKLISTɊi[B(QƃJEgKݒ肷)
 *
 * @param path pXւ̃|C^
 * @param bookmark ubN}[Ni[\̂ւ̃pX(Rs[ς݂ł邱)
 * @return 0 i[ 1 i[s
 */
int BookmarkTree::storeItemWithRefer(wchar_t *path,Bookmark *bookmark)
{
	bm_listitem newItem;
	BOOKLIST::iterator item;
	BOOKLIST *newList;

	//printf("%s\n\n",path);
	
	m_currentList->push_back(newItem);
	item = m_currentList->end();
	item--;
	item->setBookmark(bookmark);
	item->setPath(path);
	item->addRefer();	// QƃJEg1₷
	if (m_parentList != NULL){
		// e̐ݒ
		item->setParent(m_parentList);
	}
	if ((browser != BOOKMARK_IE) && (browser != BOOKMARK_EDGE)) {	// IE/Edge͏oł͂ȂAg̏ԏKpB
		bookmark->setOrgOrder(browser,order[m_level]);
	}
	order[m_level]++;

	// tH_̏ꍇ̓TutH_pXgȂB
	if (bookmark->getItemType() == Bookmark::folder){
		try{
			newList = new BOOKLIST;
			if (newList == NULL){
				return 1;
			}
		}catch(...){
			return 1;
		}
		
		item->setChild(newList);
		m_parentList = m_currentList;
		m_currentList = newList;

		// IWiubN}[N̏ԂB
		m_level++;
		if ((int)order.size() <= m_level){
			order.push_back(0);
		}else{
			order[m_level] = 0;
		}
	}
	
	return 0;
}

/**
 * ubN}[NBOOKLISTɊi[B
 *
 * @param bookmark ubN}[Ni[\̂ւ̃pX(Rs[ς݂ł邱)
 * @return 0 i[ 1 i[s
 */
int BookmarkTree::storeItem(Bookmark *bookmark)
{
	bm_listitem newItem;
	BOOKLIST::iterator item;
	BOOKLIST *newList;

	//printf("%s\n\n",path);
	Bookmark *bm;

	try{
		bm = new Bookmark(*bookmark);
		if (bm == NULL){
			return 1;
		}
	}catch(...){
		return 1;
	}
	
	m_currentList->push_back(newItem);
	item = m_currentList->end();
	item--;
	item->setBookmark(bm);
	// item->setPath(path);
	if (mainBrowser){	// ҏWΏۃuEÛƂ̂ݎQƃJEg𑝂₷B
		item->addRefer();	// QƃJEg1₷
	}
	if (m_parentList != NULL){
		// e̐ݒ
		item->setParent(m_parentList);
	}
	if ((browser != BOOKMARK_IE) && (browser != BOOKMARK_EDGE)) {	// IE/Edge͏oł͂ȂAg̏ԏKpB
		bookmark->setOrgOrder(browser,order[m_level]);
	}
	order[m_level]++;

	// tH_̏ꍇ̓TutH_pXgȂB
	if (bookmark->getItemType() == Bookmark::folder){
		try{
			newList = new BOOKLIST;
			if (newList == NULL){
				return 1;
			}
		}catch(...){
			return 1;
		}
		
		item->setChild(newList);
		m_parentList = m_currentList;
		m_currentList = newList;
		// IWiubN}[N̏ԂB
		m_level++;
		if ((int)order.size() <= m_level){
			order.push_back(0);
		}else{
			order[m_level] = 0;
		}
		switch(bookmark->getFolderType()) {
			case Bookmark::menuBar:
				m_menuList = newList;
				break;
			case Bookmark::toolBar:
				m_toolbarList = newList;
				break;
			case Bookmark::tags:
				m_tagsList = newList;
				break;
			case Bookmark::unFiled:
				m_unfiledList = newList;
				break;
			case Bookmark::topFolder:
				break;
			case Bookmark::normalFolder:
				break;
		}
	}
	
	return 0;
}

/**
 * ubN}[NBOOKLISTɊi[B
 *
 * @param bookmark ubN}[Ni[\̂ւ̃pX(Rs[ς݂ł邱)
 * @return 0 i[ 1 i[s
 */
int BookmarkTree::storeItemWithRefer(Bookmark *bookmark)
{
	bm_listitem newItem;
	BOOKLIST::iterator item;
	BOOKLIST *newList;

	//printf("%s\n\n",path);
	Bookmark *bm;

	try{
		bm = new Bookmark(*bookmark);
		if (bm == NULL){
			return 1;
		}
	}catch(...){
		return 1;
	}
	
	m_currentList->push_back(newItem);
	item = m_currentList->end();
	item--;
	item->setBookmark(bm);
	item->addRefer();	// QƃJEg1₷

	if (m_parentList != NULL){
		// e̐ݒ
		item->setParent(m_parentList);
	}
	if ((browser != BOOKMARK_IE) && (browser != BOOKMARK_EDGE)) {	// IE/Edge͏oł͂ȂAg̏ԏKpB
		bookmark->setOrgOrder(browser,order[m_level]);
	}
	order[m_level]++;

	// tH_̏ꍇ̓TutH_pXgȂB
	if (bookmark->getItemType() == Bookmark::folder){
		try{
			newList = new BOOKLIST;
			if (newList == NULL){
				return 1;
			}
		}catch(...){
			return 1;
		}
		
		item->setChild(newList);
		m_parentList = m_currentList;
		m_currentList = newList;
		// IWiubN}[N̏ԂB
		m_level++;
		if ((int)order.size() <= m_level){
			order.push_back(0);
		}else{
			order[m_level] = 0;
		}
		switch(bookmark->getFolderType()) {
			case Bookmark::menuBar:
				m_menuList = newList;
				break;
			case Bookmark::toolBar:
				m_toolbarList = newList;
				break;
			case Bookmark::tags:
				m_tagsList = newList;
				break;
			case Bookmark::unFiled:
				m_unfiledList = newList;
				break;
			case Bookmark::topFolder:
				break;
			case Bookmark::normalFolder:
				break;
		}
	}
	
	return 0;
}

/**
 * ݂BOOKLIST̍Ō̃ubN}[Nw肵ubN}[N
 * uB
 *
 * @param bookmark ubN}[Ni[\̂ւ̃pX(Rs[ς݂ł邱)
 * @return 0 i[ 1 i[s
 */
int BookmarkTree::replaceItem(Bookmark *bookmark)
{
	bm_listitem newItem;
	BOOKLIST::iterator item;
	BOOKLIST *childList;

	//printf("%s\n\n",path);
	
	// m_currentList->push_back(newItem);
	item = m_currentList->end();
	item--;
	Bookmark *exist = item->getBookmark();
	if (exist != NULL) {
		delete exist;
	}
	item->setBookmark(bookmark);
	// item->setPath(path);
	//if (mainBrowser){	// ҏWΏۃuEÛƂ̂ݎQƃJEg𑝂₷B
	//	item->addRefer();	// QƃJEg1₷
	//}
	if (m_parentList != NULL){
		// e̐ݒ
		item->setParent(m_parentList);
	}
	//bookmark->setOrgOrder(browser,order[m_level]);
	//order[m_level]++;

	// tH_̏ꍇ̓TutH_pXgȂB
	if (bookmark->getItemType() == Bookmark::folder){
		childList = item->getChild();
		if (childList != NULL) {
			// tH_ꍇɂ̐ݒsB
			switch(bookmark->getFolderType()) {
				case Bookmark::menuBar:
					m_menuList = childList;
					break;
				case Bookmark::toolBar:
					m_toolbarList = childList;
					break;
				case Bookmark::tags:
					m_tagsList = childList;
					break;
				case Bookmark::unFiled:
					m_unfiledList = childList;
					break;
				case Bookmark::topFolder:
					break;
				case Bookmark::normalFolder:
					break;
			}
		}
	}
	
	return 0;
}

/**
 *	pathŎubN}[NubN}[NXg擾B
 *
 * @param path ACe
 * @param folderFlag true:tH_ false:tH_
 * @return NULL ubN}[N̏ւ̃|C^<br>
 *         NULL pXŎubN}[N݂͑ȂB
 */
Bookmark *BookmarkTree::getBookmark(wchar_t *path,bool folderFlag)
{
	BOOKLIST *current;
	wchar_t *p,*name;	// Ώۂ̃ACeƃXgoACe
	Bookmark *bm;	// XgoubN}[Ñ|C^

	current = m_currentList;
	p = path;

	if (path == NULL){
		return NULL;
	}

	if (current == NULL){
		return NULL;
	}
	// Xg̗vf`FbNĂB
	currentItem = current->begin();
	for	( ; currentItem != current->end() ; ++currentItem ){
		bm = currentItem->getBookmark();
		if (bm == NULL){	// ĂȂꍇ͖B
			continue;
		}
		name = bm->getIeNameW();
		if (name == NULL){
			continue;
		}
		if (!wcscmp(name,p)){
			// O̓ACe̎ނǂׂB
			if (folderFlag){
				// tH_̏ꍇ
				if (bm->getItemType() == Bookmark::folder){
					if (mainBrowser){	// ҏWΏۃuEÛƂ̂ݎQƃJEg𑝂₷B
						currentItem->addRefer();	// QƃJEg1₷
					}
					if ((browser != BOOKMARK_IE) && (browser != BOOKMARK_EDGE)) {	// IE/Edge͏oł͂ȂAg̏ԏKpB
						bm->setOrgOrder(browser,order[m_level]);	// Ԃݒ肷B
					}
					order[m_level]++;
					debugprintf("folder\n");
					return bm;
				}
			}else{
				// tH_łȂꍇ
				if (bm->getItemType() == Bookmark::bookmark){
					if (mainBrowser){	// ҏWΏۃuEÛƂ̂ݎQƃJEg𑝂₷B
						currentItem->addRefer();	// QƃJEg1₷
					}
					if ((browser != BOOKMARK_IE) && (browser != BOOKMARK_EDGE)) {	// IE/Edge͏oł͂ȂAg̏ԏKpB
						bm->setOrgOrder(browser,order[m_level]);	// Ԃݒ肷B
					}
					order[m_level]++;
					debugprintf("bookmark\n");
					return bm;
				}
			}
		}
	}
	// ړĂ̂̂Ȃꍇ݂̂ɂB
	return NULL;

}

/**
 * pathŎubN}[NubN}[NXg擾B<br>
 * (AubN}[N̕яQƐɉe^ȂB)
 *
 * @param path ACe
 * @param folderFlag true:tH_ false:tH_
 * @return NULL ubN}[N̏ւ̃|C^<br>
 *         NULL pXŎubN}[N݂͑ȂB
 */
Bookmark *BookmarkTree::findBookmark(wchar_t *path,bool folderFlag)
{
	BOOKLIST *current;
	wchar_t *p,*name;	// Ώۂ̃ACeƃXgoACe
	Bookmark *bm;	// XgoubN}[Ñ|C^

	current = m_currentList;
	p = path;

	if (path == NULL){
		return NULL;
	}

	if (current == NULL){
		return NULL;
	}
	// Xg̗vf`FbNĂB
	currentItem = current->begin();
	for	( ; currentItem != current->end() ; ++currentItem ){
		bm = currentItem->getBookmark();
		if (bm == NULL){	// ĂȂꍇ͖B
			continue;
		}
		name = bm->getIeNameW();
		if (name == NULL){
			continue;
		}
		if (!wcscmp(name,p)){
			// O̓ACe̎ނǂׂB
			if (folderFlag){
				// tH_̏ꍇ
				if (bm->getItemType() == Bookmark::folder){
					debugprintf("folder\n");
					return bm;
				}
			}else{
				// tH_łȂꍇ
				if (bm->getItemType() == Bookmark::bookmark){
					debugprintf("bookmark\n");
					return bm;
				}
			}
		}
	}
	// ړĂ̂̂Ȃꍇ݂̂ɂB
	return NULL;

}

/**
 * typeŎނ̃ubN}[NubN}[NXg擾B
 *
 * @param type ACe̎
 * @return NULL ubN}[N̏ւ̃|C^<br>
 *         NULL w肵ނ̃ubN}[N݂͑ȂB
 */
Bookmark *BookmarkTree::getFolderByAttribute(Bookmark::FolderType type)
{
	BOOKLIST *current;
	Bookmark *bm;	// XgoubN}[Ñ|C^

	current = m_currentList;

	if (current == NULL){
		return NULL;
	}
	// Xg̗vf`FbNĂB
	currentItem = current->begin();
	for	( ; currentItem != current->end() ; ++currentItem ){
		bm = currentItem->getBookmark();
		if (bm == NULL){	// ĂȂꍇ͖B
			continue;
		}
		if (bm->getItemType() == Bookmark::bookmark) {
			// ubN}[N͖
			continue;
		}
		if (bm->getFolderType() == Bookmark::normalFolder) {
			// ̃tH_͂ς̂Ŗ
			continue;
		}
		if (bm->getFolderType() == type) {
			if (mainBrowser){	// ҏWΏۃuEÛƂ̂ݎQƃJEg𑝂₷B
				currentItem->addRefer();	// QƃJEg1₷
			}
			return bm;
		}
	}
	// ړĂ̂̂Ȃꍇ݂̂ɂB
	return NULL;

}

bm_listitem *BookmarkTree::getFolderNodeByAttribute(Bookmark::FolderType type)
{
	BOOKLIST *current;
	Bookmark *bm;	// XgoubN}[Ñ|C^

	current = m_currentList;

	if (current == NULL){
		return NULL;
	}
	// Xg̗vf`FbNĂB
	currentItem = current->begin();
	for (; currentItem != current->end(); ++currentItem){
		bm = currentItem->getBookmark();
		if (bm == NULL){	// ĂȂꍇ͖B
			continue;
		}
		if (bm->getItemType() == Bookmark::bookmark) {
			// ubN}[N͖
			continue;
		}
		if (bm->getFolderType() == Bookmark::normalFolder) {
			// ̃tH_͂ς̂Ŗ
			continue;
		}
		if (bm->getFolderType() == type) {
			return &(*currentItem);
		}
	}
	// ړĂ̂̂Ȃꍇ݂̂ɂB
	return NULL;

}

/**
 * GetBookmarkŌtH_ɈړB
 *
 */
void BookmarkTree::downFolder(void)
{
	if (currentItem->getChild() != NULL){
		// qtH_ɈړB
		m_parentList = m_currentList;
		m_currentList = currentItem->getChild();

		// IWiubN}[N̏ԂB
		m_level++;
		if ((int)order.size() <= m_level){
			order.push_back(0);
		}else{
			order[m_level] = 0;
		}
	}

}

/*
	pathŎubN}[NubN}[NXg擾B
	
		path pX(\nO\nO)
		folderFlag true:tH_ false:tH_
	߂l
		NULL ubN}[N̏ւ̃|C^
		NULL pXŎubN}[N݂͑ȂB
*/
Bookmark *BookmarkTree::getBookmarkByPath(wchar_t *path,bool folderFlag)
{
	BOOKLIST *current;
	BOOKLIST::iterator iter;
	wchar_t *p,*pfn,*name;
	int count;
	Bookmark *bm;

	current = &m_topList;
	p = path + 1;
	pfn = p;

	if (path == NULL){
		return NULL;
	}

	for (;;){
		/* ̊Kw̓pX̕B */
		for (count = 0;*p != L'\n' && *p != L'\0';count++,p++){}
		
		if (current == NULL){
			return NULL;
		}
		// Xg̗vf`FbNĂB
		iter = current->begin();
		for	( ; iter != current->end() ; ++iter ){
			bm = iter->getBookmark();
			if (bm == NULL){
				continue;
			}
			name = bm->getIeNameW();
			if (name == NULL){
				continue;
			}
			if (!wcsncmp(name,pfn,count)){
				if ((*(name + count) == L'\0') || (*(name + count) == L'\n')){
					// ÔŔB
					if (*p == L'\0'){
						// ꂪŌ̂Ƃ͖ŔB
							debugprintf("last\n");
						break;
					}else{
						if (bm->getItemType() == Bookmark::folder){
							// tH_̂ƂB
							debugprintf("sub folder\n");
							break;
						}
					}
					
				}
			}
		}
		// IɒBB
		if (iter == current->end()){
			return NULL;
		}

		// ̊Kw𒲂ׂB
		if (*p == L'\0'){
			// ԍŌ܂Ń}b`B
			if (folderFlag){
				// tH_̏ꍇ
				if (bm->getItemType() == Bookmark::folder){
					debugprintf("folder\n");
					return bm;
				}else{
					return NULL;
				}
			}else{
				// tH_łȂꍇ
				if (bm->getItemType() == Bookmark::bookmark){
					debugprintf("bookmark\n");
					return bm;
				}else{
					return NULL;
				}
			}
		}else{
			if (bm->getItemType() == Bookmark::bookmark){
				return NULL;
			}
			p++;
			pfn = p;
			current = iter->getChild();
		}
	}
	//return NULL;

}

/*
	ubN}[NBOOKLISTɊi[B
	
		path pXւ̃|C^
		bookmark ubN}[Ni[\̂ւ̃pX
	߂l
		0 i[(bookmarki[)
		1 i[(݂̂̂B)
		2 i[s
*/
int BookmarkTree::storeItemByPath(wchar_t *path,Bookmark *bookmark)
{
	BOOKLIST *current;
	BOOKLIST *parent;
	BOOKLIST::iterator iter;
	wchar_t *p,*pfn,*name;
	int count;
	Bookmark *bm;

	bm_listitem newItem;
	BOOKLIST::iterator item;
	BOOKLIST *newList;

	int order;

	current = &m_topList;
	parent = NULL;
	p = path + 1;
	pfn = p;
	order = -1;

	debugprintf(":Search start...\n");


	for (;;){
		/* ̊Kw̓pX̕B */
		for (count = 0;*p != L'\n' && *p != L'\0';count++,p++){}

		for	(iter = current->begin() ; iter != current->end() ; ++iter ){
			bm = iter->getBookmark();
			if (bm == NULL){
				continue;
			}
			if (order < bm->getOrder()){	// ԑ傫lOrder߂B
				order = bm->getOrder();
			}
			name = bm->getIeNameW();
			if (name == NULL){
				continue;
			}
			debugprintf(":%S|...|%S\n",name,pfn);
			if (!wcsncmp(name,pfn,count)){
				if ((*(name + count) == L'\0') || (*(name + count) == L'\n')){
					if (*p == L'\0'){	// ǉ
						if (bm->getItemType() == bookmark->getItemType()){
							// ނꍇ݈̂vƂ݂ȂB
							debugprintf("\n");
							break;
						}else{
							debugprintf("ވႢ\n");
						}
					}else{
						// ȑꍇ̓tH_̏ꍇ݂̂ǂB
						if (bm->getItemType() == Bookmark::folder){
							break;
						}
					}
				}
			}
		}
		// IɒBB
		if (iter == current->end()){
			if (*p == L'\0'){	// ǉ
				debugprintf(":New Item...\n");
				// ubN}[Ni[̂ł̏ꍇdeleteĂ͂ȂB
				bookmark->setOrder(order + 1);	// V͈ԉɒuB

				// ݂̃XgɒǉB
				current->push_back(newItem);
				item = current->end();
				item--;

				item->setBookmark(bookmark);
				item->setPath(path);
				item->addRefer();
				if (parent != NULL){
					item->setParent(parent);
				}
				// tH_̏ꍇ̓TutH_pXgȂB
				if (bookmark->getItemType() == Bookmark::folder){
					debugprintf(":New Folder\n");
					try{
						newList = new BOOKLIST;
						if (newList == NULL){
							return 2;
						}
					}catch(...){
						return 2;
					}
					
					debugprintf(":setChild\n");
					item->setChild(newList);
				}

				return 0;
			}else{	// r݂ȂB
				debugprintf(":Not Found...\n");
				return 2;
			}
		}

		// ̊Kw𒲂ׂB
		if (*p == L'\0'){	// ̃ubN}[N
			debugprintf(": Item...\n");
			iter->addRefer();
			// Ŋ̑Rs[B
			bm->copyBookmark(bookmark);

			//*bm = *bookmark;
			return 1;
		}else{
			if (bm->getItemType() == Bookmark::bookmark){
				debugprintf(":Bad Folder...\n");
				return 2;
			}
			debugprintf(":Change Folder...\n");
			iter->addRefer();
			p++;
			pfn = p;
			parent = current;
			current = iter->getChild();
			if (current == NULL){
				return 2;
			}
		}
	}
	//return 2;

}

/**
 * w肳ꂽubN}[NXg̓eSo͂B
 *
 * @param list o͑Ώۂ̃Xg
 */
void BookmarkTree::putList(BOOKLIST *list)
{
	BOOKLIST::iterator iter;
	Bookmark *bm;
	int order;	// ubN}[N̕яOperaFяv邽߂ɗpӂB
	int itemPosition = 0;	// Zp[^ȊȌo͑Ώۂ̏
	
	order = 0;

	// tH_̓e\[gB
	if (browser > -1) {
		list->sort();
	}
	int size = list->size();
	int i = 0;
	int refers = 0;	// oACe

	// o͑ΏۂOpera 25ȍ~̃ubN}[NH
	bool isOpera25 =
		(browser == BOOKMARK_OPERA25_1) || (browser == BOOKMARK_OPERA25_2);

	// ܂AoACe𐔂B
	for	(iter = list->begin(); iter != list->end() ; ++iter,i++ ){
		if (iter->getRefer()){
			if (!iter->getBookmark()->getSeparator()) {
				// ACeɃZp[^܂܂ȂB
				bm = iter->getBookmark();
				enum Bookmark::BookmarkType type = bm->getItemType();
				if (type == Bookmark::folder) {
					// tH_Opera 29̃Xs[h_CH
					bool isSpeedDial = 
						(bm->getOp25Bookmark(0)->getFolderType() == Op25Bookmark::speedDial) ||
						(bm->getOp25Bookmark(1)->getFolderType() == Op25Bookmark::speedDial);
					// ubN}[NOpera 25ȍ~̃ubN}[NH
					if (!isSpeedDial) {
						// Xs[h_CȊȌꍇ
						refers++;
					} else {
						// Xs[h_C̏ꍇ
						if (op29SpeedDialPut) {
							// ̃uEUłXs[h_Co͂ꍇ
							refers++;
						} else {
							// ̃uEUł̓Xs[h_Co͂Ȃꍇ
							if (isOpera25) {
								// Opera 25̏ꍇ̂ݏo͂
								refers++;
							}
						}
					}
				} else {
					refers++;
				}
			}
		}
	}

	for	(iter = list->begin(); iter != list->end() ; ++iter ){
		if (iter->getRefer()){
			bm = iter->getBookmark();
			if (bm == NULL){
				continue;
			}
			bm->setOrder(order);
			bool isLast = false;
			if (itemPosition == (refers - 1)) {
				isLast = true;
			}
			if (bm->getItemType() == Bookmark::bookmark){
				// ubN}[N̏ꍇ͂̂܂܏
				writer->putBookmark(bm,isLast);
			}else{
				bool skip = false;
				// tH_Opera 29̃Xs[h_CH
				bool isSpeedDial =
					(bm->getOp25Bookmark(0)->getFolderType() == Op25Bookmark::speedDial) ||
					(bm->getOp25Bookmark(1)->getFolderType() == Op25Bookmark::speedDial);

				// Opera 29̃Xs[h_Co͂邩ۂ
				if (isSpeedDial) {
					if (!op29SpeedDialPut) {
						if (!isOpera25) {
							skip = true;
						}
					}
				}

				// tH_̏ꍇ͍ċAĂяosătH_̒gĂB
				if (!skip) {
					writer->putFolder(bm);
					if (iter->getChild() != NULL) {
						putList(iter->getChild());
					}

					writer->putFolderEnd(bm, isLast);
				}
			}
			order++;
			if (!bm->getSeparator()) {
				itemPosition++;
			}
		}
		Sleep(0);
	}
}

/**
 * ubN}[Nj[ȊÕubN}[NXg̓eo͂B
 *
 */
void BookmarkTree::putToolBar()
{
	BOOKLIST::iterator iter;
	Bookmark *bm;
	int order;	// ubN}[N̕яOperaFяv邽߂ɗpӂB
	int itemPosition = 0;	// Zp[^ȊȌo͑Ώۂ̏

	upToTop();
	BOOKLIST *list = m_currentList;
	order = 0;

	// tH_̓e\[gB
	if (browser > -1) {
		list->sort();
	}
	int size = list->size();
	int i = 0;
	int refers = 0;	// oACe

	// ܂AoACe𐔂B
	for	(iter = list->begin(); iter != list->end() ; ++iter,i++ ){
		if (iter->getRefer()){
			if (!iter->getBookmark()->getSeparator()) {
				// ACeɃZp[^܂܂ȂB
				refers++;
			}
		}
	}

	for	(iter = list->begin(); iter != list->end() ; ++iter ){
		if (iter->getRefer()){
			bm = iter->getBookmark();
			if (bm == NULL){
				continue;
			}
			bm->setOrder(order);
			bool isLast = false;
			if (itemPosition == (refers - 1)) {
				isLast = true;
			}
			if (bm->getItemType() == Bookmark::folder){
				// j[ȊOo͂B(c[o[)
				if (bm->getFolderType() == Bookmark::toolBar) {
					// c[o[tH_̏ꍇ͍ċAĂяosătH_̒gĂB
					writer->putFolder(bm);
					if (iter->getChild() != NULL){
						putList(iter->getChild());
					}

					writer->putFolderEnd(bm,isLast);
				}
			}
			order++;
			if (!bm->getSeparator()) {
				itemPosition++;
			}
		}
	}
}

/**
 * ubN}[No[AubN}[Nj[ȊÕubN}[NXg̓eo͂B
 *
 */
void BookmarkTree::putWithoutToolMenu()
{
	BOOKLIST::iterator iter;
	Bookmark *bm;
	int order;	// ubN}[N̕яOperaFяv邽߂ɗpӂB
	int itemPosition = 0;	// Zp[^ȊȌo͑Ώۂ̏

	upToTop();
	BOOKLIST *list = m_currentList;
	order = 0;

	// tH_̓e\[gB
	if (browser > -1) {
		list->sort();
	}
	int size = list->size();
	int i = 0;
	int refers = 0;	// oACe

	// ܂AoACe𐔂B
	for	(iter = list->begin(); iter != list->end() ; ++iter,i++ ){
		if (iter->getRefer()){
			if (!iter->getBookmark()->getSeparator()) {
				// ACeɃZp[^܂܂ȂB
				refers++;
			}
		}
	}

	for	(iter = list->begin(); iter != list->end() ; ++iter ){
		if (iter->getRefer()){
			bm = iter->getBookmark();
			if (bm == NULL){
				continue;
			}
			bm->setOrder(order);
			bool isLast = false;
			if (itemPosition == (refers - 1)) {
				isLast = true;
			}
			if (bm->getItemType() == Bookmark::folder){
				// j[Ec[o[ȊOo͂B
				if ((bm->getFolderType() != Bookmark::toolBar) &&
					(bm->getFolderType() != Bookmark::menuBar) ) {
					// c[o[tH_̏ꍇ͍ċAĂяosătH_̒gĂB
					writer->putFolder(bm);
					if (iter->getChild() != NULL){
						putList(iter->getChild());
					}

					writer->putFolderEnd(bm,isLast);
				}
			} else {
				// j[ȊÕgbvx̃ubN}[No͂B
				writer->putBookmark(bm,isLast);
			}
			order++;
			if (!bm->getSeparator()) {
				itemPosition++;
			}
		}
	}
}

/**
 * w肳ꂽubN}[NXg̓ec[o[ȊOSo͂B
 *
 * @param list o͑Ώۂ̃Xg
 */
void BookmarkTree::putWithoutToolbar(BOOKLIST *list)
{
	BOOKLIST::iterator iter;
	Bookmark *bm;
	int order;	// ubN}[N̕яOperaFяv邽߂ɗpӂB
	int itemPosition = 0;	// Zp[^ȊȌo͑Ώۂ̏
	
	order = 0;

	// tH_̓e\[gB
	if (browser > -1) {
		list->sort();
	}
	int size = list->size();
	int i = 0;
	int refers = 0;	// oACe

	// ܂AoACe𐔂B
	for	(iter = list->begin(); iter != list->end() ; ++iter,i++ ){
		if (iter->getRefer()){
			if (!iter->getBookmark()->getSeparator()) {
				// ACeɃZp[^܂܂ȂB
				refers++;
			}
		}
	}

	for	(iter = list->begin(); iter != list->end() ; ++iter ){
		if (iter->getRefer()){
			bm = iter->getBookmark();
			if (bm == NULL){
				continue;
			}
			bm->setOrder(order);
			bool isLast = false;
			if (itemPosition == (refers - 1)) {
				isLast = true;
			}
			if (bm->getItemType() == Bookmark::folder){
				if (bm->getFolderType() == Bookmark::menuBar) {
					// tH_̏ꍇ͍ċAĂяosătH_̒gĂB
					writer->putFolder(bm);
					if (iter->getChild() != NULL){
						putList(iter->getChild());
					}

					writer->putFolderEnd(bm,isLast);
					order++;
				}
			}
			if (!bm->getSeparator()) {
				itemPosition++;
			}
		}
	}
}

/**
 *	ubN}[NXg̓eSo͂B(Jn)
 *
 */
int BookmarkTree::putAll(void)
{
	BOOKLIST::iterator iter;
	Bookmark *bm;

	iter = m_currentList->begin();
	if (iter == m_currentList->end()) {
		writer->putHeader();
		writer->putFooter();
		return 0;
	}
	
	bm = iter->getBookmark();
	if (bm != NULL) {
		writer->putHeader();
	}

	debugprintf("putAll\n");
	putList(m_currentList);

	// putListŃ\[gŝłĂ݂B
	//iter = m_currentList.begin();
	//bm = iter->getBookmark();
	//if (bm != NULL)
	writer->putFooter();

	return 0;
}

/**
 * ̃ubN}[ÑubN}[Nj[ȊO̓e
 * ǂݍ񂾃ubN}[NXg̓eo͂B(Jn)
 *
 */
int BookmarkTree::putWithOriginalToolbar(BookmarkTree *originalTree)
{
	BOOKLIST::iterator iter;
	Bookmark *bm;

	iter = m_currentList->begin();
	originalTree->upToTop();
	
	bm = iter->getBookmark();
	if (bm != NULL) {
		writer->putHeader();
	}

	int menuSortMode = Bookmark::getSortMode();

	// c[o[͌̃ubN}[N̂̂o͂B
	// \[g@͌̃ubN}[N̏ԂɂB
	Bookmark::setSortMode(0);
	originalTree->putToolBar();
	debugprintf("putAll\n");

	// c[o[ȊO͕ϊ̂̂o͂B
	// \[g@̓[U[w肵@ɂB
	Bookmark::setSortMode(menuSortMode);
	putWithoutToolbar(m_currentList);

	// c[o[͌̃ubN}[N̂̂o͂B
	// \[g@͌̃ubN}[N̏ԂɂB
	Bookmark::setSortMode(0);
	originalTree->upToTop();
	originalTree->putWithoutToolMenu();

	writer->putFooter();

	return 0;
}

/**
 * w肳ꂽubN}[NXg̓eSo͂B
 *
 * @param list QƃtOΏۂ̃Xg
 */
void BookmarkTree::setReferAll(BOOKLIST *list,bool recursive)
{
	BOOKLIST::iterator iter;
	Bookmark *bm;

	if (list == NULL) {
		return;
	}

	for	(iter = list->begin(); iter != list->end() ; ++iter ){
		iter->addRefer();

		bm = iter->getBookmark();
		if (bm == NULL){
			continue;
		}
		if (bm->getItemType() == Bookmark::folder){
			if (iter->getChild() != NULL){
				if (recursive) {
					setReferAll(iter->getChild(),recursive);
				}
			}
		}
	}
}

/**
 * Firefox 3/SafariȊÕubN}[Nw肵ꍇɃc[o[
 * QƂȂߎQƂB
 */
void BookmarkTree::setTopRefer()
{
	//setReferAll(m_toolbarList,true);
	//setReferAll(m_tagsList,true);
	//setReferAll(m_unfiledList,true);
	// setReferAll(&m_topList,false);

	// ŏ̊Kw̃j[o[(łɎQƃJEgĂ)ȊOɎQƃJEgB
	BOOKLIST::iterator iter;
	Bookmark *bm;

	for	(iter = m_topList.begin(); iter != m_topList.end() ; ++iter ){
		iter->addRefer();

		bm = iter->getBookmark();
		if (bm == NULL){
			continue;
		}
		if (bm->getItemType() == Bookmark::folder){
			if (bm->getFolderType() != Bookmark::menuBar) {
				if (iter->getChild() != NULL){
					setReferAll(iter->getChild(),true);
				}
			}
		}
	}

}

/**
 * Firefox 3/SafariȊÕubN}[Nw肵ꍇɃc[o[
 * QƂȂߎQƂB
 */
void BookmarkTree::setTopReferWithoutBar()
{
	//setReferAll(m_toolbarList,true);
	//setReferAll(m_tagsList,true);
	//setReferAll(m_unfiledList,true);
	// setReferAll(&m_topList,false);

	// ŏ̊Kw̃j[o[(łɎQƃJEgĂ)ȊOɎQƃJEgB
	BOOKLIST::iterator iter;
	Bookmark *bm;

	for (iter = m_topList.begin(); iter != m_topList.end(); ++iter) {
		iter->addRefer();

		bm = iter->getBookmark();
		if (bm == NULL) {
			continue;
		}
		if (bm->getItemType() == Bookmark::folder) {
			if (bm->getFolderType() != Bookmark::toolBar) {
				if (iter->getChild() != NULL) {
					setReferAll(iter->getChild(), true);
				}
			}
		}
	}

}

/**
* ChromẽubN}[Nw肵ꍇɃc[o[
* QƂȂߎQƂB
*/
void BookmarkTree::setUnfiledRefer()
{

	// ŏ̊Kw̃j[o[(łɎQƃJEgĂ)ȊOɎQƃJEgB
	BOOKLIST::iterator iter;
	Bookmark *bm;

	for (iter = m_topList.begin(); iter != m_topList.end(); ++iter){
		iter->addRefer();

		bm = iter->getBookmark();
		if (bm == NULL){
			continue;
		}
		if (bm->getItemType() == Bookmark::folder){
			if (bm->getFolderType() == Bookmark::unFiled) {
				if (iter->getChild() != NULL){
					setReferAll(iter->getChild(), true);
				}
			}
		}
	}

}

/**
 * Opera 19̃ubN}[No[𑼂̃uEŨubN}[Nc[o[ƂĈꍇ
 * ubN}[Nj[̎QƂȂߎQƂB
 */
void BookmarkTree::setMenuRefer()
{
	//setReferAll(m_toolbarList,true);
	//setReferAll(m_tagsList,true);
	//setReferAll(m_unfiledList,true);
	// setReferAll(&m_topList,false);

	// ŏ̊Kw̃c[o[(łɎQƃJEgĂ)ȊOɎQƃJEgB
	BOOKLIST::iterator iter;
	Bookmark *bm;

	for	(iter = m_topList.begin(); iter != m_topList.end() ; ++iter ){
		iter->addRefer();

		bm = iter->getBookmark();
		if (bm == NULL){
			continue;
		}
		if (bm->getItemType() == Bookmark::folder){
			if (bm->getFolderType() != Bookmark::toolBar) {
				if (iter->getChild() != NULL){
					setReferAll(iter->getChild(),true);
				}
			}
		}
	}

}

/**
 * SafarĩubN}[Nw肵ꍇɃ^O
 * QƂȂߎQƂB
 */
void BookmarkTree::setTagsRefer()
{
	setReferAll(m_tagsList,true);
}

/**
 *	pathŎ擾AtH_ɈړB
 *
 * @param path ACe
 * @param folderFlag true:tH_ false:tH_
 * @return NULL ubN}[N̏ւ̃|C^<br>
 *         NULL pXŎubN}[N݂͑ȂB
 */
Bookmark *BookmarkTree::moveFolder(const wchar_t *path,bool folderFlag)
{
	BOOKLIST *current;
	wchar_t *name;	// Ώۂ̃ACeƃXgoACe
	Bookmark *bm;	// XgoubN}[Ñ|C^

	current = m_currentList;

	if (path == NULL){
		return NULL;
	}

	if (current == NULL){
		return NULL;
	}
	// Xg̗vf`FbNĂB
	currentItem = current->begin();
	for	( ; currentItem != current->end() ; ++currentItem ){
		bm = currentItem->getBookmark();
		if (bm == NULL){	// ĂȂꍇ͖B
			continue;
		}
		name = bm->getIeNameW();
		if (name == NULL){
			continue;
		}
		if (!wcscmp(name,path)){
			// O̓ACe̎ނǂׂB
			if (folderFlag){
				// tH_̏ꍇ
				if (bm->getItemType() == Bookmark::folder){

					if (currentItem->getChild() != NULL){
						// qtH_ɈړB
						m_parentList = m_currentList;
						m_currentList = currentItem->getChild();

						m_level++;
					}
					return bm;
				}
			}
		}
	}
	// ړĂ̂̂Ȃꍇ݂̂ɂB
	return NULL;

}

/**
 * w肳ꂽubN}[NXg̓eSi[B
 *
 * @param list i[Ώۂ̃Xg
 */
void BookmarkTree::storeList(BOOKLIST *list)
{
	BOOKLIST::iterator iter;
	Bookmark *bm;
	
	for	(iter = list->begin(); iter != list->end() ; ++iter ){
		bm = iter->getBookmark();
		if (bm == NULL){
			continue;
		}

		if (bm->getItemType() == Bookmark::bookmark){
			// ubN}[N̏ꍇ͂̂܂܏
			targetTree->storeItem(bm);
		}else{
			// tH_̏ꍇ͍ċAĂяosătH_̒gĂB
			targetTree->storeItem(bm);
			if (iter->getChild() != NULL){
				storeList(iter->getChild());
				targetTree->upFolder();
			}
		}
	}
}

/**
 *	ubN}[NXg̓eSi[B(Jn)
 *
 */
int BookmarkTree::storeAll(void)
{
	debugprintf("putAll\n");
	storeList(m_currentList);

	return 0;
}

/**
 * pathŎubN}[NubN}[NXg擾B
 *
 * @param path pX(\nO\nO)
 * @return NULL ubN}[N̏ւ̃|C^<br>
 *         NULL pXŎubN}[N݂͑ȂB<br>
 */
BOOKLIST *BookmarkTree::getBookmarkFolderByPath(const wchar_t *path,Bookmark::FolderType type)
{
	BOOKLIST *current;
	BOOKLIST *find;
	BOOKLIST::iterator iter;
	wchar_t *p,*pfn,*name;
	int count;
	Bookmark *bm;

	if (path == NULL) {
		return NULL;
	}

	current = &m_topList;
	p = const_cast<wchar_t *>(path) + 1;
	pfn = p;

	// Xg̗vf`FbNĂB
	find = NULL;
	currentItem = current->begin();
	for	( ; currentItem != current->end() ; ++currentItem ){
		bm = currentItem->getBookmark();
		if (bm == NULL){	// ĂȂꍇ͖B
			continue;
		}
		if (bm->getItemType() == Bookmark::bookmark) {
			// ubN}[N͖
			continue;
		}
		if (bm->getFolderType() == Bookmark::normalFolder) {
			// ̃tH_͂ς̂Ŗ
			continue;
		}
		if (bm->getFolderType() == type) {
			find = currentItem->getChild();
			break;
		}
	}
	if (find == NULL) {
		return NULL;
	} else {
		current = find;
	}
	// ̊Kw𒲂ׂB
	if (*p == L'\0'){
		// ԍŌ܂Ń}b`B
		// tH_̏ꍇ
		if (bm->getItemType() == Bookmark::folder){
			debugprintf("folder\n");
			return current;
		}else{
			return NULL;
		}
	}

	for (;;){
		/* ̊Kw̓pX̕B */
		for (count = 0;*p != L'\n' && *p != L'\0';count++,p++){}
		
		if (current == NULL){
			return NULL;
		}
		// Xg̗vf`FbNĂB
		iter = current->begin();
		for	( ; iter != current->end() ; ++iter ){
			bm = iter->getBookmark();
			if (bm == NULL){
				continue;
			}
			name = bm->getIeNameW();
			if (name == NULL){
				continue;
			}
			if (!wcsncmp(name,pfn,count)){
				if ((*(name + count) == L'\0') || (*(name + count) == L'\n')){
					// ÔŔB
					if (*p == L'\0'){
						// ꂪŌ̂Ƃ͖ŔB
							debugprintf("last\n");
						break;
					}else{
						if (bm->getItemType() == Bookmark::folder){
							// tH_̂ƂB
							debugprintf("sub folder\n");
							break;
						}
					}
					
				}
			}
		}
		// IɒBB
		if (iter == current->end()){
			return NULL;
		}

		// ̊Kw𒲂ׂB
		if (*p == L'\0'){
			// ԍŌ܂Ń}b`B
			// tH_̏ꍇ
			if (bm->getItemType() == Bookmark::folder){
				debugprintf("folder\n");
				return iter->getChild();
			}else{
				return NULL;
			}
		}else{
			if (bm->getItemType() == Bookmark::bookmark){
				return NULL;
			}
			p++;
			pfn = p;
			current = iter->getChild();
		}
	}
	//return NULL;

}

/**
 * pathŎubN}[Nւ̎QƂ͂
 *
 * @param path pX(\nO\nO)
 * @return true:QƂ͂ false:QƂ͂Ȃ<br>
 */
bool BookmarkTree::unreferBookmarkFolderByPath(wchar_t *path,Bookmark::FolderType type)
{
	BOOKLIST *current;
	BOOKLIST *find;
	BOOKLIST::iterator iter;
	wchar_t *p,*pfn,*name;
	int count;
	Bookmark *bm;

	current = &m_topList;
	p = path + 1;
	pfn = p;

	if (path == NULL){
		return false;
	}

	// Xg̗vf`FbNĂB
	find = NULL;
	currentItem = current->begin();
	for	( ; currentItem != current->end() ; ++currentItem ){
		bm = currentItem->getBookmark();
		if (bm == NULL){	// ĂȂꍇ͖B
			continue;
		}
		if (bm->getItemType() == Bookmark::bookmark) {
			// ubN}[N͖
			continue;
		}
		if (bm->getFolderType() == Bookmark::normalFolder) {
			// ̃tH_͂ς̂Ŗ
			continue;
		}
		if (bm->getFolderType() == type) {
			find = currentItem->getChild();
			break;
		}
	}
	if (find == NULL) {
		return false;
	} else {
		current = find;
	}
	// ̊Kw𒲂ׂB
	if (*p == L'\0'){
		// ԍŌ܂Ń}b`B
		// tH_̏ꍇ
		if (bm->getItemType() == Bookmark::folder){
			debugprintf("folder\n");
			currentItem->resetRefer();
			return true;
		}else{
			return NULL;
		}
	}

	for (;;){
		/* ̊Kw̓pX̕B */
		for (count = 0;*p != L'\n' && *p != L'\0';count++,p++){}
		
		if (current == NULL){
			return NULL;
		}
		// Xg̗vf`FbNĂB
		iter = current->begin();
		for	( ; iter != current->end() ; ++iter ){
			bm = iter->getBookmark();
			if (bm == NULL){
				continue;
			}
			name = bm->getIeNameW();
			if (name == NULL){
				continue;
			}
			if (!wcsncmp(name,pfn,count)){
				if ((*(name + count) == L'\0') || (*(name + count) == L'\n')){
					// ÔŔB
					if (*p == L'\0'){
						// ꂪŌ̂Ƃ͖ŔB
							debugprintf("last\n");
						break;
					}else{
						if (bm->getItemType() == Bookmark::folder){
							// tH_̂ƂB
							debugprintf("sub folder\n");
							break;
						}
					}
					
				}
			}
		}
		// IɒBB
		if (iter == current->end()){
			return false;
		}

		// ̊Kw𒲂ׂB
		if (*p == L'\0'){
			// ԍŌ܂Ń}b`B
			// tH_̏ꍇ
			if (bm->getItemType() == Bookmark::folder){
				debugprintf("folder\n");
				iter->resetRefer();
				return true;
			}else{
				return false;
			}
		}else{
			if (bm->getItemType() == Bookmark::bookmark){
				return false;
			}
			p++;
			pfn = p;
			current = iter->getChild();
		}
	}
	//return NULL;

}

