#ifndef BOOKMARK_H
#define BOOKMARK_H

#include	"BScommon.h"
#include	"../platform/Mozilla/MozillaBookmark.h"
#include	"../platform/Opera/OperaBookmark.h"
#include	"../platform/Firefox/FxBookmark.h"
#include	"../platform/Safari/SafariBookmark.h"
#include	"../platform/Ie/IeBookmark.h"
#ifdef WITH_EDGE
#include	"../platform/Edge/EdgeBookmark.h"
#endif	// WITH_EDGE
#include	"../platform/XBEL/XbelBookmark.h"
#include	"../platform/Chrome/ChromeBookmark.h"
#ifdef WITH_OP15
#include	"../platform/Op15/Op15Bookmark.h"
#endif	// WITH_OP15
#include	"../platform/Op25/Op25Bookmark.h"
#include	"../platform/Vivaldi/ViBookmark.h"
#include	"../platform/Edge2/Edge2Bookmark.h"
#include	<time.h>

class Bookmark {
public:
	enum BookmarkType               // enum ɂ Days ^`
	{
		bookmark,
		folder
	};

	enum FolderType
	{
		normalFolder,		// ()tH_
		menuBar,	// j[o[tH_
		toolBar,	// c[o[tH_
		tags,		// ^O(Firefox 3)
		unFiled,	// Unfiled bookmark(Firefox 3/Opera 28)
		topFolder,	// gbvx̃tH_(Firefox 3)
		mobile,		// oC̃ubN}[N(Chrome/Firefox)
		customRoot,	// custom_root(Opera 25)
		speedDial,	// Speed dial(Opera 29)
		viTrash		// Vivaldi's trash
	};

private:
	static int sortMode;	// \[g@
	static int sortTarget;	// euEȔԂŃ\[gۂ̑ΏۃuEU

	char *m_url;		// URL
	char *m_name;		// ubN}[N
	char *m_ieName;		// ubN}[N
	wchar_t *m_ieNameW;	// ubN}[N(Unicode)
	time_t m_create;	// ǉ
	time_t m_visit;		// ŏIK⎞
	time_t m_modified;	// ύX
	char *m_description;	// 
	char *m_shortcut;	// V[gJbg
	BookmarkType m_itemType;		// (0:ubN}[N 1:tH_)
	int m_order;	// \
	char *m_icon;		// ACR(IE,Mozilla(Seamonkey)
	bool m_separator;	// Zp[^(IEł͖B)
	bool m_isIEToolbar;	// IẼubN}[No[ǂ
	IeBookmark m_ie;
#ifdef WITH_EDGE
	EdgeBookmark m_edge;
#endif	// WITH_EDGE
	MozillaBookmark m_mozilla[2];
	OperaBookmark m_opera[2];
	FxBookmark m_fx[2];
	SafariBookmark m_safari[2];
	ChromeBookmark m_chrome[2];
	XbelBookmark m_xbel[2];
#ifdef WITH_OP15
	Op15Bookmark m_op15[2];
#endif	// WITH_OP15
	Op25Bookmark m_op25[2];
	ViBookmark m_vi[2];
	Edge2Bookmark m_edge2[2];
	int m_orgOrder[ALL_BOOKMARKS];	// euEUł̕\
	bool m_attributeFlag[ALL_BOOKMARKS];	// euEȖݒ肵ǂH
	FolderType m_folderType;	// tH_̎

	void _init();
public:
	/* EʁEj */
	Bookmark(void);
	Bookmark(const Bookmark &);
	virtual ~Bookmark();

	void copyWithoutUserAttribute(const Bookmark &src);
	void copy(const Bookmark &src);
	virtual int copyBookmark(Bookmark *src);

	void reset(void);

	static int getSortMode(void) { return sortMode; };
	static int setSortMode(int mode) { sortMode = mode;return sortMode; };
	static int getSortTarget(void) { return sortTarget; };
	static int setSortTarget(int target) { sortTarget = target;return sortTarget; };


	/* ʑ */
	char *getURL(void) const { return m_url; }
	char *setURL(const char *item);

	char *getName(void) const { return m_name; }
	char *setName(const char *item);

	char *getIeName(void) const { return m_ieName; }
	char *setIeName(const char *item);

	wchar_t *getIeNameW(void) const { return m_ieNameW; }
	wchar_t *setIeNameW(const wchar_t *itemW);

	time_t getAdddate(void) const { return m_create; };
	time_t setAdddate(const char *item);
	time_t setAdddate(INT_TIME_T time){
		m_create = time;
		return m_create;
	};
	time_t setAdddate(const time_t item){
		m_create = item;
		return m_create;
	}

	time_t getLastvisit(void) const { return m_visit; };
	time_t setLastvisit(const char *item);
	time_t setLastvisit(const time_t item){
		m_visit = item;
		return m_visit;
	}

	time_t getModified(void) const { return m_modified; };
	time_t setModified(const char *item);
	time_t setModified(const time_t item){
		m_modified = item;
		return m_modified;
	}

	char *getDescription(void) const { return m_description; };
	char *setDescription(const char *item);

	char *getShortcut() const { return m_shortcut; };
	char *setShortcut(const char *item);
	
	BookmarkType getItemType(void) const { return m_itemType; };
	BookmarkType setItemType(const BookmarkType itemtype);

	int getOrder(void) const { return m_order; };
	int setOrder(const char *item);
	int setOrder(int item) { m_order = item;return m_order; };

	char *getIcon(void) const { return m_icon; };
	char *setIcon(const char *item);

	IeBookmark *getIeBookmark() const  {
		return const_cast<IeBookmark *>(&m_ie);
	};
#ifdef WITH_EDGE
	EdgeBookmark *getEdgeBookmark() const {
		return const_cast<EdgeBookmark *>(&m_edge);
	};
#endif	// WITH_EDGE
	MozillaBookmark *getMozillaBookmark(int no) const  {
		return const_cast<MozillaBookmark *>(&(m_mozilla[no]));
	};
	OperaBookmark *getOperaBookmark(int no) const {
		return const_cast<OperaBookmark *>(&(m_opera[no]));
	};
	FxBookmark *getFxBookmark(int no) const  {
		return const_cast<FxBookmark *>(&(m_fx[no]));
	};
	SafariBookmark *getSafariBookmark(int no) const {
		return const_cast<SafariBookmark *>(&(m_safari[no]));
	};
	ChromeBookmark *getChromeBookmark(int no) const {
		return const_cast<ChromeBookmark *>(&(m_chrome[no]));
	};
	XbelBookmark *getXbelBookmark(int no) const {
		return const_cast<XbelBookmark *>(&(m_xbel[no]));
	};
#ifdef WITH_OP15
	Op15Bookmark *getOp15Bookmark(int no) const {
		return const_cast<Op15Bookmark *>(&(m_op15[no]));
	};
#endif	// WITH_OP15
	Op25Bookmark *getOp25Bookmark(int no) const {
		return const_cast<Op25Bookmark *>(&(m_op25[no]));
	};
	ViBookmark *getViBookmark(int no) const {
		return const_cast<ViBookmark *>(&(m_vi[no]));
	};
	Edge2Bookmark *getEdge2Bookmark(int no) const {
		return const_cast<Edge2Bookmark *>(&(m_edge2[no]));
	};


	int getOrgOrder(int no) const {
		return m_orgOrder[no];
	}
	void setOrgOrder(int no,int order){
		m_orgOrder[no] = order;
	}

	bool getSeparator(void) const { return m_separator; };
	bool setSeparator(const bool status) {m_separator = status;return m_separator;};

	bool getAttributeFlag(int no) const {
		return m_attributeFlag[no];
	}
	void setAttributeFlag(int no,bool flag) {
		m_attributeFlag[no] = flag;
	}

	FolderType getFolderType(void) const {
		return m_folderType;
	}
	void setFolderType(const FolderType type) {
		m_folderType = type;
	}

	/**
	 * IÊCɓo[ǂH
	 *
	 * @return true:IÊCɓo[ false:IÊCɓo[ł͂ȂB
	 */
	bool isIEToolbar(void) const { return m_isIEToolbar; };
	void setIEToolbar(const bool isIEToolbar) {
		m_isIEToolbar = isIEToolbar;
	}

	bool isPlaceURI();

	Bookmark & operator = (const Bookmark &src);

	/* ubN}[N\[gpC^[tFCX(Ԃ͊eRo[^ŋK肷) */
	bool operator < (const Bookmark &target);


};

#endif	// __BOOKMARK_H
