#include	<stdio.h>
#include	<stdlib.h>
#include	<string.h>
#include	<time.h>
#include	<mbstring.h>
#include	"Bookmark.h"

int Bookmark::sortMode = 1;
int Bookmark::sortTarget = 0;

/**
 * RXgN^
 */
Bookmark::Bookmark()
{
	_init();
}

/**
 * Rs[RXgN^
 *
 * @param src Rs[̃IuWFNg
 */
Bookmark::Bookmark(const Bookmark &src)
{
	// B
	_init();

	// eRs[B
	copy(src);
}

/**
 * fXgN^
 */
Bookmark::~Bookmark()
{
	reset();
}

/**
 *	CX^X̓eB<br>
 *	RXgN^p
 *
 */
void Bookmark::_init()
{
	m_url = NULL;
	m_name = NULL;
	m_ieName = NULL;
	m_ieNameW = NULL;
	m_create = 0;
	m_visit = 0;
	m_description = NULL;
	m_shortcut = NULL;
	m_icon = NULL;
	m_itemType = bookmark;
	m_order = -1;
	for (int i = 0;i < ALL_BOOKMARKS;i++){
		m_orgOrder[i] = -1;
		m_attributeFlag[i] = false;
	}
	m_separator = false;
	m_folderType = normalFolder;
	m_isIEToolbar = false;
	m_op25[0].setFolderType(Op25Bookmark::normalFolder);
	m_op25[1].setFolderType(Op25Bookmark::normalFolder);
}

void Bookmark::reset(void)
{
	if (m_url != NULL){
		delete [] m_url;
		m_url = NULL;
	}
	if (m_name != NULL){
		delete [] m_name;
		m_name = NULL;
	}
	if (m_ieName != NULL){
		delete [] m_ieName;
		m_ieName = NULL;
	}
	if (m_ieNameW != NULL){
		delete [] m_ieNameW;
		m_ieNameW = NULL;
	}
	if (m_description != NULL){
		delete [] m_description;
		m_description = NULL;
	}
	if (m_shortcut != NULL){
		delete [] m_shortcut;
		m_shortcut = NULL;
	}
	if (m_icon != NULL){
		delete []m_icon;
		m_icon = NULL;
	}
	m_create = 0;
	m_visit = 0;
	m_modified = 0;
	m_order = -1;
	for (int i = 0;i < ALL_BOOKMARKS;i++){
		m_orgOrder[i] = -1;
		m_attributeFlag[i] = false;
	}
	m_separator = false;
	m_folderType = normalFolder;
	m_isIEToolbar = false;

	m_op25[0].setFolderType(Op25Bookmark::normalFolder);
	m_op25[1].setFolderType(Op25Bookmark::normalFolder);
}

/**
 * ubN}[N̓eRs[B([U[wvf)<br>
 * [U[wvfFEV[gJbgƂ[U[vf<br>
 * @[U[Iɕבւ鏇
 *
 * @param src Rs[Ώۂ̃ubN}[N
 */
void Bookmark::copyWithoutUserAttribute(const Bookmark &src)
{
	if (src.getURL() != NULL){
		setURL(src.getURL());
	}
	if (src.getName() != NULL){
		setName(src.getName());
	}
	if (src.getIeName() != NULL){
		setIeName(src.getIeName());
	}
	if (src.getIeNameW() != NULL){
		setIeNameW(src.getIeNameW());
	}
	if (src.getIcon() != NULL){
		setIcon(src.getIcon());
	}

	setAdddate(src.getAdddate());
	setLastvisit(src.getLastvisit());
	setModified(src.getModified());
	setItemType(src.getItemType());
	setOrder(src.getOrder());
	setSeparator(src.getSeparator());
	setFolderType(src.getFolderType());
	setIEToolbar(src.isIEToolbar());

	// IȄԏ񂾂͊i[ł͂Ȃ̂ňpKvB
	setOrgOrder(0,src.getOrgOrder(0));
}

/**
 * ubN}[N̓eRs[B
 *
 * @param src Rs[Ώۂ̃ubN}[N
 */
void Bookmark::copy(const Bookmark &src)
{

	// [U[wvfȊÕRs[
	copyWithoutUserAttribute(src);

	// 
	if (src.getDescription() != NULL){
		setDescription(src.getDescription());
	}
	// V[gJbg/jbNl[
	if (src.getShortcut() != NULL){
		setShortcut(src.getShortcut());
	}

	// SȃRs[ł͏ԂRs[B
	for (int i = 0;i < ALL_BOOKMARKS;i++){
		setOrgOrder(i,src.getOrgOrder(i));
	}

	m_ie = *(src.getIeBookmark());
	for (int i = 0;i < 2;i++){
		m_mozilla[i] = *(src.getMozillaBookmark(i));
	}

	for (int i = 0;i < 2;i++){
		m_opera[i] = *(src.getOperaBookmark(i));
	}

	for (int i = 0;i < 2;i++){
		m_fx[i] = *(src.getFxBookmark(i));
	}

	for (int i = 0;i < 2;i++){
		m_safari[i] = *(src.getSafariBookmark(i));
	}

	for (int i = 0;i < 2;i++){
		m_chrome[i] = *(src.getChromeBookmark(i));
	}

	for (int i = 0;i < 2;i++){
		m_xbel[i] = *(src.getXbelBookmark(i));
	}

#ifdef WITH_OP15
	for (int i = 0; i < 2; i++){
		m_op15[i] = *(src.getOp15Bookmark(i));
	}
#endif	// WITH_OP15

	for (int i = 0; i < 2; i++){
		m_op25[i] = *(src.getOp25Bookmark(i));
	}

	for (int i = 0; i < 2; i++) {
		m_vi[i] = *(src.getViBookmark(i));
	}

	// ݒ肵ǂ̃tO
	for (int i = 0;i < ALL_BOOKMARKS;i++){
		setAttributeFlag(i,src.getAttributeFlag(i));
	}
}

char *Bookmark::setURL(const char *item)
{
	char *p;
	int len;
	
	if (m_url != NULL){
		delete []m_url;
	}
	
	if (item == NULL){
		m_url = NULL;
		return NULL;
	}
	
	len = strlen(item) + 1;
	
	try{
		p = new char[len];
		if (p == NULL){
			return NULL;
		}
		strcpy(p,item);
		m_url = p;
	}catch(...){
		return NULL;
	}
	return p;
}

char *Bookmark::setName(const char *item)
{
	char *p;
	int len;
	
	if (m_name != NULL){
		delete []m_name;
	}

	if (item == NULL){
		m_name = NULL;
		return NULL;
	}
	
	len = strlen(item) + 1;
	
	try{
		p = new char[len];
		if (p == NULL){
			return NULL;
		}
		strcpy(p,item);
		m_name = p;
	}catch(...){
		return NULL;
	}
	return p;
}

char *Bookmark::setIeName(const char *item)
{
	char *p;
	int len;
	
	if (m_ieName != NULL){
		delete []m_ieName;
	}

	if (item == NULL){
		m_ieName = NULL;
		return NULL;
	}
	
	len = strlen(item) + 1;
	
	try{
		p = new char[len];
		if (p == NULL){
			return NULL;
		}
		strcpy(p,item);
		m_ieName = p;
	}catch(...){
		return NULL;
	}
	return p;
}

wchar_t *Bookmark::setIeNameW(const wchar_t *itemW)
{
	wchar_t *p;
	int len;
	
	if (m_ieNameW != NULL){
		delete []m_ieNameW;
	}

	if (itemW == NULL){
		m_ieNameW = NULL;
		return NULL;
	}
	
	len = wcslen(itemW) + 1;
	
	try{
		p = new wchar_t[len];
		if (p == NULL){
			return NULL;
		}
		wcscpy(p,itemW);
		m_ieNameW = p;
	}catch(...){
		return NULL;
	}
	return p;
}

char *Bookmark::setDescription(const char *item)
{
	char *p;
	int len;
	
	if (m_description != NULL){
		delete []m_description;
	}

	if (item == NULL){
		m_description = NULL;
		return NULL;
	}

	len = strlen(item) + 1;
	
	try{
		p = new char[len];
		if (p == NULL){
			return NULL;
		}
		strcpy(p,item);
		m_description = p;
	}catch(...){
		return NULL;
	}
	return p;
}

char *Bookmark::setShortcut(const char *item)
{
	char *p;
	int len;
	
	if (m_shortcut != NULL){
		delete []m_shortcut;
	}

	if (item == NULL){
		m_shortcut = NULL;
		return NULL;
	}
	
	len = strlen(item) + 1;
	
	try{
		p = new char[len];
		if (p == NULL){
			return NULL;
		}
		strcpy(p,item);
		m_shortcut = p;
	}catch(...){
		return NULL;
	}
	return p;
}

/**
 * ubN}[Nǉݒ肷B
 *
 * @param item ubN}[Nǉ()
 * @return ݒ肵ubN}[Nǉ
 */
time_t Bookmark::setAdddate(const char *item)
{
	char *p;

	m_create = (time_t)strtoul(item,&p,10);

	return m_create;
}

/**
 * ŌɖK₵ݒ肷B
 *
 * @param item ŌɖK₵()
 * @return ݒ肵ŌɖK₵
 */
time_t Bookmark::setLastvisit(const char *item)
{
	char *p;

	m_visit = (time_t)strtoul(item,&p,10);

	return m_visit;
}

/**
 * ŌɕҏWݒ肷B
 *
 * @param item ŌɕҏW()
 * @return ݒ肵ŌɕҏW
 */
time_t Bookmark::setModified(const char *item)
{
	char *p;

	m_modified = (time_t)strtoul(item,&p,10);

	return m_modified;
}

Bookmark::BookmarkType Bookmark::setItemType(Bookmark::BookmarkType itemtype)
{
	m_itemType = itemtype;
	return m_itemType;
}

/*
	ubN}[N̏Ԓli[B
	
		item	Ԃ̐l
	߂l
		ݒ肵Ԃ̐l
*/
int Bookmark::setOrder(const char *item)
{

	if (strlen(item) == 0){
		m_order = -1;
	}else{
		m_order = atoi(item);
	}

	return m_order;
}

/**
 * ACRURLi[(IE,Mozilla,SeaMonkey)
 *
 * @param item ACRURLꂽ
 * @return ACRURL
 */
char *Bookmark::setIcon(const char *item)
{
	char *p;
	int len;
	
	if (m_icon != NULL){
		delete []m_icon;
		m_icon = NULL;
	}

	if (item == NULL){
		return NULL;
	}

	len = strlen(item) + 1;
	
	try{
		p = new char[len];
		if (p == NULL){
			return NULL;
		}
		strcpy(p,item);
		m_icon = p;
	}catch(...){
		return NULL;
	}
	return p;
}


/**
 * ubN}[NRs[
 *
 * @param src ʌBookmarkNX̃CX^Xւ̃|C^
 * @return 0Œ
 */
int Bookmark::copyBookmark(Bookmark *src)
{
	copy(*src);

	return 0;
}

/**
 * Rs[RXgN^
 *
 * @param src ʌBookmarkNX̎Q
 * @return *this
 */
Bookmark & Bookmark::operator = (const Bookmark &src)
{
	copy(src);
	return *this;
}


/**
 * Ԃ̔rpI[o[[h֐
 *
 * @param target *this Ƃ rΏ
 * @return true *this < target false *this >= target
 */
bool Bookmark::operator < (const Bookmark &target)
{
	// c[o[͕Kŏ
	if ((getItemType() == Bookmark::folder) &&
		(getFolderType() == Bookmark::toolBar)) {
		return true;
	}
	if ((target.getItemType() == Bookmark::folder) &&
		(target.getFolderType() == Bookmark::toolBar)) {
		return false;
	}

	// j[o[̓c[o[̎
	if ((getItemType() == Bookmark::folder) &&
		(getFolderType() == Bookmark::menuBar)) {
		return true;
	}
	if ((target.getItemType() == Bookmark::folder) &&
		(target.getFolderType() == Bookmark::menuBar)) {
		return false;
	}

	int appliedSortMode;	// Kp\[g
	appliedSortMode = sortMode;

	if (sortMode == 0) {
		if (sortTarget == 0) {	// IȄꍇ
			if (getOrgOrder(sortTarget) < 0){
				if (target.getOrgOrder(sortTarget) < 0) {
					// IȄꍇA\[gȂꍇ̓fBNgD於OɂȂB
					appliedSortMode = 1;
				}
			}
		}
	}

	switch (appliedSortMode){
		case 0:	// [U[w菇
			if (getOrgOrder(sortTarget) < 0){
				if (target.getOrgOrder(sortTarget) < 0){
					// ɏԂȂꍇ͓
					return false;
				}else{
					// rԂȂꍇ͔r
					return false;
				}
			}
			if (target.getOrgOrder(sortTarget) < 0){
				// rɏԂĔrɏԂȂꍇ͔r悪
				return true;
			}
			if (getOrgOrder(sortTarget) < target.getOrgOrder(sortTarget)){
				return true;
			}else{
				return false;
			}
		//break;
		case 1:	// fBNgD於O
			// َ픻
			if (getItemType() == Bookmark::bookmark){	// bookmark
				if (target.getItemType() == Bookmark::folder){
					return false;
				}
			}else{	// folder
				if (target.getItemType() == Bookmark::bookmark){
					return true;
				}
			}
			// 
			if (getIeNameW() == NULL){
				if (target.getIeNameW() == NULL){
					return false;
				}else{
					return true;
				}
			}
			if (target.getIeNameW() == NULL){
				return false;
			}
			// if (_wcsicmp(getIeNameW(),target.getIeNameW()) < 0){
			if (_wcsicoll(getIeNameW(),target.getIeNameW()) < 0){
				return true;
			}
		break;
		case 2:	// SO
			if (getIeNameW() == NULL){
				if (target.getIeNameW() == NULL){
					return false;
				}else{
					return true;
				}
			}
			if (target.getIeNameW() == NULL){
				return false;
			}
			// if (_wcsicmp(getIeNameW(),target.getIeNameW()) < 0){
			if (_wcsicoll(getIeNameW(),target.getIeNameW()) < 0){
				return true;
			}
		break;
		case 3:	// URL
			if (getURL() == NULL){
				if (target.getURL() == NULL){
					return false;
				}else{
					return true;
				}
			}
			if (target.getURL() == NULL){
				return false;
			}
			if (strcmp(getURL(),target.getURL()) < 0){
				return true;
			}
		break;
		case 4:	// \[gsȂ(o)
			return false;
	}
	return false;
}

/**
 * place URI܂ނǂH
 *
 * @return true:place URI܂ false:placeURI܂܂Ȃ
 */
bool Bookmark::isPlaceURI()
{
	if (m_url == NULL) {
		return false;
	}
	if (!strncmp(m_url,PLACES_URL_PREFIX,6)) {
		return true;
	} else {
		return false;
	}
}
